/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationIpAddressType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsResource> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DnsResource.getter(DnsResource::domainName)).setter(DnsResource.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(DnsResource.getter(DnsResource::ipAddressTypeAsString)).setter(DnsResource.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, IP_ADDRESS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsResource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String ipAddressType;

    private DnsResource(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.ipAddressType = builder.ipAddressType;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ResourceConfigurationIpAddressType ipAddressType() {
        return ResourceConfigurationIpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsResource)) {
            return false;
        }
        DnsResource other = (DnsResource)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DnsResource").add("DomainName", (Object)this.domainName()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsResource, T> g) {
        return obj -> g.apply((DnsResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String ipAddressType;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsResource model) {
            this.domainName(model.domainName);
            this.ipAddressType(model.ipAddressType);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(ResourceConfigurationIpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public DnsResource build() {
            return new DnsResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsResource> {
        public Builder domainName(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(ResourceConfigurationIpAddressType var1);
    }
}

