/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ServiceNetworkResourceAssociationSummary;

public class ListServiceNetworkResourceAssociationsPublisher
implements SdkPublisher<ListServiceNetworkResourceAssociationsResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListServiceNetworkResourceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceNetworkResourceAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkResourceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceNetworkResourceAssociationsPublisher(VpcLatticeAsyncClient client, ListServiceNetworkResourceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceNetworkResourceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceNetworkResourceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceNetworkResourceAssociationSummary> items() {
        Function<ListServiceNetworkResourceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceNetworkResourceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceNetworkResourceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListServiceNetworkResourceAssociationsResponse> {
        private ListServiceNetworkResourceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceNetworkResourceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceNetworkResourceAssociationsResponse> nextPage(ListServiceNetworkResourceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceNetworkResourceAssociationsPublisher.this.client.listServiceNetworkResourceAssociations(ListServiceNetworkResourceAssociationsPublisher.this.firstRequest);
            }
            return ListServiceNetworkResourceAssociationsPublisher.this.client.listServiceNetworkResourceAssociations((ListServiceNetworkResourceAssociationsRequest)((Object)ListServiceNetworkResourceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

