/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessLogSubscriptionRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<CreateAccessLogSubscriptionRequest.Builder, CreateAccessLogSubscriptionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAccessLogSubscriptionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(CreateAccessLogSubscriptionRequest::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceIdentifier").getter(getter(CreateAccessLogSubscriptionRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build())
            .build();

    private static final SdkField<String> SERVICE_NETWORK_LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkLogType")
            .getter(getter(CreateAccessLogSubscriptionRequest::serviceNetworkLogTypeAsString))
            .setter(setter(Builder::serviceNetworkLogType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkLogType").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAccessLogSubscriptionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESTINATION_ARN_FIELD, RESOURCE_IDENTIFIER_FIELD, SERVICE_NETWORK_LOG_TYPE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String destinationArn;

    private final String resourceIdentifier;

    private final String serviceNetworkLogType;

    private final Map<String, String> tags;

    private CreateAccessLogSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.destinationArn = builder.destinationArn;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.serviceNetworkLogType = builder.serviceNetworkLogType;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
     * request that completed successfully using the same client token and parameters, the retry succeeds without
     * performing any actions. If the parameters aren't identical, the retry fails.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         retry a request that completed successfully using the same client token and parameters, the retry
     *         succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups,
     * Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log
     *         groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ID or ARN of the service network or service.
     * </p>
     * 
     * @return The ID or ARN of the service network or service.
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * The type of log that monitors your Amazon VPC Lattice service networks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNetworkLogType} will return {@link ServiceNetworkLogType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceNetworkLogTypeAsString}.
     * </p>
     * 
     * @return The type of log that monitors your Amazon VPC Lattice service networks.
     * @see ServiceNetworkLogType
     */
    public final ServiceNetworkLogType serviceNetworkLogType() {
        return ServiceNetworkLogType.fromValue(serviceNetworkLogType);
    }

    /**
     * <p>
     * The type of log that monitors your Amazon VPC Lattice service networks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNetworkLogType} will return {@link ServiceNetworkLogType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceNetworkLogTypeAsString}.
     * </p>
     * 
     * @return The type of log that monitors your Amazon VPC Lattice service networks.
     * @see ServiceNetworkLogType
     */
    public final String serviceNetworkLogTypeAsString() {
        return serviceNetworkLogType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the access log subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the access log subscription.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkLogTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessLogSubscriptionRequest)) {
            return false;
        }
        CreateAccessLogSubscriptionRequest other = (CreateAccessLogSubscriptionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(destinationArn(), other.destinationArn())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(serviceNetworkLogTypeAsString(), other.serviceNetworkLogTypeAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessLogSubscriptionRequest").add("ClientToken", clientToken())
                .add("DestinationArn", destinationArn()).add("ResourceIdentifier", resourceIdentifier())
                .add("ServiceNetworkLogType", serviceNetworkLogTypeAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "resourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "serviceNetworkLogType":
            return Optional.ofNullable(clazz.cast(serviceNetworkLogTypeAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("serviceNetworkLogType", SERVICE_NETWORK_LOG_TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessLogSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAccessLogSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessLogSubscriptionRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
         * request that completed successfully using the same client token and parameters, the retry succeeds without
         * performing any actions. If the parameters aren't identical, the retry fails.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        retry a request that completed successfully using the same client token and parameters, the retry
         *        succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups,
         * Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log
         *        groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ID or ARN of the service network or service.
         * </p>
         * 
         * @param resourceIdentifier
         *        The ID or ARN of the service network or service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * The type of log that monitors your Amazon VPC Lattice service networks.
         * </p>
         * 
         * @param serviceNetworkLogType
         *        The type of log that monitors your Amazon VPC Lattice service networks.
         * @see ServiceNetworkLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkLogType
         */
        Builder serviceNetworkLogType(String serviceNetworkLogType);

        /**
         * <p>
         * The type of log that monitors your Amazon VPC Lattice service networks.
         * </p>
         * 
         * @param serviceNetworkLogType
         *        The type of log that monitors your Amazon VPC Lattice service networks.
         * @see ServiceNetworkLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkLogType
         */
        Builder serviceNetworkLogType(ServiceNetworkLogType serviceNetworkLogType);

        /**
         * <p>
         * The tags for the access log subscription.
         * </p>
         * 
         * @param tags
         *        The tags for the access log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String destinationArn;

        private String resourceIdentifier;

        private String serviceNetworkLogType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessLogSubscriptionRequest model) {
            super(model);
            clientToken(model.clientToken);
            destinationArn(model.destinationArn);
            resourceIdentifier(model.resourceIdentifier);
            serviceNetworkLogType(model.serviceNetworkLogType);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getServiceNetworkLogType() {
            return serviceNetworkLogType;
        }

        public final void setServiceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
        }

        @Override
        public final Builder serviceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
            return this;
        }

        @Override
        public final Builder serviceNetworkLogType(ServiceNetworkLogType serviceNetworkLogType) {
            this.serviceNetworkLogType(serviceNetworkLogType == null ? null : serviceNetworkLogType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessLogSubscriptionRequest build() {
            return new CreateAccessLogSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
