/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterTargetsResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<DeregisterTargetsResponse.Builder, DeregisterTargetsResponse> {
    private static final SdkField<List<Target>> SUCCESSFUL_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("successful")
            .getter(getter(DeregisterTargetsResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetFailure>> UNSUCCESSFUL_FIELD = SdkField
            .<List<TargetFailure>> builder(MarshallingType.LIST)
            .memberName("unsuccessful")
            .getter(getter(DeregisterTargetsResponse::unsuccessful))
            .setter(setter(Builder::unsuccessful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unsuccessful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD,
            UNSUCCESSFUL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Target> successful;

    private final List<TargetFailure> unsuccessful;

    private DeregisterTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets that were successfully deregistered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return The targets that were successfully deregistered.
     */
    public final List<Target> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Unsuccessful property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnsuccessful() {
        return unsuccessful != null && !(unsuccessful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets that the operation couldn't deregister.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnsuccessful} method.
     * </p>
     * 
     * @return The targets that the operation couldn't deregister.
     */
    public final List<TargetFailure> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnsuccessful() ? unsuccessful() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterTargetsResponse)) {
            return false;
        }
        DeregisterTargetsResponse other = (DeregisterTargetsResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasUnsuccessful() == other.hasUnsuccessful() && Objects.equals(unsuccessful(), other.unsuccessful());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterTargetsResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Unsuccessful", hasUnsuccessful() ? unsuccessful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "unsuccessful":
            return Optional.ofNullable(clazz.cast(unsuccessful()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("successful", SUCCESSFUL_FIELD);
        map.put("unsuccessful", UNSUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeregisterTargetsResponse, T> g) {
        return obj -> g.apply((DeregisterTargetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterTargetsResponse> {
        /**
         * <p>
         * The targets that were successfully deregistered.
         * </p>
         * 
         * @param successful
         *        The targets that were successfully deregistered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<Target> successful);

        /**
         * <p>
         * The targets that were successfully deregistered.
         * </p>
         * 
         * @param successful
         *        The targets that were successfully deregistered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Target... successful);

        /**
         * <p>
         * The targets that were successfully deregistered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.vpclattice.model.Target.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.vpclattice.model.Target#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.vpclattice.model.Target.Builder#build()} is called immediately and its
         * result is passed to {@link #successful(List<Target>)}.
         * 
         * @param successful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.vpclattice.model.Target.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(java.util.Collection<Target>)
         */
        Builder successful(Consumer<Target.Builder>... successful);

        /**
         * <p>
         * The targets that the operation couldn't deregister.
         * </p>
         * 
         * @param unsuccessful
         *        The targets that the operation couldn't deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<TargetFailure> unsuccessful);

        /**
         * <p>
         * The targets that the operation couldn't deregister.
         * </p>
         * 
         * @param unsuccessful
         *        The targets that the operation couldn't deregister.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(TargetFailure... unsuccessful);

        /**
         * <p>
         * The targets that the operation couldn't deregister.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.vpclattice.model.TargetFailure.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.vpclattice.model.TargetFailure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.vpclattice.model.TargetFailure.Builder#build()} is called immediately
         * and its result is passed to {@link #unsuccessful(List<TargetFailure>)}.
         * 
         * @param unsuccessful
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.vpclattice.model.TargetFailure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsuccessful(java.util.Collection<TargetFailure>)
         */
        Builder unsuccessful(Consumer<TargetFailure.Builder>... unsuccessful);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private List<Target> successful = DefaultSdkAutoConstructList.getInstance();

        private List<TargetFailure> unsuccessful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterTargetsResponse model) {
            super(model);
            successful(model.successful);
            unsuccessful(model.unsuccessful);
        }

        public final List<Target.Builder> getSuccessful() {
            List<Target.Builder> result = TargetListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<Target.BuilderImpl> successful) {
            this.successful = TargetListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<Target> successful) {
            this.successful = TargetListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Target... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<Target.Builder>... successful) {
            successful(Stream.of(successful).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TargetFailure.Builder> getUnsuccessful() {
            List<TargetFailure.Builder> result = TargetFailureListCopier.copyToBuilder(this.unsuccessful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnsuccessful(Collection<TargetFailure.BuilderImpl> unsuccessful) {
            this.unsuccessful = TargetFailureListCopier.copyFromBuilder(unsuccessful);
        }

        @Override
        public final Builder unsuccessful(Collection<TargetFailure> unsuccessful) {
            this.unsuccessful = TargetFailureListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(TargetFailure... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(Consumer<TargetFailure.Builder>... unsuccessful) {
            unsuccessful(Stream.of(unsuccessful).map(c -> TargetFailure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeregisterTargetsResponse build() {
            return new DeregisterTargetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
