/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes criteria that can be applied to incoming requests.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpMatch implements SdkPojo, Serializable, ToCopyableBuilder<HttpMatch.Builder, HttpMatch> {
    private static final SdkField<List<HeaderMatch>> HEADER_MATCHES_FIELD = SdkField
            .<List<HeaderMatch>> builder(MarshallingType.LIST)
            .memberName("headerMatches")
            .getter(getter(HttpMatch::headerMatches))
            .setter(setter(Builder::headerMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headerMatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HeaderMatch> builder(MarshallingType.SDK_POJO)
                                            .constructor(HeaderMatch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("method")
            .getter(getter(HttpMatch::method)).setter(setter(Builder::method))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("method").build()).build();

    private static final SdkField<PathMatch> PATH_MATCH_FIELD = SdkField.<PathMatch> builder(MarshallingType.SDK_POJO)
            .memberName("pathMatch").getter(getter(HttpMatch::pathMatch)).setter(setter(Builder::pathMatch))
            .constructor(PathMatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pathMatch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_MATCHES_FIELD,
            METHOD_FIELD, PATH_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<HeaderMatch> headerMatches;

    private final String method;

    private final PathMatch pathMatch;

    private HttpMatch(BuilderImpl builder) {
        this.headerMatches = builder.headerMatches;
        this.method = builder.method;
        this.pathMatch = builder.pathMatch;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeaderMatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeaderMatches() {
        return headerMatches != null && !(headerMatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The header matches. Matches incoming requests with rule based on request header value before applying rule
     * action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaderMatches} method.
     * </p>
     * 
     * @return The header matches. Matches incoming requests with rule based on request header value before applying
     *         rule action.
     */
    public final List<HeaderMatch> headerMatches() {
        return headerMatches;
    }

    /**
     * <p>
     * The HTTP method type.
     * </p>
     * 
     * @return The HTTP method type.
     */
    public final String method() {
        return method;
    }

    /**
     * <p>
     * The path match.
     * </p>
     * 
     * @return The path match.
     */
    public final PathMatch pathMatch() {
        return pathMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderMatches() ? headerMatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(method());
        hashCode = 31 * hashCode + Objects.hashCode(pathMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpMatch)) {
            return false;
        }
        HttpMatch other = (HttpMatch) obj;
        return hasHeaderMatches() == other.hasHeaderMatches() && Objects.equals(headerMatches(), other.headerMatches())
                && Objects.equals(method(), other.method()) && Objects.equals(pathMatch(), other.pathMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpMatch").add("HeaderMatches", hasHeaderMatches() ? headerMatches() : null)
                .add("Method", method()).add("PathMatch", pathMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headerMatches":
            return Optional.ofNullable(clazz.cast(headerMatches()));
        case "method":
            return Optional.ofNullable(clazz.cast(method()));
        case "pathMatch":
            return Optional.ofNullable(clazz.cast(pathMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("headerMatches", HEADER_MATCHES_FIELD);
        map.put("method", METHOD_FIELD);
        map.put("pathMatch", PATH_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HttpMatch, T> g) {
        return obj -> g.apply((HttpMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpMatch> {
        /**
         * <p>
         * The header matches. Matches incoming requests with rule based on request header value before applying rule
         * action.
         * </p>
         * 
         * @param headerMatches
         *        The header matches. Matches incoming requests with rule based on request header value before applying
         *        rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerMatches(Collection<HeaderMatch> headerMatches);

        /**
         * <p>
         * The header matches. Matches incoming requests with rule based on request header value before applying rule
         * action.
         * </p>
         * 
         * @param headerMatches
         *        The header matches. Matches incoming requests with rule based on request header value before applying
         *        rule action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerMatches(HeaderMatch... headerMatches);

        /**
         * <p>
         * The header matches. Matches incoming requests with rule based on request header value before applying rule
         * action.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.vpclattice.model.HeaderMatch.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.vpclattice.model.HeaderMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.vpclattice.model.HeaderMatch.Builder#build()} is called immediately
         * and its result is passed to {@link #headerMatches(List<HeaderMatch>)}.
         * 
         * @param headerMatches
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.vpclattice.model.HeaderMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #headerMatches(java.util.Collection<HeaderMatch>)
         */
        Builder headerMatches(Consumer<HeaderMatch.Builder>... headerMatches);

        /**
         * <p>
         * The HTTP method type.
         * </p>
         * 
         * @param method
         *        The HTTP method type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder method(String method);

        /**
         * <p>
         * The path match.
         * </p>
         * 
         * @param pathMatch
         *        The path match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pathMatch(PathMatch pathMatch);

        /**
         * <p>
         * The path match.
         * </p>
         * This is a convenience method that creates an instance of the {@link PathMatch.Builder} avoiding the need to
         * create one manually via {@link PathMatch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PathMatch.Builder#build()} is called immediately and its result
         * is passed to {@link #pathMatch(PathMatch)}.
         * 
         * @param pathMatch
         *        a consumer that will call methods on {@link PathMatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pathMatch(PathMatch)
         */
        default Builder pathMatch(Consumer<PathMatch.Builder> pathMatch) {
            return pathMatch(PathMatch.builder().applyMutation(pathMatch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<HeaderMatch> headerMatches = DefaultSdkAutoConstructList.getInstance();

        private String method;

        private PathMatch pathMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpMatch model) {
            headerMatches(model.headerMatches);
            method(model.method);
            pathMatch(model.pathMatch);
        }

        public final List<HeaderMatch.Builder> getHeaderMatches() {
            List<HeaderMatch.Builder> result = HeaderMatchListCopier.copyToBuilder(this.headerMatches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeaderMatches(Collection<HeaderMatch.BuilderImpl> headerMatches) {
            this.headerMatches = HeaderMatchListCopier.copyFromBuilder(headerMatches);
        }

        @Override
        public final Builder headerMatches(Collection<HeaderMatch> headerMatches) {
            this.headerMatches = HeaderMatchListCopier.copy(headerMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerMatches(HeaderMatch... headerMatches) {
            headerMatches(Arrays.asList(headerMatches));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerMatches(Consumer<HeaderMatch.Builder>... headerMatches) {
            headerMatches(Stream.of(headerMatches).map(c -> HeaderMatch.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMethod() {
            return method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        public final PathMatch.Builder getPathMatch() {
            return pathMatch != null ? pathMatch.toBuilder() : null;
        }

        public final void setPathMatch(PathMatch.BuilderImpl pathMatch) {
            this.pathMatch = pathMatch != null ? pathMatch.build() : null;
        }

        @Override
        public final Builder pathMatch(PathMatch pathMatch) {
            this.pathMatch = pathMatch;
            return this;
        }

        @Override
        public HttpMatch build() {
            return new HttpMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
