/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a resource configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceConfigurationSummary.Builder, ResourceConfigurationSummary> {
    private static final SdkField<Boolean> AMAZON_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("amazonManaged").getter(getter(ResourceConfigurationSummary::amazonManaged))
            .setter(setter(Builder::amazonManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonManaged").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceConfigurationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ResourceConfigurationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ResourceConfigurationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(ResourceConfigurationSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ResourceConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupId")
            .getter(getter(ResourceConfigurationSummary::resourceConfigurationGroupId))
            .setter(setter(Builder::resourceConfigurationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId")
                    .build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayId").getter(getter(ResourceConfigurationSummary::resourceGatewayId))
            .setter(setter(Builder::resourceGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResourceConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ResourceConfigurationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_MANAGED_FIELD,
            ARN_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD,
            RESOURCE_GATEWAY_ID_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean amazonManaged;

    private final String arn;

    private final Instant createdAt;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String name;

    private final String resourceConfigurationGroupId;

    private final String resourceGatewayId;

    private final String status;

    private final String type;

    private ResourceConfigurationSummary(BuilderImpl builder) {
        this.amazonManaged = builder.amazonManaged;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * Indicates whether the resource configuration was created and is managed by Amazon.
     * </p>
     * 
     * @return Indicates whether the resource configuration was created and is managed by Amazon.
     */
    public final Boolean amazonManaged() {
        return amazonManaged;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the resource configuration was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the resource configuration was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     * </p>
     * 
     * @return The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the resource configuration.
     * </p>
     * 
     * @return The name of the resource configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the group resource configuration.
     * </p>
     * 
     * @return The ID of the group resource configuration.
     */
    public final String resourceConfigurationGroupId() {
        return resourceConfigurationGroupId;
    }

    /**
     * <p>
     * The ID of the resource gateway.
     * </p>
     * 
     * @return The ID of the resource gateway.
     */
    public final String resourceGatewayId() {
        return resourceGatewayId;
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonManaged());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigurationSummary)) {
            return false;
        }
        ResourceConfigurationSummary other = (ResourceConfigurationSummary) obj;
        return Objects.equals(amazonManaged(), other.amazonManaged()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(resourceConfigurationGroupId(), other.resourceConfigurationGroupId())
                && Objects.equals(resourceGatewayId(), other.resourceGatewayId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceConfigurationSummary").add("AmazonManaged", amazonManaged()).add("Arn", arn())
                .add("CreatedAt", createdAt()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("ResourceConfigurationGroupId", resourceConfigurationGroupId())
                .add("ResourceGatewayId", resourceGatewayId()).add("Status", statusAsString()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amazonManaged":
            return Optional.ofNullable(clazz.cast(amazonManaged()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "resourceConfigurationGroupId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupId()));
        case "resourceGatewayId":
            return Optional.ofNullable(clazz.cast(resourceGatewayId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amazonManaged", AMAZON_MANAGED_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigurationSummary, T> g) {
        return obj -> g.apply((ResourceConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfigurationSummary> {
        /**
         * <p>
         * Indicates whether the resource configuration was created and is managed by Amazon.
         * </p>
         * 
         * @param amazonManaged
         *        Indicates whether the resource configuration was created and is managed by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonManaged(Boolean amazonManaged);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the resource configuration was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the resource configuration was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param id
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the resource configuration.
         * </p>
         * 
         * @param name
         *        The name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupId
         *        The ID of the group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupId(String resourceConfigurationGroupId);

        /**
         * <p>
         * The ID of the resource gateway.
         * </p>
         * 
         * @param resourceGatewayId
         *        The ID of the resource gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayId(String resourceGatewayId);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(ResourceConfigurationStatus status);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(ResourceConfigurationType type);
    }

    static final class BuilderImpl implements Builder {
        private Boolean amazonManaged;

        private String arn;

        private Instant createdAt;

        private String id;

        private Instant lastUpdatedAt;

        private String name;

        private String resourceConfigurationGroupId;

        private String resourceGatewayId;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigurationSummary model) {
            amazonManaged(model.amazonManaged);
            arn(model.arn);
            createdAt(model.createdAt);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            resourceGatewayId(model.resourceGatewayId);
            status(model.status);
            type(model.type);
        }

        public final Boolean getAmazonManaged() {
            return amazonManaged;
        }

        public final void setAmazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
        }

        @Override
        public final Builder amazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getResourceGatewayId() {
            return resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ResourceConfigurationSummary build() {
            return new ResourceConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
