/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a rule update that failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleUpdateFailure implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleUpdateFailure.Builder, RuleUpdateFailure> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(RuleUpdateFailure::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(RuleUpdateFailure::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> RULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleIdentifier").getter(getter(RuleUpdateFailure::ruleIdentifier))
            .setter(setter(Builder::ruleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD,
            FAILURE_MESSAGE_FIELD, RULE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String failureCode;

    private final String failureMessage;

    private final String ruleIdentifier;

    private RuleUpdateFailure(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.ruleIdentifier = builder.ruleIdentifier;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * 
     * @return The failure code.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The failure message.
     * </p>
     * 
     * @return The failure message.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The ID or ARN of the rule.
     * </p>
     * 
     * @return The ID or ARN of the rule.
     */
    public final String ruleIdentifier() {
        return ruleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(ruleIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleUpdateFailure)) {
            return false;
        }
        RuleUpdateFailure other = (RuleUpdateFailure) obj;
        return Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(ruleIdentifier(), other.ruleIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleUpdateFailure").add("FailureCode", failureCode()).add("FailureMessage", failureMessage())
                .add("RuleIdentifier", ruleIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "ruleIdentifier":
            return Optional.ofNullable(clazz.cast(ruleIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("ruleIdentifier", RULE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleUpdateFailure, T> g) {
        return obj -> g.apply((RuleUpdateFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleUpdateFailure> {
        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure message.
         * </p>
         * 
         * @param failureMessage
         *        The failure message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The ID or ARN of the rule.
         * </p>
         * 
         * @param ruleIdentifier
         *        The ID or ARN of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleIdentifier(String ruleIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String failureCode;

        private String failureMessage;

        private String ruleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleUpdateFailure model) {
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
            ruleIdentifier(model.ruleIdentifier);
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getRuleIdentifier() {
            return ruleIdentifier;
        }

        public final void setRuleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
        }

        @Override
        public final Builder ruleIdentifier(String ruleIdentifier) {
            this.ruleIdentifier = ruleIdentifier;
            return this;
        }

        @Override
        public RuleUpdateFailure build() {
            return new RuleUpdateFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
