/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a target failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetFailure implements SdkPojo, Serializable, ToCopyableBuilder<TargetFailure.Builder, TargetFailure> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(TargetFailure::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(TargetFailure::failureMessage)).setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TargetFailure::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(TargetFailure::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD,
            FAILURE_MESSAGE_FIELD, ID_FIELD, PORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String failureCode;

    private final String failureMessage;

    private final String id;

    private final Integer port;

    private TargetFailure(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.failureMessage = builder.failureMessage;
        this.id = builder.id;
        this.port = builder.port;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * 
     * @return The failure code.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The failure message.
     * </p>
     * 
     * @return The failure message.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the target
     * group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>, this is
     * the ARN of a Lambda function. If the target group type is <code>ALB</code>, this is the ARN of an Application
     * Load Balancer.
     * </p>
     * 
     * @return The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the
     *         target group type is <code>IP</code>, this is an IP address. If the target group type is
     *         <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target group type is <code>ALB</code>,
     *         this is the ARN of an Application Load Balancer.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The port on which the target is listening. This parameter doesn't apply if the target is a Lambda function.
     * </p>
     * 
     * @return The port on which the target is listening. This parameter doesn't apply if the target is a Lambda
     *         function.
     */
    public final Integer port() {
        return port;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetFailure)) {
            return false;
        }
        TargetFailure other = (TargetFailure) obj;
        return Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(id(), other.id()) && Objects.equals(port(), other.port());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetFailure").add("FailureCode", failureCode()).add("FailureMessage", failureMessage())
                .add("Id", id()).add("Port", port()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("id", ID_FIELD);
        map.put("port", PORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetFailure, T> g) {
        return obj -> g.apply((TargetFailure) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetFailure> {
        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure message.
         * </p>
         * 
         * @param failureMessage
         *        The failure message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the
         * target group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>,
         * this is the ARN of a Lambda function. If the target group type is <code>ALB</code>, this is the ARN of an
         * Application Load Balancer.
         * </p>
         * 
         * @param id
         *        The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If
         *        the target group type is <code>IP</code>, this is an IP address. If the target group type is
         *        <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target group type is
         *        <code>ALB</code>, this is the ARN of an Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The port on which the target is listening. This parameter doesn't apply if the target is a Lambda function.
         * </p>
         * 
         * @param port
         *        The port on which the target is listening. This parameter doesn't apply if the target is a Lambda
         *        function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);
    }

    static final class BuilderImpl implements Builder {
        private String failureCode;

        private String failureMessage;

        private String id;

        private Integer port;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetFailure model) {
            failureCode(model.failureCode);
            failureMessage(model.failureMessage);
            id(model.id);
            port(model.port);
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        @Override
        public TargetFailure build() {
            return new TargetFailure(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
