/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceConfigurationRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<UpdateResourceConfigurationRequest.Builder, UpdateResourceConfigurationRequest> {
    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAssociationToShareableServiceNetwork")
            .getter(getter(UpdateResourceConfigurationRequest::allowAssociationToShareableServiceNetwork))
            .setter(setter(Builder::allowAssociationToShareableServiceNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowAssociationToShareableServiceNetwork").build()).build();

    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("portRanges")
            .getter(getter(UpdateResourceConfigurationRequest::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<ResourceConfigurationDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("resourceConfigurationDefinition")
            .getter(getter(UpdateResourceConfigurationRequest::resourceConfigurationDefinition))
            .setter(setter(Builder::resourceConfigurationDefinition))
            .constructor(ResourceConfigurationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition")
                    .build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationIdentifier")
            .getter(getter(UpdateResourceConfigurationRequest::resourceConfigurationIdentifier))
            .setter(setter(Builder::resourceConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceConfigurationIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, PORT_RANGES_FIELD, RESOURCE_CONFIGURATION_DEFINITION_FIELD,
            RESOURCE_CONFIGURATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean allowAssociationToShareableServiceNetwork;

    private final List<String> portRanges;

    private final ResourceConfigurationDefinition resourceConfigurationDefinition;

    private final String resourceConfigurationIdentifier;

    private UpdateResourceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.portRanges = builder.portRanges;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.resourceConfigurationIdentifier = builder.resourceConfigurationIdentifier;
    }

    /**
     * <p>
     * Indicates whether to add the resource configuration to service networks that are shared with other accounts.
     * </p>
     * 
     * @return Indicates whether to add the resource configuration to service networks that are shared with other
     *         accounts.
     */
    public final Boolean allowAssociationToShareableServiceNetwork() {
        return allowAssociationToShareableServiceNetwork;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges with
     * a comma. Example: 1-65535 or 1,2,22-30
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
     *         ranges with a comma. Example: 1-65535 or 1,2,22-30
     */
    public final List<String> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * The resource configuration.
     * </p>
     * 
     * @return The resource configuration.
     */
    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return resourceConfigurationDefinition;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String resourceConfigurationIdentifier() {
        return resourceConfigurationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceConfigurationRequest)) {
            return false;
        }
        UpdateResourceConfigurationRequest other = (UpdateResourceConfigurationRequest) obj;
        return Objects.equals(allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(resourceConfigurationDefinition(), other.resourceConfigurationDefinition())
                && Objects.equals(resourceConfigurationIdentifier(), other.resourceConfigurationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceConfigurationRequest")
                .add("AllowAssociationToShareableServiceNetwork", allowAssociationToShareableServiceNetwork())
                .add("PortRanges", hasPortRanges() ? portRanges() : null)
                .add("ResourceConfigurationDefinition", resourceConfigurationDefinition())
                .add("ResourceConfigurationIdentifier", resourceConfigurationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowAssociationToShareableServiceNetwork":
            return Optional.ofNullable(clazz.cast(allowAssociationToShareableServiceNetwork()));
        case "portRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "resourceConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(resourceConfigurationDefinition()));
        case "resourceConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(resourceConfigurationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("resourceConfigurationIdentifier", RESOURCE_CONFIGURATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateResourceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResourceConfigurationRequest> {
        /**
         * <p>
         * Indicates whether to add the resource configuration to service networks that are shared with other accounts.
         * </p>
         * 
         * @param allowAssociationToShareableServiceNetwork
         *        Indicates whether to add the resource configuration to service networks that are shared with other
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<String> portRanges);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(String... portRanges);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * 
         * @param resourceConfigurationDefinition
         *        The resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfigurationDefinition.Builder}
         * avoiding the need to create one manually via {@link ResourceConfigurationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfigurationDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourceConfigurationDefinition(ResourceConfigurationDefinition)}.
         * 
         * @param resourceConfigurationDefinition
         *        a consumer that will call methods on {@link ResourceConfigurationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfigurationDefinition(ResourceConfigurationDefinition)
         */
        default Builder resourceConfigurationDefinition(
                Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return resourceConfigurationDefinition(ResourceConfigurationDefinition.builder()
                    .applyMutation(resourceConfigurationDefinition).build());
        }

        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationIdentifier
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private Boolean allowAssociationToShareableServiceNetwork;

        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();

        private ResourceConfigurationDefinition resourceConfigurationDefinition;

        private String resourceConfigurationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceConfigurationRequest model) {
            super(model);
            allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            portRanges(model.portRanges);
            resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            resourceConfigurationIdentifier(model.resourceConfigurationIdentifier);
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return resourceConfigurationDefinition != null ? resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(
                ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition
                    .build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final String getResourceConfigurationIdentifier() {
            return resourceConfigurationIdentifier;
        }

        public final void setResourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
        }

        @Override
        public final Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceConfigurationRequest build() {
            return new UpdateResourceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
