/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceNetworkRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<UpdateServiceNetworkRequest.Builder, UpdateServiceNetworkRequest> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(UpdateServiceNetworkRequest::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkIdentifier").getter(getter(UpdateServiceNetworkRequest::serviceNetworkIdentifier))
            .setter(setter(Builder::serviceNetworkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceNetworkIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD,
            SERVICE_NETWORK_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authType;

    private final String serviceNetworkIdentifier;

    private UpdateServiceNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.authType = builder.authType;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy
     * is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
     *         auth policy is required.
     *         </p>
     *         </li>
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy
     * is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
     *         auth policy is required.
     *         </p>
     *         </li>
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The ID or ARN of the service network.
     * </p>
     * 
     * @return The ID or ARN of the service network.
     */
    public final String serviceNetworkIdentifier() {
        return serviceNetworkIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceNetworkRequest)) {
            return false;
        }
        UpdateServiceNetworkRequest other = (UpdateServiceNetworkRequest) obj;
        return Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(serviceNetworkIdentifier(), other.serviceNetworkIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceNetworkRequest").add("AuthType", authTypeAsString())
                .add("ServiceNetworkIdentifier", serviceNetworkIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "serviceNetworkIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceNetworkRequest, T> g) {
        return obj -> g.apply((UpdateServiceNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceNetworkRequest> {
        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth
         * policy is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authType
         *        The type of IAM policy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
         *        auth policy is required.
         *        </p>
         *        </li>
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth
         * policy is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authType
         *        The type of IAM policy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
         *        auth policy is required.
         *        </p>
         *        </li>
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * The ID or ARN of the service network.
         * </p>
         * 
         * @param serviceNetworkIdentifier
         *        The ID or ARN of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkIdentifier(String serviceNetworkIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String authType;

        private String serviceNetworkIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceNetworkRequest model) {
            super(model);
            authType(model.authType);
            serviceNetworkIdentifier(model.serviceNetworkIdentifier);
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceNetworkRequest build() {
            return new UpdateServiceNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
