/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.vpclattice.VpcLatticeAsyncClient;
import software.amazon.awssdk.services.vpclattice.internal.UserAgentUtils;
import software.amazon.awssdk.services.vpclattice.model.ListListenersRequest;
import software.amazon.awssdk.services.vpclattice.model.ListListenersResponse;
import software.amazon.awssdk.services.vpclattice.model.ListenerSummary;

public class ListListenersPublisher
implements SdkPublisher<ListListenersResponse> {
    private final VpcLatticeAsyncClient client;
    private final ListListenersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListListenersPublisher(VpcLatticeAsyncClient client, ListListenersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListListenersPublisher(VpcLatticeAsyncClient client, ListListenersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListListenersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListListenersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListenerSummary> items() {
        Function<ListListenersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListListenersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListListenersResponseFetcher
    implements AsyncPageFetcher<ListListenersResponse> {
        private ListListenersResponseFetcher() {
        }

        public boolean hasNextPage(ListListenersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListListenersResponse> nextPage(ListListenersResponse previousPage) {
            if (previousPage == null) {
                return ListListenersPublisher.this.client.listListeners(ListListenersPublisher.this.firstRequest);
            }
            return ListListenersPublisher.this.client.listListeners((ListListenersRequest)((Object)ListListenersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

