/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig;
import software.amazon.awssdk.services.vpclattice.model.IpAddressType;
import software.amazon.awssdk.services.vpclattice.model.LambdaEventStructureVersion;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocol;
import software.amazon.awssdk.services.vpclattice.model.TargetGroupProtocolVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetGroupConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetGroupConfig> {
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthCheck").getter(TargetGroupConfig.getter(TargetGroupConfig::healthCheck)).setter(TargetGroupConfig.setter(Builder::healthCheck)).constructor(HealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(TargetGroupConfig.getter(TargetGroupConfig::ipAddressTypeAsString)).setter(TargetGroupConfig.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<String> LAMBDA_EVENT_STRUCTURE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lambdaEventStructureVersion").getter(TargetGroupConfig.getter(TargetGroupConfig::lambdaEventStructureVersionAsString)).setter(TargetGroupConfig.setter(Builder::lambdaEventStructureVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaEventStructureVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(TargetGroupConfig.getter(TargetGroupConfig::port)).setter(TargetGroupConfig.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(TargetGroupConfig.getter(TargetGroupConfig::protocolAsString)).setter(TargetGroupConfig.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<String> PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocolVersion").getter(TargetGroupConfig.getter(TargetGroupConfig::protocolVersionAsString)).setter(TargetGroupConfig.setter(Builder::protocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolVersion").build()}).build();
    private static final SdkField<String> VPC_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vpcIdentifier").getter(TargetGroupConfig.getter(TargetGroupConfig::vpcIdentifier)).setter(TargetGroupConfig.setter(Builder::vpcIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD, IP_ADDRESS_TYPE_FIELD, LAMBDA_EVENT_STRUCTURE_VERSION_FIELD, PORT_FIELD, PROTOCOL_FIELD, PROTOCOL_VERSION_FIELD, VPC_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TargetGroupConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final HealthCheckConfig healthCheck;
    private final String ipAddressType;
    private final String lambdaEventStructureVersion;
    private final Integer port;
    private final String protocol;
    private final String protocolVersion;
    private final String vpcIdentifier;

    private TargetGroupConfig(BuilderImpl builder) {
        this.healthCheck = builder.healthCheck;
        this.ipAddressType = builder.ipAddressType;
        this.lambdaEventStructureVersion = builder.lambdaEventStructureVersion;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.protocolVersion = builder.protocolVersion;
        this.vpcIdentifier = builder.vpcIdentifier;
    }

    public final HealthCheckConfig healthCheck() {
        return this.healthCheck;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final LambdaEventStructureVersion lambdaEventStructureVersion() {
        return LambdaEventStructureVersion.fromValue(this.lambdaEventStructureVersion);
    }

    public final String lambdaEventStructureVersionAsString() {
        return this.lambdaEventStructureVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final TargetGroupProtocol protocol() {
        return TargetGroupProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final TargetGroupProtocolVersion protocolVersion() {
        return TargetGroupProtocolVersion.fromValue(this.protocolVersion);
    }

    public final String protocolVersionAsString() {
        return this.protocolVersion;
    }

    public final String vpcIdentifier() {
        return this.vpcIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaEventStructureVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupConfig)) {
            return false;
        }
        TargetGroupConfig other = (TargetGroupConfig)obj;
        return Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.lambdaEventStructureVersionAsString(), other.lambdaEventStructureVersionAsString()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.protocolVersionAsString(), other.protocolVersionAsString()) && Objects.equals(this.vpcIdentifier(), other.vpcIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"TargetGroupConfig").add("HealthCheck", (Object)this.healthCheck()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("LambdaEventStructureVersion", (Object)this.lambdaEventStructureVersionAsString()).add("Port", (Object)this.port()).add("Protocol", (Object)this.protocolAsString()).add("ProtocolVersion", (Object)this.protocolVersionAsString()).add("VpcIdentifier", (Object)this.vpcIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "lambdaEventStructureVersion": {
                return Optional.ofNullable(clazz.cast(this.lambdaEventStructureVersionAsString()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "protocolVersion": {
                return Optional.ofNullable(clazz.cast(this.protocolVersionAsString()));
            }
            case "vpcIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("healthCheck", HEALTH_CHECK_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("lambdaEventStructureVersion", LAMBDA_EVENT_STRUCTURE_VERSION_FIELD);
        map.put("port", PORT_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("protocolVersion", PROTOCOL_VERSION_FIELD);
        map.put("vpcIdentifier", VPC_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupConfig, T> g) {
        return obj -> g.apply((TargetGroupConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HealthCheckConfig healthCheck;
        private String ipAddressType;
        private String lambdaEventStructureVersion;
        private Integer port;
        private String protocol;
        private String protocolVersion;
        private String vpcIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupConfig model) {
            this.healthCheck(model.healthCheck);
            this.ipAddressType(model.ipAddressType);
            this.lambdaEventStructureVersion(model.lambdaEventStructureVersion);
            this.port(model.port);
            this.protocol(model.protocol);
            this.protocolVersion(model.protocolVersion);
            this.vpcIdentifier(model.vpcIdentifier);
        }

        public final HealthCheckConfig.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(HealthCheckConfig.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getLambdaEventStructureVersion() {
            return this.lambdaEventStructureVersion;
        }

        public final void setLambdaEventStructureVersion(String lambdaEventStructureVersion) {
            this.lambdaEventStructureVersion = lambdaEventStructureVersion;
        }

        @Override
        public final Builder lambdaEventStructureVersion(String lambdaEventStructureVersion) {
            this.lambdaEventStructureVersion = lambdaEventStructureVersion;
            return this;
        }

        @Override
        public final Builder lambdaEventStructureVersion(LambdaEventStructureVersion lambdaEventStructureVersion) {
            this.lambdaEventStructureVersion(lambdaEventStructureVersion == null ? null : lambdaEventStructureVersion.toString());
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(TargetGroupProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getProtocolVersion() {
            return this.protocolVersion;
        }

        public final void setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        @Override
        public final Builder protocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        @Override
        public final Builder protocolVersion(TargetGroupProtocolVersion protocolVersion) {
            this.protocolVersion(protocolVersion == null ? null : protocolVersion.toString());
            return this;
        }

        public final String getVpcIdentifier() {
            return this.vpcIdentifier;
        }

        public final void setVpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
        }

        @Override
        public final Builder vpcIdentifier(String vpcIdentifier) {
            this.vpcIdentifier = vpcIdentifier;
            return this;
        }

        public TargetGroupConfig build() {
            return new TargetGroupConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetGroupConfig> {
        public Builder healthCheck(HealthCheckConfig var1);

        default public Builder healthCheck(Consumer<HealthCheckConfig.Builder> healthCheck) {
            return this.healthCheck((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheck)).build());
        }

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder lambdaEventStructureVersion(String var1);

        public Builder lambdaEventStructureVersion(LambdaEventStructureVersion var1);

        public Builder port(Integer var1);

        public Builder protocol(String var1);

        public Builder protocol(TargetGroupProtocol var1);

        public Builder protocolVersion(String var1);

        public Builder protocolVersion(TargetGroupProtocolVersion var1);

        public Builder vpcIdentifier(String var1);
    }
}

