/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.HealthCheckConfig;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTargetGroupRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, UpdateTargetGroupRequest> {
    private static final SdkField<HealthCheckConfig> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthCheck").getter(UpdateTargetGroupRequest.getter(UpdateTargetGroupRequest::healthCheck)).setter(UpdateTargetGroupRequest.setter(Builder::healthCheck)).constructor(HealthCheckConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final SdkField<String> TARGET_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetGroupIdentifier").getter(UpdateTargetGroupRequest.getter(UpdateTargetGroupRequest::targetGroupIdentifier)).setter(UpdateTargetGroupRequest.setter(Builder::targetGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("targetGroupIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD, TARGET_GROUP_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateTargetGroupRequest.memberNameToFieldInitializer();
    private final HealthCheckConfig healthCheck;
    private final String targetGroupIdentifier;

    private UpdateTargetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.healthCheck = builder.healthCheck;
        this.targetGroupIdentifier = builder.targetGroupIdentifier;
    }

    public final HealthCheckConfig healthCheck() {
        return this.healthCheck;
    }

    public final String targetGroupIdentifier() {
        return this.targetGroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTargetGroupRequest)) {
            return false;
        }
        UpdateTargetGroupRequest other = (UpdateTargetGroupRequest)((Object)obj);
        return Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.targetGroupIdentifier(), other.targetGroupIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTargetGroupRequest").add("HealthCheck", (Object)this.healthCheck()).add("TargetGroupIdentifier", (Object)this.targetGroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "targetGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetGroupIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("healthCheck", HEALTH_CHECK_FIELD);
        map.put("targetGroupIdentifier", TARGET_GROUP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTargetGroupRequest, T> g) {
        return obj -> g.apply((UpdateTargetGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private HealthCheckConfig healthCheck;
        private String targetGroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTargetGroupRequest model) {
            super(model);
            this.healthCheck(model.healthCheck);
            this.targetGroupIdentifier(model.targetGroupIdentifier);
        }

        public final HealthCheckConfig.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(HealthCheckConfig.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheckConfig healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final String getTargetGroupIdentifier() {
            return this.targetGroupIdentifier;
        }

        public final void setTargetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
        }

        @Override
        public final Builder targetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTargetGroupRequest build() {
            return new UpdateTargetGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTargetGroupRequest> {
        public Builder healthCheck(HealthCheckConfig var1);

        default public Builder healthCheck(Consumer<HealthCheckConfig.Builder> healthCheck) {
            return this.healthCheck((HealthCheckConfig)((HealthCheckConfig.Builder)HealthCheckConfig.builder().applyMutation(healthCheck)).build());
        }

        public Builder targetGroupIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

