/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.GetListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.GetListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.GetRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.GetRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListListenersRequest;
import software.amazon.awssdk.services.vpclattice.model.ListListenersResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse;
import software.amazon.awssdk.services.vpclattice.model.ListRulesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListRulesResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServicesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServicesResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.TagResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.TagResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.UntagResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.UntagResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListListenersPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListRulesPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListServicesPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsPublisher;
import software.amazon.awssdk.services.vpclattice.paginators.ListTargetsPublisher;

/**
 * Service client for accessing Amazon VPC Lattice asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon VPC Lattice is a fully managed application networking service that you use to connect, secure, and monitor all
 * of your services across multiple accounts and virtual private clouds (VPCs). Amazon VPC Lattice interconnects your
 * microservices and legacy services within a logical boundary, so that you can discover and manage them more
 * efficiently. For more information, see the <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/">Amazon VPC
 * Lattice User Guide</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface VpcLatticeAsyncClient extends AwsClient {
    String SERVICE_NAME = "vpc-lattice";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "vpc-lattice";

    /**
     * <p>
     * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This
     * can be useful when bulk updating or swapping rule priority.
     * </p>
     * <p>
     * <b>Required permissions:</b> <code>vpc-lattice:UpdateRule</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html">How Amazon VPC
     * Lattice works with IAM</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param batchUpdateRuleRequest
     * @return A Java Future containing the result of the BatchUpdateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.BatchUpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateRuleResponse> batchUpdateRule(BatchUpdateRuleRequest batchUpdateRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This
     * can be useful when bulk updating or swapping rule priority.
     * </p>
     * <p>
     * <b>Required permissions:</b> <code>vpc-lattice:UpdateRule</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html">How Amazon VPC
     * Lattice works with IAM</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateRuleRequest.Builder} avoiding the need
     * to create one manually via {@link BatchUpdateRuleRequest#builder()}
     * </p>
     *
     * @param batchUpdateRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.BatchUpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchUpdateRuleResponse> batchUpdateRule(
            Consumer<BatchUpdateRuleRequest.Builder> batchUpdateRuleRequest) {
        return batchUpdateRule(BatchUpdateRuleRequest.builder().applyMutation(batchUpdateRuleRequest).build());
    }

    /**
     * <p>
     * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service
     * network owner can use the access logs to audit the services in the network. The service network owner can only
     * see access logs from clients and services that are associated with their service network. Access log entries
     * represent traffic originated from VPCs associated with that network. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html">Access logs</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createAccessLogSubscriptionRequest
     * @return A Java Future containing the result of the CreateAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessLogSubscriptionResponse> createAccessLogSubscription(
            CreateAccessLogSubscriptionRequest createAccessLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service
     * network owner can use the access logs to audit the services in the network. The service network owner can only
     * see access logs from clients and services that are associated with their service network. Access log entries
     * represent traffic originated from VPCs associated with that network. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html">Access logs</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param createAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessLogSubscriptionResponse> createAccessLogSubscription(
            Consumer<CreateAccessLogSubscriptionRequest.Builder> createAccessLogSubscriptionRequest) {
        return createAccessLogSubscription(CreateAccessLogSubscriptionRequest.builder()
                .applyMutation(createAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or
     * more listeners. A listener is a process that checks for connection requests to your services. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html">Listeners</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createListenerRequest
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(CreateListenerRequest createListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or
     * more listeners. A listener is a process that checks for connection requests to your services. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html">Listeners</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateListenerResponse> createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest) {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Creates a resource configuration. A resource configuration defines a specific resource. You can associate a
     * resource configuration with a service network or a VPC endpoint.
     * </p>
     *
     * @param createResourceConfigurationRequest
     * @return A Java Future containing the result of the CreateResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceConfigurationResponse> createResourceConfiguration(
            CreateResourceConfigurationRequest createResourceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource configuration. A resource configuration defines a specific resource. You can associate a
     * resource configuration with a service network or a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param createResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceConfigurationResponse> createResourceConfiguration(
            Consumer<CreateResourceConfigurationRequest.Builder> createResourceConfigurationRequest) {
        return createResourceConfiguration(CreateResourceConfigurationRequest.builder()
                .applyMutation(createResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a resource gateway.
     * </p>
     *
     * @param createResourceGatewayRequest
     * @return A Java Future containing the result of the CreateResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceGatewayResponse> createResourceGateway(
            CreateResourceGatewayRequest createResourceGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceGatewayRequest#builder()}
     * </p>
     *
     * @param createResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateResourceGatewayResponse> createResourceGateway(
            Consumer<CreateResourceGatewayRequest.Builder> createResourceGatewayRequest) {
        return createResourceGateway(CreateResourceGatewayRequest.builder().applyMutation(createResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a service. A service is any software application that can run on instances containers, or serverless
     * functions within an account or virtual private cloud (VPC).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html">Services</a>
     * in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createServiceRequest
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service. A service is any software application that can run on instances containers, or serverless
     * functions within an account or virtual private cloud (VPC).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html">Services</a>
     * in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServiceRequest#builder()}
     * </p>
     *
     * @param createServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) {
        return createService(CreateServiceRequest.builder().applyMutation(createServiceRequest).build());
    }

    /**
     * <p>
     * Creates a service network. A service network is a logical boundary for a collection of services. You can
     * associate services and VPCs with a service network.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html">Service networks</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createServiceNetworkRequest
     * @return A Java Future containing the result of the CreateServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkResponse> createServiceNetwork(
            CreateServiceNetworkRequest createServiceNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service network. A service network is a logical boundary for a collection of services. You can
     * associate services and VPCs with a service network.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html">Service networks</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceNetworkRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkResponse> createServiceNetwork(
            Consumer<CreateServiceNetworkRequest.Builder> createServiceNetworkRequest) {
        return createServiceNetwork(CreateServiceNetworkRequest.builder().applyMutation(createServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Associates the specified service network with the specified resource configuration. This allows the resource
     * configuration to receive connections through the service network, including through a service network VPC
     * endpoint.
     * </p>
     *
     * @param createServiceNetworkResourceAssociationRequest
     * @return A Java Future containing the result of the CreateServiceNetworkResourceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkResourceAssociationResponse> createServiceNetworkResourceAssociation(
            CreateServiceNetworkResourceAssociationRequest createServiceNetworkResourceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified service network with the specified resource configuration. This allows the resource
     * configuration to receive connections through the service network, including through a service network VPC
     * endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateServiceNetworkResourceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkResourceAssociationResponse> createServiceNetworkResourceAssociation(
            Consumer<CreateServiceNetworkResourceAssociationRequest.Builder> createServiceNetworkResourceAssociationRequest) {
        return createServiceNetworkResourceAssociation(CreateServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(createServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified service with the specified service network. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations"
     * >Manage service associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if the service and service network are already associated or if there is a
     * disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the
     * association and recreating it.
     * </p>
     * <p>
     * You cannot associate a service and service network that are shared with a caller. The caller must own either the
     * service or the service network.
     * </p>
     * <p>
     * As a result of this operation, the association is created in the service network account and the association
     * owner account.
     * </p>
     *
     * @param createServiceNetworkServiceAssociationRequest
     * @return A Java Future containing the result of the CreateServiceNetworkServiceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkServiceAssociationResponse> createServiceNetworkServiceAssociation(
            CreateServiceNetworkServiceAssociationRequest createServiceNetworkServiceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified service with the specified service network. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations"
     * >Manage service associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if the service and service network are already associated or if there is a
     * disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the
     * association and recreating it.
     * </p>
     * <p>
     * You cannot associate a service and service network that are shared with a caller. The caller must own either the
     * service or the service network.
     * </p>
     * <p>
     * As a result of this operation, the association is created in the service network account and the association
     * owner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateServiceNetworkServiceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateServiceNetworkServiceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkServiceAssociationResponse> createServiceNetworkServiceAssociation(
            Consumer<CreateServiceNetworkServiceAssociationRequest.Builder> createServiceNetworkServiceAssociationRequest) {
        return createServiceNetworkServiceAssociation(CreateServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(createServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the
     * resources within that VPC to be clients and communicate with other services in the service network. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations"
     * >Manage VPC associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if there is a disassociation in progress. If the association fails, retry by
     * deleting the association and recreating it.
     * </p>
     * <p>
     * As a result of this operation, the association gets created in the service network account and the VPC owner
     * account.
     * </p>
     * <p>
     * If you add a security group to the service network and VPC association, the association must continue to always
     * have at least one security group. You can add or edit security groups at any time. However, to remove all
     * security groups, you must first delete the association and recreate it without security groups.
     * </p>
     *
     * @param createServiceNetworkVpcAssociationRequest
     * @return A Java Future containing the result of the CreateServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkVpcAssociationResponse> createServiceNetworkVpcAssociation(
            CreateServiceNetworkVpcAssociationRequest createServiceNetworkVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the
     * resources within that VPC to be clients and communicate with other services in the service network. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations"
     * >Manage VPC associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if there is a disassociation in progress. If the association fails, retry by
     * deleting the association and recreating it.
     * </p>
     * <p>
     * As a result of this operation, the association gets created in the service network account and the VPC owner
     * account.
     * </p>
     * <p>
     * If you add a security group to the service network and VPC association, the association must continue to always
     * have at least one security group. You can add or edit security groups at any time. However, to remove all
     * security groups, you must first delete the association and recreate it without security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateServiceNetworkVpcAssociationResponse> createServiceNetworkVpcAssociation(
            Consumer<CreateServiceNetworkVpcAssociationRequest.Builder> createServiceNetworkVpcAssociationRequest) {
        return createServiceNetworkVpcAssociation(CreateServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(createServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a target group. A target group is a collection of targets, or compute resources, that run your
     * application or service. A target group can only be used by a single service.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target
     * groups</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTargetGroupResponse> createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target group. A target group is a collection of targets, or compute resources, that run your
     * application or service. A target group can only be used by a single service.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target
     * groups</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTargetGroupRequest#builder()}
     * </p>
     *
     * @param createTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTargetGroupResponse> createTargetGroup(
            Consumer<CreateTargetGroupRequest.Builder> createTargetGroupRequest) {
        return createTargetGroup(CreateTargetGroupRequest.builder().applyMutation(createTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified access log subscription.
     * </p>
     *
     * @param deleteAccessLogSubscriptionRequest
     * @return A Java Future containing the result of the DeleteAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessLogSubscriptionResponse> deleteAccessLogSubscription(
            DeleteAccessLogSubscriptionRequest deleteAccessLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessLogSubscriptionResponse> deleteAccessLogSubscription(
            Consumer<DeleteAccessLogSubscriptionRequest.Builder> deleteAccessLogSubscriptionRequest) {
        return deleteAccessLogSubscription(DeleteAccessLogSubscriptionRequest.builder()
                .applyMutation(deleteAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified auth policy. If an auth is set to <code>AWS_IAM</code> and the auth policy is deleted, all
     * requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to
     * <code>NONE</code>. If auth is enabled on the resource, but no auth policy is set, all requests are denied.
     * </p>
     *
     * @param deleteAuthPolicyRequest
     * @return A Java Future containing the result of the DeleteAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAuthPolicyResponse> deleteAuthPolicy(DeleteAuthPolicyRequest deleteAuthPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified auth policy. If an auth is set to <code>AWS_IAM</code> and the auth policy is deleted, all
     * requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to
     * <code>NONE</code>. If auth is enabled on the resource, but no auth policy is set, all requests are denied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAuthPolicyResponse> deleteAuthPolicy(
            Consumer<DeleteAuthPolicyRequest.Builder> deleteAuthPolicyRequest) {
        return deleteAuthPolicy(DeleteAuthPolicyRequest.builder().applyMutation(deleteAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     *
     * @param deleteListenerRequest
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(DeleteListenerRequest deleteListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteListenerResponse> deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest) {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource configuration.
     * </p>
     *
     * @param deleteResourceConfigurationRequest
     * @return A Java Future containing the result of the DeleteResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigurationResponse> deleteResourceConfiguration(
            DeleteResourceConfigurationRequest deleteResourceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceConfigurationResponse> deleteResourceConfiguration(
            Consumer<DeleteResourceConfigurationRequest.Builder> deleteResourceConfigurationRequest) {
        return deleteResourceConfiguration(DeleteResourceConfigurationRequest.builder()
                .applyMutation(deleteResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Disassociates the resource configuration from the resource VPC endpoint.
     * </p>
     *
     * @param deleteResourceEndpointAssociationRequest
     * @return A Java Future containing the result of the DeleteResourceEndpointAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceEndpointAssociationResponse> deleteResourceEndpointAssociation(
            DeleteResourceEndpointAssociationRequest deleteResourceEndpointAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the resource configuration from the resource VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceEndpointAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourceEndpointAssociationRequest#builder()}
     * </p>
     *
     * @param deleteResourceEndpointAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteResourceEndpointAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceEndpointAssociationResponse> deleteResourceEndpointAssociation(
            Consumer<DeleteResourceEndpointAssociationRequest.Builder> deleteResourceEndpointAssociationRequest) {
        return deleteResourceEndpointAssociation(DeleteResourceEndpointAssociationRequest.builder()
                .applyMutation(deleteResourceEndpointAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource gateway.
     * </p>
     *
     * @param deleteResourceGatewayRequest
     * @return A Java Future containing the result of the DeleteResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceGatewayResponse> deleteResourceGateway(
            DeleteResourceGatewayRequest deleteResourceGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceGatewayRequest#builder()}
     * </p>
     *
     * @param deleteResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourceGatewayResponse> deleteResourceGateway(
            Consumer<DeleteResourceGatewayRequest.Builder> deleteResourceGatewayRequest) {
        return deleteResourceGateway(DeleteResourceGatewayRequest.builder().applyMutation(deleteResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can
     * delete additional listener rules, but you cannot delete the default rule.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can
     * delete additional listener rules, but you cannot delete the default rule.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service,
     * all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and
     * access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service">Delete a service</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteServiceRequest
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service,
     * all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and
     * access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service">Delete a service</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServiceRequest#builder()}
     * </p>
     *
     * @param deleteServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) {
        return deleteService(DeleteServiceRequest.builder().applyMutation(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Deletes a service network. You can only delete the service network if there is no service or VPC associated with
     * it. If you delete a service network, all resources related to the service network, such as the resource policy,
     * auth policy, and access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network">Delete a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteServiceNetworkRequest
     * @return A Java Future containing the result of the DeleteServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkResponse> deleteServiceNetwork(
            DeleteServiceNetworkRequest deleteServiceNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service network. You can only delete the service network if there is no service or VPC associated with
     * it. If you delete a service network, all resources related to the service network, such as the resource policy,
     * auth policy, and access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network">Delete a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceNetworkRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkResponse> deleteServiceNetwork(
            Consumer<DeleteServiceNetworkRequest.Builder> deleteServiceNetworkRequest) {
        return deleteServiceNetwork(DeleteServiceNetworkRequest.builder().applyMutation(deleteServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes the association between a service network and a resource configuration.
     * </p>
     *
     * @param deleteServiceNetworkResourceAssociationRequest
     * @return A Java Future containing the result of the DeleteServiceNetworkResourceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkResourceAssociationResponse> deleteServiceNetworkResourceAssociation(
            DeleteServiceNetworkResourceAssociationRequest deleteServiceNetworkResourceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteServiceNetworkResourceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkResourceAssociationResponse> deleteServiceNetworkResourceAssociation(
            Consumer<DeleteServiceNetworkResourceAssociationRequest.Builder> deleteServiceNetworkResourceAssociationRequest) {
        return deleteServiceNetworkResourceAssociation(DeleteServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the association between a service and a service network. This operation fails if an association is still
     * in progress.
     * </p>
     *
     * @param deleteServiceNetworkServiceAssociationRequest
     * @return A Java Future containing the result of the DeleteServiceNetworkServiceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkServiceAssociationResponse> deleteServiceNetworkServiceAssociation(
            DeleteServiceNetworkServiceAssociationRequest deleteServiceNetworkServiceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between a service and a service network. This operation fails if an association is still
     * in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceNetworkServiceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteServiceNetworkServiceAssociation operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkServiceAssociationResponse> deleteServiceNetworkServiceAssociation(
            Consumer<DeleteServiceNetworkServiceAssociationRequest.Builder> deleteServiceNetworkServiceAssociationRequest) {
        return deleteServiceNetworkServiceAssociation(DeleteServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update
     * association in progress.
     * </p>
     *
     * @param deleteServiceNetworkVpcAssociationRequest
     * @return A Java Future containing the result of the DeleteServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkVpcAssociationResponse> deleteServiceNetworkVpcAssociation(
            DeleteServiceNetworkVpcAssociationRequest deleteServiceNetworkVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update
     * association in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceNetworkVpcAssociationResponse> deleteServiceNetworkVpcAssociation(
            Consumer<DeleteServiceNetworkVpcAssociationRequest.Builder> deleteServiceNetworkVpcAssociationRequest) {
        return deleteServiceNetworkVpcAssociation(DeleteServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group
     * creation is in progress.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group
     * creation is in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTargetGroupRequest#builder()}
     * </p>
     *
     * @param deleteTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTargetGroupResponse> deleteTargetGroup(
            Consumer<DeleteTargetGroupRequest.Builder> deleteTargetGroupRequest) {
        return deleteTargetGroup(DeleteTargetGroupRequest.builder().applyMutation(deleteTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetsResponse> deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetsResponse> deregisterTargets(
            Consumer<DeregisterTargetsRequest.Builder> deregisterTargetsRequest) {
        return deregisterTargets(DeregisterTargetsRequest.builder().applyMutation(deregisterTargetsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified access log subscription.
     * </p>
     *
     * @param getAccessLogSubscriptionRequest
     * @return A Java Future containing the result of the GetAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessLogSubscriptionResponse> getAccessLogSubscription(
            GetAccessLogSubscriptionRequest getAccessLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessLogSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param getAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessLogSubscriptionResponse> getAccessLogSubscription(
            Consumer<GetAccessLogSubscriptionRequest.Builder> getAccessLogSubscriptionRequest) {
        return getAccessLogSubscription(GetAccessLogSubscriptionRequest.builder().applyMutation(getAccessLogSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the auth policy for the specified service or service network.
     * </p>
     *
     * @param getAuthPolicyRequest
     * @return A Java Future containing the result of the GetAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAuthPolicyResponse> getAuthPolicy(GetAuthPolicyRequest getAuthPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the auth policy for the specified service or service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthPolicyRequest#builder()}
     * </p>
     *
     * @param getAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAuthPolicyResponse> getAuthPolicy(Consumer<GetAuthPolicyRequest.Builder> getAuthPolicyRequest) {
        return getAuthPolicy(GetAuthPolicyRequest.builder().applyMutation(getAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified listener for the specified service.
     * </p>
     *
     * @param getListenerRequest
     * @return A Java Future containing the result of the GetListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListenerResponse> getListener(GetListenerRequest getListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified listener for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetListenerRequest.Builder} avoiding the need to
     * create one manually via {@link GetListenerRequest#builder()}
     * </p>
     *
     * @param getListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetListenerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetListenerResponse> getListener(Consumer<GetListenerRequest.Builder> getListenerRequest) {
        return getListener(GetListenerRequest.builder().applyMutation(getListenerRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource configuration.
     * </p>
     *
     * @param getResourceConfigurationRequest
     * @return A Java Future containing the result of the GetResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceConfigurationResponse> getResourceConfiguration(
            GetResourceConfigurationRequest getResourceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param getResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceConfigurationResponse> getResourceConfiguration(
            Consumer<GetResourceConfigurationRequest.Builder> getResourceConfigurationRequest) {
        return getResourceConfiguration(GetResourceConfigurationRequest.builder().applyMutation(getResourceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource gateway.
     * </p>
     *
     * @param getResourceGatewayRequest
     * @return A Java Future containing the result of the GetResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceGatewayResponse> getResourceGateway(GetResourceGatewayRequest getResourceGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceGatewayRequest#builder()}
     * </p>
     *
     * @param getResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetResourceGatewayResponse> getResourceGateway(
            Consumer<GetResourceGatewayRequest.Builder> getResourceGatewayRequest) {
        return getResourceGateway(GetResourceGatewayRequest.builder().applyMutation(getResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource policy. The resource policy is an IAM policy created on behalf
     * of the resource owner when they share a resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource policy. The resource policy is an IAM policy created on behalf
     * of the resource owner when they share a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetResourcePolicyResponse> getResourcePolicy(
            Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest) {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified listener rules. You can also retrieve information about the default
     * listener rule. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param getRuleRequest
     * @return A Java Future containing the result of the GetRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleResponse> getRule(GetRuleRequest getRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified listener rules. You can also retrieve information about the default
     * listener rule. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRuleRequest#builder()}
     * </p>
     *
     * @param getRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRuleResponse> getRule(Consumer<GetRuleRequest.Builder> getRuleRequest) {
        return getRule(GetRuleRequest.builder().applyMutation(getRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified service.
     * </p>
     *
     * @param getServiceRequest
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(GetServiceRequest getServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceRequest#builder()}
     * </p>
     *
     * @param getServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(Consumer<GetServiceRequest.Builder> getServiceRequest) {
        return getService(GetServiceRequest.builder().applyMutation(getServiceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified service network.
     * </p>
     *
     * @param getServiceNetworkRequest
     * @return A Java Future containing the result of the GetServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkResponse> getServiceNetwork(GetServiceNetworkRequest getServiceNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceNetworkRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkResponse> getServiceNetwork(
            Consumer<GetServiceNetworkRequest.Builder> getServiceNetworkRequest) {
        return getServiceNetwork(GetServiceNetworkRequest.builder().applyMutation(getServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a resource configuration.
     * </p>
     *
     * @param getServiceNetworkResourceAssociationRequest
     * @return A Java Future containing the result of the GetServiceNetworkResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkResourceAssociationResponse> getServiceNetworkResourceAssociation(
            GetServiceNetworkResourceAssociationRequest getServiceNetworkResourceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetServiceNetworkResourceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkResourceAssociationResponse> getServiceNetworkResourceAssociation(
            Consumer<GetServiceNetworkResourceAssociationRequest.Builder> getServiceNetworkResourceAssociationRequest) {
        return getServiceNetworkResourceAssociation(GetServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(getServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a service.
     * </p>
     *
     * @param getServiceNetworkServiceAssociationRequest
     * @return A Java Future containing the result of the GetServiceNetworkServiceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkServiceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkServiceAssociationResponse> getServiceNetworkServiceAssociation(
            GetServiceNetworkServiceAssociationRequest getServiceNetworkServiceAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkServiceAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetServiceNetworkServiceAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkServiceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkServiceAssociationResponse> getServiceNetworkServiceAssociation(
            Consumer<GetServiceNetworkServiceAssociationRequest.Builder> getServiceNetworkServiceAssociationRequest) {
        return getServiceNetworkServiceAssociation(GetServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(getServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a VPC.
     * </p>
     *
     * @param getServiceNetworkVpcAssociationRequest
     * @return A Java Future containing the result of the GetServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkVpcAssociationResponse> getServiceNetworkVpcAssociation(
            GetServiceNetworkVpcAssociationRequest getServiceNetworkVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceNetworkVpcAssociationResponse> getServiceNetworkVpcAssociation(
            Consumer<GetServiceNetworkVpcAssociationRequest.Builder> getServiceNetworkVpcAssociationRequest) {
        return getServiceNetworkVpcAssociation(GetServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(getServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified target group.
     * </p>
     *
     * @param getTargetGroupRequest
     * @return A Java Future containing the result of the GetTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTargetGroupResponse> getTargetGroup(GetTargetGroupRequest getTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTargetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetTargetGroupRequest#builder()}
     * </p>
     *
     * @param getTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.GetTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTargetGroupResponse> getTargetGroup(Consumer<GetTargetGroupRequest.Builder> getTargetGroupRequest) {
        return getTargetGroup(GetTargetGroupRequest.builder().applyMutation(getTargetGroupRequest).build());
    }

    /**
     * <p>
     * Lists the access log subscriptions for the specified service network or service.
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     * @return A Java Future containing the result of the ListAccessLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessLogSubscriptionsResponse> listAccessLogSubscriptions(
            ListAccessLogSubscriptionsRequest listAccessLogSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the access log subscriptions for the specified service network or service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessLogSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessLogSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessLogSubscriptionsResponse> listAccessLogSubscriptions(
            Consumer<ListAccessLogSubscriptionsRequest.Builder> listAccessLogSubscriptionsRequest) {
        return listAccessLogSubscriptions(ListAccessLogSubscriptionsRequest.builder()
                .applyMutation(listAccessLogSubscriptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsPublisher publisher = client.listAccessLogSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsPublisher publisher = client.listAccessLogSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsPublisher listAccessLogSubscriptionsPaginator(
            ListAccessLogSubscriptionsRequest listAccessLogSubscriptionsRequest) {
        return new ListAccessLogSubscriptionsPublisher(this, listAccessLogSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsPublisher publisher = client.listAccessLogSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsPublisher publisher = client.listAccessLogSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessLogSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsPublisher listAccessLogSubscriptionsPaginator(
            Consumer<ListAccessLogSubscriptionsRequest.Builder> listAccessLogSubscriptionsRequest) {
        return listAccessLogSubscriptionsPaginator(ListAccessLogSubscriptionsRequest.builder()
                .applyMutation(listAccessLogSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists the listeners for the specified service.
     * </p>
     *
     * @param listListenersRequest
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(ListListenersRequest listListenersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the listeners for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListListenersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListListeners operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListListenersResponse> listListeners(Consumer<ListListenersRequest.Builder> listListenersRequest) {
        return listListeners(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation.</b>
     * </p>
     *
     * @param listListenersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersPublisher listListenersPaginator(ListListenersRequest listListenersRequest) {
        return new ListListenersPublisher(this, listListenersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersPublisher publisher = client.listListenersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListListenersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListListenersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListListenersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersPublisher listListenersPaginator(Consumer<ListListenersRequest.Builder> listListenersRequest) {
        return listListenersPaginator(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * Lists the resource configurations owned by or shared with this account.
     * </p>
     *
     * @param listResourceConfigurationsRequest
     * @return A Java Future containing the result of the ListResourceConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceConfigurationsResponse> listResourceConfigurations(
            ListResourceConfigurationsRequest listResourceConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource configurations owned by or shared with this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listResourceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListResourceConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceConfigurationsResponse> listResourceConfigurations(
            Consumer<ListResourceConfigurationsRequest.Builder> listResourceConfigurationsRequest) {
        return listResourceConfigurations(ListResourceConfigurationsRequest.builder()
                .applyMutation(listResourceConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsPublisher publisher = client.listResourceConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsPublisher publisher = client.listResourceConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsPublisher listResourceConfigurationsPaginator(
            ListResourceConfigurationsRequest listResourceConfigurationsRequest) {
        return new ListResourceConfigurationsPublisher(this, listResourceConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsPublisher publisher = client.listResourceConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsPublisher publisher = client.listResourceConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listResourceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsPublisher listResourceConfigurationsPaginator(
            Consumer<ListResourceConfigurationsRequest.Builder> listResourceConfigurationsRequest) {
        return listResourceConfigurationsPaginator(ListResourceConfigurationsRequest.builder()
                .applyMutation(listResourceConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations for the specified VPC endpoint.
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     * @return A Java Future containing the result of the ListResourceEndpointAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceEndpointAssociationsResponse> listResourceEndpointAssociations(
            ListResourceEndpointAssociationsRequest listResourceEndpointAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations for the specified VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListResourceEndpointAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceEndpointAssociationsResponse> listResourceEndpointAssociations(
            Consumer<ListResourceEndpointAssociationsRequest.Builder> listResourceEndpointAssociationsRequest) {
        return listResourceEndpointAssociations(ListResourceEndpointAssociationsRequest.builder()
                .applyMutation(listResourceEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsPublisher publisher = client.listResourceEndpointAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsPublisher publisher = client.listResourceEndpointAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsPublisher listResourceEndpointAssociationsPaginator(
            ListResourceEndpointAssociationsRequest listResourceEndpointAssociationsRequest) {
        return new ListResourceEndpointAssociationsPublisher(this, listResourceEndpointAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsPublisher publisher = client.listResourceEndpointAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsPublisher publisher = client.listResourceEndpointAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsPublisher listResourceEndpointAssociationsPaginator(
            Consumer<ListResourceEndpointAssociationsRequest.Builder> listResourceEndpointAssociationsRequest) {
        return listResourceEndpointAssociationsPaginator(ListResourceEndpointAssociationsRequest.builder()
                .applyMutation(listResourceEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the resource gateways that you own or that were shared with you.
     * </p>
     *
     * @param listResourceGatewaysRequest
     * @return A Java Future containing the result of the ListResourceGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceGatewaysResponse> listResourceGateways(
            ListResourceGatewaysRequest listResourceGatewaysRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource gateways that you own or that were shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceGatewaysRequest#builder()}
     * </p>
     *
     * @param listResourceGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListResourceGateways operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListResourceGatewaysResponse> listResourceGateways(
            Consumer<ListResourceGatewaysRequest.Builder> listResourceGatewaysRequest) {
        return listResourceGateways(ListResourceGatewaysRequest.builder().applyMutation(listResourceGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysPublisher publisher = client.listResourceGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysPublisher publisher = client.listResourceGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceGatewaysRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysPublisher listResourceGatewaysPaginator(ListResourceGatewaysRequest listResourceGatewaysRequest) {
        return new ListResourceGatewaysPublisher(this, listResourceGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysPublisher publisher = client.listResourceGatewaysPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysPublisher publisher = client.listResourceGatewaysPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceGatewaysRequest#builder()}
     * </p>
     *
     * @param listResourceGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysPublisher listResourceGatewaysPaginator(
            Consumer<ListResourceGatewaysRequest.Builder> listResourceGatewaysRequest) {
        return listResourceGatewaysPaginator(ListResourceGatewaysRequest.builder().applyMutation(listResourceGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists the rules for the specified listener.
     * </p>
     *
     * @param listRulesRequest
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(ListRulesRequest listRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules for the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRulesResponse> listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)} operation.</b>
     * </p>
     *
     * @param listRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(ListRulesRequest listRulesRequest) {
        return new ListRulesPublisher(this, listRulesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesPublisher publisher = client.listRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesPublisher listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest) {
        return listRulesPaginator(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a resource configuration.
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     * @return A Java Future containing the result of the ListServiceNetworkResourceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkResourceAssociationsResponse> listServiceNetworkResourceAssociations(
            ListServiceNetworkResourceAssociationsRequest listServiceNetworkResourceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkResourceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceNetworkResourceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkResourceAssociationsResponse> listServiceNetworkResourceAssociations(
            Consumer<ListServiceNetworkResourceAssociationsRequest.Builder> listServiceNetworkResourceAssociationsRequest) {
        return listServiceNetworkResourceAssociations(ListServiceNetworkResourceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsPublisher publisher = client.listServiceNetworkResourceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsPublisher publisher = client.listServiceNetworkResourceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsPublisher listServiceNetworkResourceAssociationsPaginator(
            ListServiceNetworkResourceAssociationsRequest listServiceNetworkResourceAssociationsRequest) {
        return new ListServiceNetworkResourceAssociationsPublisher(this, listServiceNetworkResourceAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsPublisher publisher = client.listServiceNetworkResourceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsPublisher publisher = client.listServiceNetworkResourceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkResourceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsPublisher listServiceNetworkResourceAssociationsPaginator(
            Consumer<ListServiceNetworkResourceAssociationsRequest.Builder> listServiceNetworkResourceAssociationsRequest) {
        return listServiceNetworkResourceAssociationsPaginator(ListServiceNetworkResourceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a service. You can filter the list either by service or
     * service network. You must provide either the service network identifier or the service identifier.
     * </p>
     * <p>
     * Every association in Amazon VPC Lattice has a unique Amazon Resource Name (ARN), such as when a service network
     * is associated with a VPC or when a service is associated with a service network. If the association is for a
     * resource is shared with another account, the association includes the local account ID as the prefix in the ARN.
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     * @return A Java Future containing the result of the ListServiceNetworkServiceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkServiceAssociationsResponse> listServiceNetworkServiceAssociations(
            ListServiceNetworkServiceAssociationsRequest listServiceNetworkServiceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a service. You can filter the list either by service or
     * service network. You must provide either the service network identifier or the service identifier.
     * </p>
     * <p>
     * Every association in Amazon VPC Lattice has a unique Amazon Resource Name (ARN), such as when a service network
     * is associated with a VPC or when a service is associated with a service network. If the association is for a
     * resource is shared with another account, the association includes the local account ID as the prefix in the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkServiceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkServiceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceNetworkServiceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkServiceAssociationsResponse> listServiceNetworkServiceAssociations(
            Consumer<ListServiceNetworkServiceAssociationsRequest.Builder> listServiceNetworkServiceAssociationsRequest) {
        return listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkServiceAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsPublisher publisher = client.listServiceNetworkServiceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsPublisher publisher = client.listServiceNetworkServiceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsPublisher listServiceNetworkServiceAssociationsPaginator(
            ListServiceNetworkServiceAssociationsRequest listServiceNetworkServiceAssociationsRequest) {
        return new ListServiceNetworkServiceAssociationsPublisher(this, listServiceNetworkServiceAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsPublisher publisher = client.listServiceNetworkServiceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsPublisher publisher = client.listServiceNetworkServiceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkServiceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkServiceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsPublisher listServiceNetworkServiceAssociationsPaginator(
            Consumer<ListServiceNetworkServiceAssociationsRequest.Builder> listServiceNetworkServiceAssociationsRequest) {
        return listServiceNetworkServiceAssociationsPaginator(ListServiceNetworkServiceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkServiceAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC. You can filter the list either by VPC or service
     * network. You must provide either the ID of the service network identifier or the ID of the VPC.
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     * @return A Java Future containing the result of the ListServiceNetworkVpcAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkVpcAssociationsResponse> listServiceNetworkVpcAssociations(
            ListServiceNetworkVpcAssociationsRequest listServiceNetworkVpcAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC. You can filter the list either by VPC or service
     * network. You must provide either the ID of the service network identifier or the ID of the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworkVpcAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceNetworkVpcAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceNetworkVpcAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkVpcAssociationsResponse> listServiceNetworkVpcAssociations(
            Consumer<ListServiceNetworkVpcAssociationsRequest.Builder> listServiceNetworkVpcAssociationsRequest) {
        return listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsPublisher publisher = client.listServiceNetworkVpcAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsPublisher publisher = client.listServiceNetworkVpcAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsPublisher listServiceNetworkVpcAssociationsPaginator(
            ListServiceNetworkVpcAssociationsRequest listServiceNetworkVpcAssociationsRequest) {
        return new ListServiceNetworkVpcAssociationsPublisher(this, listServiceNetworkVpcAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsPublisher publisher = client.listServiceNetworkVpcAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsPublisher publisher = client.listServiceNetworkVpcAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworkVpcAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceNetworkVpcAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsPublisher listServiceNetworkVpcAssociationsPaginator(
            Consumer<ListServiceNetworkVpcAssociationsRequest.Builder> listServiceNetworkVpcAssociationsRequest) {
        return listServiceNetworkVpcAssociationsPaginator(ListServiceNetworkVpcAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC endpoint.
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     * @return A Java Future containing the result of the ListServiceNetworkVpcEndpointAssociations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkVpcEndpointAssociationsResponse> listServiceNetworkVpcEndpointAssociations(
            ListServiceNetworkVpcEndpointAssociationsRequest listServiceNetworkVpcEndpointAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceNetworkVpcEndpointAssociations operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworkVpcEndpointAssociationsResponse> listServiceNetworkVpcEndpointAssociations(
            Consumer<ListServiceNetworkVpcEndpointAssociationsRequest.Builder> listServiceNetworkVpcEndpointAssociationsRequest) {
        return listServiceNetworkVpcEndpointAssociations(ListServiceNetworkVpcEndpointAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsPublisher publisher = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsPublisher publisher = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsPublisher listServiceNetworkVpcEndpointAssociationsPaginator(
            ListServiceNetworkVpcEndpointAssociationsRequest listServiceNetworkVpcEndpointAssociationsRequest) {
        return new ListServiceNetworkVpcEndpointAssociationsPublisher(this, listServiceNetworkVpcEndpointAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsPublisher publisher = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsPublisher publisher = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsPublisher listServiceNetworkVpcEndpointAssociationsPaginator(
            Consumer<ListServiceNetworkVpcEndpointAssociationsRequest.Builder> listServiceNetworkVpcEndpointAssociationsRequest) {
        return listServiceNetworkVpcEndpointAssociationsPaginator(ListServiceNetworkVpcEndpointAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the service networks owned by or shared with this account. The account ID in the ARN shows which account
     * owns the service network.
     * </p>
     *
     * @param listServiceNetworksRequest
     * @return A Java Future containing the result of the ListServiceNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworksResponse> listServiceNetworks(
            ListServiceNetworksRequest listServiceNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service networks owned by or shared with this account. The account ID in the ARN shows which account
     * owns the service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceNetworksRequest#builder()}
     * </p>
     *
     * @param listServiceNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceNetworksResponse> listServiceNetworks(
            Consumer<ListServiceNetworksRequest.Builder> listServiceNetworksRequest) {
        return listServiceNetworks(ListServiceNetworksRequest.builder().applyMutation(listServiceNetworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksPublisher publisher = client.listServiceNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksPublisher publisher = client.listServiceNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksPublisher listServiceNetworksPaginator(ListServiceNetworksRequest listServiceNetworksRequest) {
        return new ListServiceNetworksPublisher(this, listServiceNetworksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksPublisher publisher = client.listServiceNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksPublisher publisher = client.listServiceNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceNetworksRequest#builder()}
     * </p>
     *
     * @param listServiceNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksPublisher listServiceNetworksPaginator(
            Consumer<ListServiceNetworksRequest.Builder> listServiceNetworksRequest) {
        return listServiceNetworksPaginator(ListServiceNetworksRequest.builder().applyMutation(listServiceNetworksRequest)
                .build());
    }

    /**
     * <p>
     * Lists the services owned by the caller account or shared with the caller account.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the services owned by the caller account or shared with the caller account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        return new ListServicesPublisher(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your target groups. You can narrow your search by using the filters below in your request.
     * </p>
     *
     * @param listTargetGroupsRequest
     * @return A Java Future containing the result of the ListTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetGroupsResponse> listTargetGroups(ListTargetGroupsRequest listTargetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your target groups. You can narrow your search by using the filters below in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetGroupsRequest#builder()}
     * </p>
     *
     * @param listTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTargetGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTargetGroupsResponse> listTargetGroups(
            Consumer<ListTargetGroupsRequest.Builder> listTargetGroupsRequest) {
        return listTargetGroups(ListTargetGroupsRequest.builder().applyMutation(listTargetGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsPublisher publisher = client.listTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsPublisher publisher = client.listTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsPublisher listTargetGroupsPaginator(ListTargetGroupsRequest listTargetGroupsRequest) {
        return new ListTargetGroupsPublisher(this, listTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsPublisher publisher = client.listTargetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsPublisher publisher = client.listTargetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetGroupsRequest#builder()}
     * </p>
     *
     * @param listTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsPublisher listTargetGroupsPaginator(Consumer<ListTargetGroupsRequest.Builder> listTargetGroupsRequest) {
        return listTargetGroupsPaginator(ListTargetGroupsRequest.builder().applyMutation(listTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the targets for the target group. By default, all targets are included. You can use this API to check the
     * health status of targets. You can also ﬁlter the results by target.
     * </p>
     *
     * @param listTargetsRequest
     * @return A Java Future containing the result of the ListTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTargetsResponse> listTargets(ListTargetsRequest listTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets for the target group. By default, all targets are included. You can use this API to check the
     * health status of targets. You can also ﬁlter the results by target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTargetsResponse> listTargets(Consumer<ListTargetsRequest.Builder> listTargetsRequest) {
        return listTargets(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)} operation.</b>
     * </p>
     *
     * @param listTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsPublisher listTargetsPaginator(ListTargetsRequest listTargetsRequest) {
        return new ListTargetsPublisher(this, listTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsPublisher publisher = client.listTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsPublisher listTargetsPaginator(Consumer<ListTargetsRequest.Builder> listTargetsRequest) {
        return listTargetsPaginator(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html">Auth
     * policies</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param putAuthPolicyRequest
     * @return A Java Future containing the result of the PutAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.PutAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAuthPolicyResponse> putAuthPolicy(PutAuthPolicyRequest putAuthPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html">Auth
     * policies</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAuthPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutAuthPolicyRequest#builder()}
     * </p>
     *
     * @param putAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutAuthPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.PutAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutAuthPolicyResponse> putAuthPolicy(Consumer<PutAuthPolicyRequest.Builder> putAuthPolicyRequest) {
        return putAuthPolicy(PutAuthPolicyRequest.builder().applyMutation(putAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a service or service network. The policy must contain the same
     * actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing
     * services and service networks.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a service or service network. The policy must contain the same
     * actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing
     * services and service networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutResourcePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(
            Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest) {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target
     * group.
     * </p>
     *
     * @param registerTargetsRequest
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTargetsResponse> registerTargets(RegisterTargetsRequest registerTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target
     * group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterTargetsRequest#builder()}
     * </p>
     *
     * @param registerTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterTargets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterTargetsResponse> registerTargets(
            Consumer<RegisterTargetsRequest.Builder> registerTargetsRequest) {
        return registerTargets(RegisterTargetsRequest.builder().applyMutation(registerTargetsRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified access log subscription.
     * </p>
     *
     * @param updateAccessLogSubscriptionRequest
     * @return A Java Future containing the result of the UpdateAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessLogSubscriptionResponse> updateAccessLogSubscription(
            UpdateAccessLogSubscriptionRequest updateAccessLogSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccessLogSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessLogSubscriptionResponse> updateAccessLogSubscription(
            Consumer<UpdateAccessLogSubscriptionRequest.Builder> updateAccessLogSubscriptionRequest) {
        return updateAccessLogSubscription(UpdateAccessLogSubscriptionRequest.builder()
                .applyMutation(updateAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates the specified listener for the specified service.
     * </p>
     *
     * @param updateListenerRequest
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(UpdateListenerRequest updateListenerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified listener for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateListenerRequest#builder()}
     * </p>
     *
     * @param updateListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateListener operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateListenerResponse> updateListener(Consumer<UpdateListenerRequest.Builder> updateListenerRequest) {
        return updateListener(UpdateListenerRequest.builder().applyMutation(updateListenerRequest).build());
    }

    /**
     * <p>
     * Updates the specified resource configuration.
     * </p>
     *
     * @param updateResourceConfigurationRequest
     * @return A Java Future containing the result of the UpdateResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceConfigurationResponse> updateResourceConfiguration(
            UpdateResourceConfigurationRequest updateResourceConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateResourceConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceConfigurationResponse> updateResourceConfiguration(
            Consumer<UpdateResourceConfigurationRequest.Builder> updateResourceConfigurationRequest) {
        return updateResourceConfiguration(UpdateResourceConfigurationRequest.builder()
                .applyMutation(updateResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the specified resource gateway.
     * </p>
     *
     * @param updateResourceGatewayRequest
     * @return A Java Future containing the result of the UpdateResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceGatewayResponse> updateResourceGateway(
            UpdateResourceGatewayRequest updateResourceGatewayRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceGatewayRequest#builder()}
     * </p>
     *
     * @param updateResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateResourceGateway operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateResourceGatewayResponse> updateResourceGateway(
            Consumer<UpdateResourceGatewayRequest.Builder> updateResourceGatewayRequest) {
        return updateResourceGateway(UpdateResourceGatewayRequest.builder().applyMutation(updateResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Updates a specified rule for the listener. You can't modify a default listener rule. To modify a default listener
     * rule, use <code>UpdateListener</code>.
     * </p>
     *
     * @param updateRuleRequest
     * @return A Java Future containing the result of the UpdateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleResponse> updateRule(UpdateRuleRequest updateRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified rule for the listener. You can't modify a default listener rule. To modify a default listener
     * rule, use <code>UpdateListener</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRuleRequest#builder()}
     * </p>
     *
     * @param updateRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRuleResponse> updateRule(Consumer<UpdateRuleRequest.Builder> updateRuleRequest) {
        return updateRule(UpdateRuleRequest.builder().applyMutation(updateRuleRequest).build());
    }

    /**
     * <p>
     * Updates the specified service.
     * </p>
     *
     * @param updateServiceRequest
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServiceRequest#builder()}
     * </p>
     *
     * @param updateServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) {
        return updateService(UpdateServiceRequest.builder().applyMutation(updateServiceRequest).build());
    }

    /**
     * <p>
     * Updates the specified service network.
     * </p>
     *
     * @param updateServiceNetworkRequest
     * @return A Java Future containing the result of the UpdateServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceNetworkResponse> updateServiceNetwork(
            UpdateServiceNetworkRequest updateServiceNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceNetworkRequest#builder()}
     * </p>
     *
     * @param updateServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateServiceNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceNetworkResponse> updateServiceNetwork(
            Consumer<UpdateServiceNetworkRequest.Builder> updateServiceNetworkRequest) {
        return updateServiceNetwork(UpdateServiceNetworkRequest.builder().applyMutation(updateServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the service network and VPC association. If you add a security group to the service network and VPC
     * association, the association must continue to have at least one security group. You can add or edit security
     * groups at any time. However, to remove all security groups, you must first delete the association and then
     * recreate it without security groups.
     * </p>
     *
     * @param updateServiceNetworkVpcAssociationRequest
     * @return A Java Future containing the result of the UpdateServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceNetworkVpcAssociationResponse> updateServiceNetworkVpcAssociation(
            UpdateServiceNetworkVpcAssociationRequest updateServiceNetworkVpcAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the service network and VPC association. If you add a security group to the service network and VPC
     * association, the association must continue to have at least one security group. You can add or edit security
     * groups at any time. However, to remove all security groups, you must first delete the association and then
     * recreate it without security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param updateServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateServiceNetworkVpcAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateServiceNetworkVpcAssociationResponse> updateServiceNetworkVpcAssociation(
            Consumer<UpdateServiceNetworkVpcAssociationRequest.Builder> updateServiceNetworkVpcAssociationRequest) {
        return updateServiceNetworkVpcAssociation(UpdateServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(updateServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the specified target group.
     * </p>
     *
     * @param updateTargetGroupRequest
     * @return A Java Future containing the result of the UpdateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTargetGroupResponse> updateTargetGroup(UpdateTargetGroupRequest updateTargetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTargetGroupRequest#builder()}
     * </p>
     *
     * @param updateTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTargetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The input does not satisfy the constraints specified by an Amazon Web Services
     *         service.</li>
     *         <li>AccessDeniedException The user does not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The limit on the number of requests per second was exceeded.</li>
     *         <li>ResourceNotFoundException The request references a resource that does not exist.</li>
     *         <li>ConflictException The request conflicts with the current state of the resource. Updating or deleting
     *         a resource can cause an inconsistent state.</li>
     *         <li>ServiceQuotaExceededException The request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException An unexpected error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>VpcLatticeException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample VpcLatticeAsyncClient.UpdateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTargetGroupResponse> updateTargetGroup(
            Consumer<UpdateTargetGroupRequest.Builder> updateTargetGroupRequest) {
        return updateTargetGroup(UpdateTargetGroupRequest.builder().applyMutation(updateTargetGroupRequest).build());
    }

    @Override
    default VpcLatticeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link VpcLatticeAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static VpcLatticeAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link VpcLatticeAsyncClient}.
     */
    static VpcLatticeAsyncClientBuilder builder() {
        return new DefaultVpcLatticeAsyncClientBuilder();
    }
}
