/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.vpclattice.model.AccessDeniedException;
import software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.ConflictException;
import software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.GetListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.GetListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.GetRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.GetRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.GetServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.GetServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.GetTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.InternalServerException;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListListenersRequest;
import software.amazon.awssdk.services.vpclattice.model.ListListenersResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest;
import software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse;
import software.amazon.awssdk.services.vpclattice.model.ListRulesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListRulesResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse;
import software.amazon.awssdk.services.vpclattice.model.ListServicesRequest;
import software.amazon.awssdk.services.vpclattice.model.ListServicesResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.vpclattice.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.vpclattice.model.ResourceNotFoundException;
import software.amazon.awssdk.services.vpclattice.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.vpclattice.model.TagResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.TagResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.ThrottlingException;
import software.amazon.awssdk.services.vpclattice.model.UntagResourceRequest;
import software.amazon.awssdk.services.vpclattice.model.UntagResourceResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateListenerResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateRuleResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceResponse;
import software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest;
import software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupResponse;
import software.amazon.awssdk.services.vpclattice.model.ValidationException;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeException;
import software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable;
import software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable;

/**
 * Service client for accessing Amazon VPC Lattice. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon VPC Lattice is a fully managed application networking service that you use to connect, secure, and monitor all
 * of your services across multiple accounts and virtual private clouds (VPCs). Amazon VPC Lattice interconnects your
 * microservices and legacy services within a logical boundary, so that you can discover and manage them more
 * efficiently. For more information, see the <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/">Amazon VPC
 * Lattice User Guide</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface VpcLatticeClient extends AwsClient {
    String SERVICE_NAME = "vpc-lattice";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "vpc-lattice";

    /**
     * <p>
     * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This
     * can be useful when bulk updating or swapping rule priority.
     * </p>
     * <p>
     * <b>Required permissions:</b> <code>vpc-lattice:UpdateRule</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html">How Amazon VPC
     * Lattice works with IAM</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param batchUpdateRuleRequest
     * @return Result of the BatchUpdateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.BatchUpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateRuleResponse batchUpdateRule(BatchUpdateRuleRequest batchUpdateRuleRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the listener rules in a batch. You can use this operation to change the priority of listener rules. This
     * can be useful when bulk updating or swapping rule priority.
     * </p>
     * <p>
     * <b>Required permissions:</b> <code>vpc-lattice:UpdateRule</code>
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/security_iam_service-with-iam.html">How Amazon VPC
     * Lattice works with IAM</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateRuleRequest.Builder} avoiding the need
     * to create one manually via {@link BatchUpdateRuleRequest#builder()}
     * </p>
     *
     * @param batchUpdateRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.BatchUpdateRuleRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.BatchUpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/BatchUpdateRule" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchUpdateRuleResponse batchUpdateRule(Consumer<BatchUpdateRuleRequest.Builder> batchUpdateRuleRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return batchUpdateRule(BatchUpdateRuleRequest.builder().applyMutation(batchUpdateRuleRequest).build());
    }

    /**
     * <p>
     * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service
     * network owner can use the access logs to audit the services in the network. The service network owner can only
     * see access logs from clients and services that are associated with their service network. Access log entries
     * represent traffic originated from VPCs associated with that network. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html">Access logs</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createAccessLogSubscriptionRequest
     * @return Result of the CreateAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessLogSubscriptionResponse createAccessLogSubscription(
            CreateAccessLogSubscriptionRequest createAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service
     * network owner can use the access logs to audit the services in the network. The service network owner can only
     * see access logs from clients and services that are associated with their service network. Access log entries
     * represent traffic originated from VPCs associated with that network. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/monitoring-access-logs.html">Access logs</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param createAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessLogSubscriptionResponse createAccessLogSubscription(
            Consumer<CreateAccessLogSubscriptionRequest.Builder> createAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return createAccessLogSubscription(CreateAccessLogSubscriptionRequest.builder()
                .applyMutation(createAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or
     * more listeners. A listener is a process that checks for connection requests to your services. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html">Listeners</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createListenerRequest
     * @return Result of the CreateListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener for a service. Before you start using your Amazon VPC Lattice service, you must add one or
     * more listeners. A listener is a process that checks for connection requests to your services. For more
     * information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html">Listeners</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link CreateListenerRequest#builder()}
     * </p>
     *
     * @param createListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateListenerRequest.Builder} to create a
     *        request.
     * @return Result of the CreateListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateListenerResponse createListener(Consumer<CreateListenerRequest.Builder> createListenerRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createListener(CreateListenerRequest.builder().applyMutation(createListenerRequest).build());
    }

    /**
     * <p>
     * Creates a resource configuration. A resource configuration defines a specific resource. You can associate a
     * resource configuration with a service network or a VPC endpoint.
     * </p>
     *
     * @param createResourceConfigurationRequest
     * @return Result of the CreateResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceConfigurationResponse createResourceConfiguration(
            CreateResourceConfigurationRequest createResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource configuration. A resource configuration defines a specific resource. You can associate a
     * resource configuration with a service network or a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param createResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the CreateResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceConfigurationResponse createResourceConfiguration(
            Consumer<CreateResourceConfigurationRequest.Builder> createResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createResourceConfiguration(CreateResourceConfigurationRequest.builder()
                .applyMutation(createResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a resource gateway.
     * </p>
     *
     * @param createResourceGatewayRequest
     * @return Result of the CreateResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceGatewayResponse createResourceGateway(CreateResourceGatewayRequest createResourceGatewayRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceGatewayRequest#builder()}
     * </p>
     *
     * @param createResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateResourceGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceGatewayResponse createResourceGateway(
            Consumer<CreateResourceGatewayRequest.Builder> createResourceGatewayRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createResourceGateway(CreateResourceGatewayRequest.builder().applyMutation(createResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateRuleRequest.Builder} to create a request.
     * @return Result of the CreateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRuleResponse createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a service. A service is any software application that can run on instances containers, or serverless
     * functions within an account or virtual private cloud (VPC).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html">Services</a>
     * in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createServiceRequest
     * @return Result of the CreateService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service. A service is any software application that can run on instances containers, or serverless
     * functions within an account or virtual private cloud (VPC).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html">Services</a>
     * in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServiceRequest#builder()}
     * </p>
     *
     * @param createServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceRequest.Builder} to create a request.
     * @return Result of the CreateService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateService" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateServiceResponse createService(Consumer<CreateServiceRequest.Builder> createServiceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createService(CreateServiceRequest.builder().applyMutation(createServiceRequest).build());
    }

    /**
     * <p>
     * Creates a service network. A service network is a logical boundary for a collection of services. You can
     * associate services and VPCs with a service network.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html">Service networks</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createServiceNetworkRequest
     * @return Result of the CreateServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkResponse createServiceNetwork(CreateServiceNetworkRequest createServiceNetworkRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service network. A service network is a logical boundary for a collection of services. You can
     * associate services and VPCs with a service network.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html">Service networks</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link CreateServiceNetworkRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the CreateServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkResponse createServiceNetwork(
            Consumer<CreateServiceNetworkRequest.Builder> createServiceNetworkRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createServiceNetwork(CreateServiceNetworkRequest.builder().applyMutation(createServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Associates the specified service network with the specified resource configuration. This allows the resource
     * configuration to receive connections through the service network, including through a service network VPC
     * endpoint.
     * </p>
     *
     * @param createServiceNetworkResourceAssociationRequest
     * @return Result of the CreateServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkResourceAssociationResponse createServiceNetworkResourceAssociation(
            CreateServiceNetworkResourceAssociationRequest createServiceNetworkResourceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified service network with the specified resource configuration. This allows the resource
     * configuration to receive connections through the service network, including through a service network VPC
     * endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkResourceAssociationResponse createServiceNetworkResourceAssociation(
            Consumer<CreateServiceNetworkResourceAssociationRequest.Builder> createServiceNetworkResourceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createServiceNetworkResourceAssociation(CreateServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(createServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified service with the specified service network. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations"
     * >Manage service associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if the service and service network are already associated or if there is a
     * disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the
     * association and recreating it.
     * </p>
     * <p>
     * You cannot associate a service and service network that are shared with a caller. The caller must own either the
     * service or the service network.
     * </p>
     * <p>
     * As a result of this operation, the association is created in the service network account and the association
     * owner account.
     * </p>
     *
     * @param createServiceNetworkServiceAssociationRequest
     * @return Result of the CreateServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkServiceAssociationResponse createServiceNetworkServiceAssociation(
            CreateServiceNetworkServiceAssociationRequest createServiceNetworkServiceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified service with the specified service network. For more information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-service-associations"
     * >Manage service associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if the service and service network are already associated or if there is a
     * disassociation or deletion in progress. If the association fails, you can retry the operation by deleting the
     * association and recreating it.
     * </p>
     * <p>
     * You cannot associate a service and service network that are shared with a caller. The caller must own either the
     * service or the service network.
     * </p>
     * <p>
     * As a result of this operation, the association is created in the service network account and the association
     * owner account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateServiceNetworkServiceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link CreateServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkServiceAssociationResponse createServiceNetworkServiceAssociation(
            Consumer<CreateServiceNetworkServiceAssociationRequest.Builder> createServiceNetworkServiceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createServiceNetworkServiceAssociation(CreateServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(createServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the
     * resources within that VPC to be clients and communicate with other services in the service network. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations"
     * >Manage VPC associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if there is a disassociation in progress. If the association fails, retry by
     * deleting the association and recreating it.
     * </p>
     * <p>
     * As a result of this operation, the association gets created in the service network account and the VPC owner
     * account.
     * </p>
     * <p>
     * If you add a security group to the service network and VPC association, the association must continue to always
     * have at least one security group. You can add or edit security groups at any time. However, to remove all
     * security groups, you must first delete the association and recreate it without security groups.
     * </p>
     *
     * @param createServiceNetworkVpcAssociationRequest
     * @return Result of the CreateServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkVpcAssociationResponse createServiceNetworkVpcAssociation(
            CreateServiceNetworkVpcAssociationRequest createServiceNetworkVpcAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a VPC with a service network. When you associate a VPC with the service network, it enables all the
     * resources within that VPC to be clients and communicate with other services in the service network. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-network-associations.html#service-network-vpc-associations"
     * >Manage VPC associations</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * You can't use this operation if there is a disassociation in progress. If the association fails, retry by
     * deleting the association and recreating it.
     * </p>
     * <p>
     * As a result of this operation, the association gets created in the service network account and the VPC owner
     * account.
     * </p>
     * <p>
     * If you add a security group to the service network and VPC association, the association must continue to always
     * have at least one security group. You can add or edit security groups at any time. However, to remove all
     * security groups, you must first delete the association and recreate it without security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param createServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateServiceNetworkVpcAssociationResponse createServiceNetworkVpcAssociation(
            Consumer<CreateServiceNetworkVpcAssociationRequest.Builder> createServiceNetworkVpcAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createServiceNetworkVpcAssociation(CreateServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(createServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a target group. A target group is a collection of targets, or compute resources, that run your
     * application or service. A target group can only be used by a single service.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target
     * groups</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return Result of the CreateTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTargetGroupResponse createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a target group. A target group is a collection of targets, or compute resources, that run your
     * application or service. A target group can only be used by a single service.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html">Target
     * groups</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTargetGroupRequest#builder()}
     * </p>
     *
     * @param createTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.CreateTargetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/CreateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTargetGroupResponse createTargetGroup(Consumer<CreateTargetGroupRequest.Builder> createTargetGroupRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return createTargetGroup(CreateTargetGroupRequest.builder().applyMutation(createTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified access log subscription.
     * </p>
     *
     * @param deleteAccessLogSubscriptionRequest
     * @return Result of the DeleteAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessLogSubscriptionResponse deleteAccessLogSubscription(
            DeleteAccessLogSubscriptionRequest deleteAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessLogSubscriptionResponse deleteAccessLogSubscription(
            Consumer<DeleteAccessLogSubscriptionRequest.Builder> deleteAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return deleteAccessLogSubscription(DeleteAccessLogSubscriptionRequest.builder()
                .applyMutation(deleteAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified auth policy. If an auth is set to <code>AWS_IAM</code> and the auth policy is deleted, all
     * requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to
     * <code>NONE</code>. If auth is enabled on the resource, but no auth policy is set, all requests are denied.
     * </p>
     *
     * @param deleteAuthPolicyRequest
     * @return Result of the DeleteAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAuthPolicyResponse deleteAuthPolicy(DeleteAuthPolicyRequest deleteAuthPolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified auth policy. If an auth is set to <code>AWS_IAM</code> and the auth policy is deleted, all
     * requests are denied. If you are trying to remove the auth policy completely, you must set the auth type to
     * <code>NONE</code>. If auth is enabled on the resource, but no auth policy is set, all requests are denied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteAuthPolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteAuthPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteAuthPolicyResponse deleteAuthPolicy(Consumer<DeleteAuthPolicyRequest.Builder> deleteAuthPolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteAuthPolicy(DeleteAuthPolicyRequest.builder().applyMutation(deleteAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     *
     * @param deleteListenerRequest
     * @return Result of the DeleteListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteListenerRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteListenerRequest#builder()}
     * </p>
     *
     * @param deleteListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteListenerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteListener" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteListenerResponse deleteListener(Consumer<DeleteListenerRequest.Builder> deleteListenerRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteListener(DeleteListenerRequest.builder().applyMutation(deleteListenerRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource configuration.
     * </p>
     *
     * @param deleteResourceConfigurationRequest
     * @return Result of the DeleteResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceConfigurationResponse deleteResourceConfiguration(
            DeleteResourceConfigurationRequest deleteResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceConfigurationResponse deleteResourceConfiguration(
            Consumer<DeleteResourceConfigurationRequest.Builder> deleteResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteResourceConfiguration(DeleteResourceConfigurationRequest.builder()
                .applyMutation(deleteResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Disassociates the resource configuration from the resource VPC endpoint.
     * </p>
     *
     * @param deleteResourceEndpointAssociationRequest
     * @return Result of the DeleteResourceEndpointAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceEndpointAssociationResponse deleteResourceEndpointAssociation(
            DeleteResourceEndpointAssociationRequest deleteResourceEndpointAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the resource configuration from the resource VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceEndpointAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteResourceEndpointAssociationRequest#builder()}
     * </p>
     *
     * @param deleteResourceEndpointAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceEndpointAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteResourceEndpointAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceEndpointAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceEndpointAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceEndpointAssociationResponse deleteResourceEndpointAssociation(
            Consumer<DeleteResourceEndpointAssociationRequest.Builder> deleteResourceEndpointAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteResourceEndpointAssociation(DeleteResourceEndpointAssociationRequest.builder()
                .applyMutation(deleteResourceEndpointAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource gateway.
     * </p>
     *
     * @param deleteResourceGatewayRequest
     * @return Result of the DeleteResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceGatewayResponse deleteResourceGateway(DeleteResourceGatewayRequest deleteResourceGatewayRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceGatewayRequest#builder()}
     * </p>
     *
     * @param deleteResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourceGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceGatewayResponse deleteResourceGateway(
            Consumer<DeleteResourceGatewayRequest.Builder> deleteResourceGatewayRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteResourceGateway(DeleteResourceGatewayRequest.builder().applyMutation(deleteResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified resource policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can
     * delete additional listener rules, but you cannot delete the default rule.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a listener rule. Each listener has a default rule for checking connection requests, but you can define
     * additional rules. Each rule consists of a priority, one or more actions, and one or more conditions. You can
     * delete additional listener rules, but you cannot delete the default rule.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteRuleRequest.Builder} to create a request.
     * @return Result of the DeleteRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRuleResponse deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service,
     * all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and
     * access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service">Delete a service</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteServiceRequest
     * @return Result of the DeleteService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service. A service can't be deleted if it's associated with a service network. If you delete a service,
     * all resources related to the service, such as the resource policy, auth policy, listeners, listener rules, and
     * access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/services.html#delete-service">Delete a service</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServiceRequest#builder()}
     * </p>
     *
     * @param deleteServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceRequest.Builder} to create a request.
     * @return Result of the DeleteService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteService" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteServiceResponse deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteService(DeleteServiceRequest.builder().applyMutation(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Deletes a service network. You can only delete the service network if there is no service or VPC associated with
     * it. If you delete a service network, all resources related to the service network, such as the resource policy,
     * auth policy, and access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network">Delete a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param deleteServiceNetworkRequest
     * @return Result of the DeleteServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkResponse deleteServiceNetwork(DeleteServiceNetworkRequest deleteServiceNetworkRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a service network. You can only delete the service network if there is no service or VPC associated with
     * it. If you delete a service network, all resources related to the service network, such as the resource policy,
     * auth policy, and access log subscriptions, are also deleted. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#delete-service-network">Delete a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteServiceNetworkRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkResponse deleteServiceNetwork(
            Consumer<DeleteServiceNetworkRequest.Builder> deleteServiceNetworkRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteServiceNetwork(DeleteServiceNetworkRequest.builder().applyMutation(deleteServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Deletes the association between a service network and a resource configuration.
     * </p>
     *
     * @param deleteServiceNetworkResourceAssociationRequest
     * @return Result of the DeleteServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkResourceAssociationResponse deleteServiceNetworkResourceAssociation(
            DeleteServiceNetworkResourceAssociationRequest deleteServiceNetworkResourceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkResourceAssociationResponse deleteServiceNetworkResourceAssociation(
            Consumer<DeleteServiceNetworkResourceAssociationRequest.Builder> deleteServiceNetworkResourceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteServiceNetworkResourceAssociation(DeleteServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the association between a service and a service network. This operation fails if an association is still
     * in progress.
     * </p>
     *
     * @param deleteServiceNetworkServiceAssociationRequest
     * @return Result of the DeleteServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkServiceAssociationResponse deleteServiceNetworkServiceAssociation(
            DeleteServiceNetworkServiceAssociationRequest deleteServiceNetworkServiceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the association between a service and a service network. This operation fails if an association is still
     * in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceNetworkServiceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkServiceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkServiceAssociationResponse deleteServiceNetworkServiceAssociation(
            Consumer<DeleteServiceNetworkServiceAssociationRequest.Builder> deleteServiceNetworkServiceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteServiceNetworkServiceAssociation(DeleteServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update
     * association in progress.
     * </p>
     *
     * @param deleteServiceNetworkVpcAssociationRequest
     * @return Result of the DeleteServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkVpcAssociationResponse deleteServiceNetworkVpcAssociation(
            DeleteServiceNetworkVpcAssociationRequest deleteServiceNetworkVpcAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the VPC from the service network. You can't disassociate the VPC if there is a create or update
     * association in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param deleteServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceNetworkVpcAssociationResponse deleteServiceNetworkVpcAssociation(
            Consumer<DeleteServiceNetworkVpcAssociationRequest.Builder> deleteServiceNetworkVpcAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteServiceNetworkVpcAssociation(DeleteServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(deleteServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group
     * creation is in progress.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return Result of the DeleteTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTargetGroupResponse deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest)
            throws ValidationException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a target group. You can't delete a target group if it is used in a listener rule or if the target group
     * creation is in progress.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTargetGroupRequest#builder()}
     * </p>
     *
     * @param deleteTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeleteTargetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeleteTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTargetGroupResponse deleteTargetGroup(Consumer<DeleteTargetGroupRequest.Builder> deleteTargetGroupRequest)
            throws ValidationException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deleteTargetGroup(DeleteTargetGroupRequest.builder().applyMutation(deleteTargetGroupRequest).build());
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return Result of the DeregisterTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterTargetsResponse deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.DeregisterTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/DeregisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterTargetsResponse deregisterTargets(Consumer<DeregisterTargetsRequest.Builder> deregisterTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return deregisterTargets(DeregisterTargetsRequest.builder().applyMutation(deregisterTargetsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified access log subscription.
     * </p>
     *
     * @param getAccessLogSubscriptionRequest
     * @return Result of the GetAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessLogSubscriptionResponse getAccessLogSubscription(
            GetAccessLogSubscriptionRequest getAccessLogSubscriptionRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessLogSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link GetAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param getAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetAccessLogSubscriptionRequest.Builder} to create
     *        a request.
     * @return Result of the GetAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessLogSubscriptionResponse getAccessLogSubscription(
            Consumer<GetAccessLogSubscriptionRequest.Builder> getAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return getAccessLogSubscription(GetAccessLogSubscriptionRequest.builder().applyMutation(getAccessLogSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the auth policy for the specified service or service network.
     * </p>
     *
     * @param getAuthPolicyRequest
     * @return Result of the GetAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAuthPolicyResponse getAuthPolicy(GetAuthPolicyRequest getAuthPolicyRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the auth policy for the specified service or service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAuthPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetAuthPolicyRequest#builder()}
     * </p>
     *
     * @param getAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetAuthPolicyRequest.Builder} to create a request.
     * @return Result of the GetAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default GetAuthPolicyResponse getAuthPolicy(Consumer<GetAuthPolicyRequest.Builder> getAuthPolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getAuthPolicy(GetAuthPolicyRequest.builder().applyMutation(getAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified listener for the specified service.
     * </p>
     *
     * @param getListenerRequest
     * @return Result of the GetListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener" target="_top">AWS API
     *      Documentation</a>
     */
    default GetListenerResponse getListener(GetListenerRequest getListenerRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified listener for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetListenerRequest.Builder} avoiding the need to
     * create one manually via {@link GetListenerRequest#builder()}
     * </p>
     *
     * @param getListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetListenerRequest.Builder} to create a request.
     * @return Result of the GetListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetListener" target="_top">AWS API
     *      Documentation</a>
     */
    default GetListenerResponse getListener(Consumer<GetListenerRequest.Builder> getListenerRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return getListener(GetListenerRequest.builder().applyMutation(getListenerRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource configuration.
     * </p>
     *
     * @param getResourceConfigurationRequest
     * @return Result of the GetResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigurationResponse getResourceConfiguration(
            GetResourceConfigurationRequest getResourceConfigurationRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param getResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourceConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceConfigurationResponse getResourceConfiguration(
            Consumer<GetResourceConfigurationRequest.Builder> getResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return getResourceConfiguration(GetResourceConfigurationRequest.builder().applyMutation(getResourceConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource gateway.
     * </p>
     *
     * @param getResourceGatewayRequest
     * @return Result of the GetResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceGatewayResponse getResourceGateway(GetResourceGatewayRequest getResourceGatewayRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceGatewayRequest#builder()}
     * </p>
     *
     * @param getResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourceGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceGatewayResponse getResourceGateway(Consumer<GetResourceGatewayRequest.Builder> getResourceGatewayRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getResourceGateway(GetResourceGatewayRequest.builder().applyMutation(getResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified resource policy. The resource policy is an IAM policy created on behalf
     * of the resource owner when they share a resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified resource policy. The resource policy is an IAM policy created on behalf
     * of the resource owner when they share a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetResourcePolicyRequest#builder()}
     * </p>
     *
     * @param getResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcePolicyResponse getResourcePolicy(Consumer<GetResourcePolicyRequest.Builder> getResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getResourcePolicy(GetResourcePolicyRequest.builder().applyMutation(getResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified listener rules. You can also retrieve information about the default
     * listener rule. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param getRuleRequest
     * @return Result of the GetRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleResponse getRule(GetRuleRequest getRuleRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified listener rules. You can also retrieve information about the default
     * listener rule. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/listeners.html#listener-rules">Listener rules</a> in the
     * <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRuleRequest.Builder} avoiding the need to create
     * one manually via {@link GetRuleRequest#builder()}
     * </p>
     *
     * @param getRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetRuleRequest.Builder} to create a request.
     * @return Result of the GetRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetRule" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRuleResponse getRule(Consumer<GetRuleRequest.Builder> getRuleRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return getRule(GetRuleRequest.builder().applyMutation(getRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified service.
     * </p>
     *
     * @param getServiceRequest
     * @return Result of the GetService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceResponse getService(GetServiceRequest getServiceRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceRequest#builder()}
     * </p>
     *
     * @param getServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceRequest.Builder} to create a request.
     * @return Result of the GetService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetService" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceResponse getService(Consumer<GetServiceRequest.Builder> getServiceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return getService(GetServiceRequest.builder().applyMutation(getServiceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified service network.
     * </p>
     *
     * @param getServiceNetworkRequest
     * @return Result of the GetServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceNetworkResponse getServiceNetwork(GetServiceNetworkRequest getServiceNetworkRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceNetworkRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceNetworkResponse getServiceNetwork(Consumer<GetServiceNetworkRequest.Builder> getServiceNetworkRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getServiceNetwork(GetServiceNetworkRequest.builder().applyMutation(getServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a resource configuration.
     * </p>
     *
     * @param getServiceNetworkResourceAssociationRequest
     * @return Result of the GetServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkResourceAssociationResponse getServiceNetworkResourceAssociation(
            GetServiceNetworkResourceAssociationRequest getServiceNetworkResourceAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceNetworkResourceAssociationRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceNetworkResourceAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkResourceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkResourceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetServiceNetworkResourceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkResourceAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkResourceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkResourceAssociationResponse getServiceNetworkResourceAssociation(
            Consumer<GetServiceNetworkResourceAssociationRequest.Builder> getServiceNetworkResourceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getServiceNetworkResourceAssociation(GetServiceNetworkResourceAssociationRequest.builder()
                .applyMutation(getServiceNetworkResourceAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a service.
     * </p>
     *
     * @param getServiceNetworkServiceAssociationRequest
     * @return Result of the GetServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkServiceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkServiceAssociationResponse getServiceNetworkServiceAssociation(
            GetServiceNetworkServiceAssociationRequest getServiceNetworkServiceAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkServiceAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceNetworkServiceAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkServiceAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkServiceAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetServiceNetworkServiceAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkServiceAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkServiceAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkServiceAssociationResponse getServiceNetworkServiceAssociation(
            Consumer<GetServiceNetworkServiceAssociationRequest.Builder> getServiceNetworkServiceAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getServiceNetworkServiceAssociation(GetServiceNetworkServiceAssociationRequest.builder()
                .applyMutation(getServiceNetworkServiceAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a VPC.
     * </p>
     *
     * @param getServiceNetworkVpcAssociationRequest
     * @return Result of the GetServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkVpcAssociationResponse getServiceNetworkVpcAssociation(
            GetServiceNetworkVpcAssociationRequest getServiceNetworkVpcAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified association between a service network and a VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param getServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetServiceNetworkVpcAssociationRequest.Builder} to
     *        create a request.
     * @return Result of the GetServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceNetworkVpcAssociationResponse getServiceNetworkVpcAssociation(
            Consumer<GetServiceNetworkVpcAssociationRequest.Builder> getServiceNetworkVpcAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getServiceNetworkVpcAssociation(GetServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(getServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified target group.
     * </p>
     *
     * @param getTargetGroupRequest
     * @return Result of the GetTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTargetGroupResponse getTargetGroup(GetTargetGroupRequest getTargetGroupRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTargetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetTargetGroupRequest#builder()}
     * </p>
     *
     * @param getTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.GetTargetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the GetTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.GetTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/GetTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default GetTargetGroupResponse getTargetGroup(Consumer<GetTargetGroupRequest.Builder> getTargetGroupRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return getTargetGroup(GetTargetGroupRequest.builder().applyMutation(getTargetGroupRequest).build());
    }

    /**
     * <p>
     * Lists the access log subscriptions for the specified service network or service.
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     * @return Result of the ListAccessLogSubscriptions operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsResponse listAccessLogSubscriptions(
            ListAccessLogSubscriptionsRequest listAccessLogSubscriptionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the access log subscriptions for the specified service network or service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessLogSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccessLogSubscriptions operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsResponse listAccessLogSubscriptions(
            Consumer<ListAccessLogSubscriptionsRequest.Builder> listAccessLogSubscriptionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listAccessLogSubscriptions(ListAccessLogSubscriptionsRequest.builder()
                .applyMutation(listAccessLogSubscriptionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client.listAccessLogSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client
     *             .listAccessLogSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client.listAccessLogSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsIterable listAccessLogSubscriptionsPaginator(
            ListAccessLogSubscriptionsRequest listAccessLogSubscriptionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return new ListAccessLogSubscriptionsIterable(this, listAccessLogSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client.listAccessLogSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client
     *             .listAccessLogSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListAccessLogSubscriptionsIterable responses = client.listAccessLogSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessLogSubscriptions(software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessLogSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccessLogSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listAccessLogSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListAccessLogSubscriptionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListAccessLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListAccessLogSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessLogSubscriptionsIterable listAccessLogSubscriptionsPaginator(
            Consumer<ListAccessLogSubscriptionsRequest.Builder> listAccessLogSubscriptionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listAccessLogSubscriptionsPaginator(ListAccessLogSubscriptionsRequest.builder()
                .applyMutation(listAccessLogSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists the listeners for the specified service.
     * </p>
     *
     * @param listListenersRequest
     * @return Result of the ListListeners operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersResponse listListeners(ListListenersRequest listListenersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the listeners for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListListenersRequest.Builder} to create a request.
     * @return Result of the ListListeners operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersResponse listListeners(Consumer<ListListenersRequest.Builder> listListenersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return listListeners(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client
     *             .listListenersPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation.</b>
     * </p>
     *
     * @param listListenersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersIterable listListenersPaginator(ListListenersRequest listListenersRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListListenersIterable(this, listListenersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client
     *             .listListenersPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListListenersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListListenersIterable responses = client.listListenersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listListeners(software.amazon.awssdk.services.vpclattice.model.ListListenersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListListenersRequest.Builder} avoiding the need to
     * create one manually via {@link ListListenersRequest#builder()}
     * </p>
     *
     * @param listListenersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListListenersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListListeners" target="_top">AWS API
     *      Documentation</a>
     */
    default ListListenersIterable listListenersPaginator(Consumer<ListListenersRequest.Builder> listListenersRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return listListenersPaginator(ListListenersRequest.builder().applyMutation(listListenersRequest).build());
    }

    /**
     * <p>
     * Lists the resource configurations owned by or shared with this account.
     * </p>
     *
     * @param listResourceConfigurationsRequest
     * @return Result of the ListResourceConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsResponse listResourceConfigurations(
            ListResourceConfigurationsRequest listResourceConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource configurations owned by or shared with this account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listResourceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest.Builder} to
     *        create a request.
     * @return Result of the ListResourceConfigurations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsResponse listResourceConfigurations(
            Consumer<ListResourceConfigurationsRequest.Builder> listResourceConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listResourceConfigurations(ListResourceConfigurationsRequest.builder()
                .applyMutation(listResourceConfigurationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client.listResourceConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client
     *             .listResourceConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client.listResourceConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsIterable listResourceConfigurationsPaginator(
            ListResourceConfigurationsRequest listResourceConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return new ListResourceConfigurationsIterable(this, listResourceConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client.listResourceConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client
     *             .listResourceConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceConfigurationsIterable responses = client.listResourceConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceConfigurations(software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceConfigurationsRequest#builder()}
     * </p>
     *
     * @param listResourceConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceConfigurationsIterable listResourceConfigurationsPaginator(
            Consumer<ListResourceConfigurationsRequest.Builder> listResourceConfigurationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listResourceConfigurationsPaginator(ListResourceConfigurationsRequest.builder()
                .applyMutation(listResourceConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations for the specified VPC endpoint.
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     * @return Result of the ListResourceEndpointAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsResponse listResourceEndpointAssociations(
            ListResourceEndpointAssociationsRequest listResourceEndpointAssociationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations for the specified VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListResourceEndpointAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsResponse listResourceEndpointAssociations(
            Consumer<ListResourceEndpointAssociationsRequest.Builder> listResourceEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listResourceEndpointAssociations(ListResourceEndpointAssociationsRequest.builder()
                .applyMutation(listResourceEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client.listResourceEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client
     *             .listResourceEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client.listResourceEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsIterable listResourceEndpointAssociationsPaginator(
            ListResourceEndpointAssociationsRequest listResourceEndpointAssociationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return new ListResourceEndpointAssociationsIterable(this, listResourceEndpointAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client.listResourceEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client
     *             .listResourceEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceEndpointAssociationsIterable responses = client.listResourceEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceEndpointAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listResourceEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceEndpointAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceEndpointAssociationsIterable listResourceEndpointAssociationsPaginator(
            Consumer<ListResourceEndpointAssociationsRequest.Builder> listResourceEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listResourceEndpointAssociationsPaginator(ListResourceEndpointAssociationsRequest.builder()
                .applyMutation(listResourceEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the resource gateways that you own or that were shared with you.
     * </p>
     *
     * @param listResourceGatewaysRequest
     * @return Result of the ListResourceGateways operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysResponse listResourceGateways(ListResourceGatewaysRequest listResourceGatewaysRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resource gateways that you own or that were shared with you.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceGatewaysRequest#builder()}
     * </p>
     *
     * @param listResourceGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceGateways operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysResponse listResourceGateways(
            Consumer<ListResourceGatewaysRequest.Builder> listResourceGatewaysRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listResourceGateways(ListResourceGatewaysRequest.builder().applyMutation(listResourceGatewaysRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client.listResourceGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client
     *             .listResourceGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client.listResourceGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceGatewaysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysIterable listResourceGatewaysPaginator(ListResourceGatewaysRequest listResourceGatewaysRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListResourceGatewaysIterable(this, listResourceGatewaysRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client.listResourceGatewaysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client
     *             .listResourceGatewaysPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListResourceGatewaysIterable responses = client.listResourceGatewaysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceGateways(software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceGatewaysRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceGatewaysRequest#builder()}
     * </p>
     *
     * @param listResourceGatewaysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListResourceGatewaysRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListResourceGateways
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListResourceGateways"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceGatewaysIterable listResourceGatewaysPaginator(
            Consumer<ListResourceGatewaysRequest.Builder> listResourceGatewaysRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listResourceGatewaysPaginator(ListResourceGatewaysRequest.builder().applyMutation(listResourceGatewaysRequest)
                .build());
    }

    /**
     * <p>
     * Lists the rules for the specified listener.
     * </p>
     *
     * @param listRulesRequest
     * @return Result of the ListRules operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(ListRulesRequest listRulesRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the rules for the specified listener.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListRulesRequest.Builder} to create a request.
     * @return Result of the ListRules operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesResponse listRules(Consumer<ListRulesRequest.Builder> listRulesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listRules(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)} operation.</b>
     * </p>
     *
     * @param listRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesIterable listRulesPaginator(ListRulesRequest listRulesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListRulesIterable(this, listRulesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListRulesIterable responses = client.listRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRules(software.amazon.awssdk.services.vpclattice.model.ListRulesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRulesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRulesRequest#builder()}
     * </p>
     *
     * @param listRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListRulesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListRules" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRulesIterable listRulesPaginator(Consumer<ListRulesRequest.Builder> listRulesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listRulesPaginator(ListRulesRequest.builder().applyMutation(listRulesRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a resource configuration.
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     * @return Result of the ListServiceNetworkResourceAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsResponse listServiceNetworkResourceAssociations(
            ListServiceNetworkResourceAssociationsRequest listServiceNetworkResourceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkResourceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceNetworkResourceAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsResponse listServiceNetworkResourceAssociations(
            Consumer<ListServiceNetworkResourceAssociationsRequest.Builder> listServiceNetworkResourceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkResourceAssociations(ListServiceNetworkResourceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client.listServiceNetworkResourceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client
     *             .listServiceNetworkResourceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client.listServiceNetworkResourceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsIterable listServiceNetworkResourceAssociationsPaginator(
            ListServiceNetworkResourceAssociationsRequest listServiceNetworkResourceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListServiceNetworkResourceAssociationsIterable(this, listServiceNetworkResourceAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client.listServiceNetworkResourceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client
     *             .listServiceNetworkResourceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkResourceAssociationsIterable responses = client.listServiceNetworkResourceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkResourceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkResourceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkResourceAssociationsIterable listServiceNetworkResourceAssociationsPaginator(
            Consumer<ListServiceNetworkResourceAssociationsRequest.Builder> listServiceNetworkResourceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkResourceAssociationsPaginator(ListServiceNetworkResourceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a service. You can filter the list either by service or
     * service network. You must provide either the service network identifier or the service identifier.
     * </p>
     * <p>
     * Every association in Amazon VPC Lattice has a unique Amazon Resource Name (ARN), such as when a service network
     * is associated with a VPC or when a service is associated with a service network. If the association is for a
     * resource is shared with another account, the association includes the local account ID as the prefix in the ARN.
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     * @return Result of the ListServiceNetworkServiceAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsResponse listServiceNetworkServiceAssociations(
            ListServiceNetworkServiceAssociationsRequest listServiceNetworkServiceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a service. You can filter the list either by service or
     * service network. You must provide either the service network identifier or the service identifier.
     * </p>
     * <p>
     * Every association in Amazon VPC Lattice has a unique Amazon Resource Name (ARN), such as when a service network
     * is associated with a VPC or when a service is associated with a service network. If the association is for a
     * resource is shared with another account, the association includes the local account ID as the prefix in the ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkServiceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkServiceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceNetworkServiceAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsResponse listServiceNetworkServiceAssociations(
            Consumer<ListServiceNetworkServiceAssociationsRequest.Builder> listServiceNetworkServiceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkServiceAssociations(ListServiceNetworkServiceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkServiceAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client.listServiceNetworkServiceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client
     *             .listServiceNetworkServiceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client.listServiceNetworkServiceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsIterable listServiceNetworkServiceAssociationsPaginator(
            ListServiceNetworkServiceAssociationsRequest listServiceNetworkServiceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListServiceNetworkServiceAssociationsIterable(this, listServiceNetworkServiceAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client.listServiceNetworkServiceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client
     *             .listServiceNetworkServiceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkServiceAssociationsIterable responses = client.listServiceNetworkServiceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkServiceAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkServiceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkServiceAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkServiceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkServiceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkServiceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkServiceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkServiceAssociationsIterable listServiceNetworkServiceAssociationsPaginator(
            Consumer<ListServiceNetworkServiceAssociationsRequest.Builder> listServiceNetworkServiceAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkServiceAssociationsPaginator(ListServiceNetworkServiceAssociationsRequest.builder()
                .applyMutation(listServiceNetworkServiceAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC. You can filter the list either by VPC or service
     * network. You must provide either the ID of the service network identifier or the ID of the VPC.
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     * @return Result of the ListServiceNetworkVpcAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsResponse listServiceNetworkVpcAssociations(
            ListServiceNetworkVpcAssociationsRequest listServiceNetworkVpcAssociationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC. You can filter the list either by VPC or service
     * network. You must provide either the ID of the service network identifier or the ID of the VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworkVpcAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceNetworkVpcAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceNetworkVpcAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsResponse listServiceNetworkVpcAssociations(
            Consumer<ListServiceNetworkVpcAssociationsRequest.Builder> listServiceNetworkVpcAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkVpcAssociations(ListServiceNetworkVpcAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client.listServiceNetworkVpcAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client
     *             .listServiceNetworkVpcAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client.listServiceNetworkVpcAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsIterable listServiceNetworkVpcAssociationsPaginator(
            ListServiceNetworkVpcAssociationsRequest listServiceNetworkVpcAssociationsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return new ListServiceNetworkVpcAssociationsIterable(this, listServiceNetworkVpcAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client.listServiceNetworkVpcAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client
     *             .listServiceNetworkVpcAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcAssociationsIterable responses = client.listServiceNetworkVpcAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworkVpcAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListServiceNetworkVpcAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcAssociationsIterable listServiceNetworkVpcAssociationsPaginator(
            Consumer<ListServiceNetworkVpcAssociationsRequest.Builder> listServiceNetworkVpcAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkVpcAssociationsPaginator(ListServiceNetworkVpcAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC endpoint.
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     * @return Result of the ListServiceNetworkVpcEndpointAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsResponse listServiceNetworkVpcEndpointAssociations(
            ListServiceNetworkVpcEndpointAssociationsRequest listServiceNetworkVpcEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between a service network and a VPC endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceNetworkVpcEndpointAssociations operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsResponse listServiceNetworkVpcEndpointAssociations(
            Consumer<ListServiceNetworkVpcEndpointAssociationsRequest.Builder> listServiceNetworkVpcEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkVpcEndpointAssociations(ListServiceNetworkVpcEndpointAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client
     *             .listServiceNetworkVpcEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsIterable listServiceNetworkVpcEndpointAssociationsPaginator(
            ListServiceNetworkVpcEndpointAssociationsRequest listServiceNetworkVpcEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListServiceNetworkVpcEndpointAssociationsIterable(this, listServiceNetworkVpcEndpointAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client
     *             .listServiceNetworkVpcEndpointAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworkVpcEndpointAssociationsIterable responses = client.listServiceNetworkVpcEndpointAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworkVpcEndpointAssociations(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceNetworkVpcEndpointAssociationsRequest#builder()}
     * </p>
     *
     * @param listServiceNetworkVpcEndpointAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworkVpcEndpointAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworkVpcEndpointAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworkVpcEndpointAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworkVpcEndpointAssociationsIterable listServiceNetworkVpcEndpointAssociationsPaginator(
            Consumer<ListServiceNetworkVpcEndpointAssociationsRequest.Builder> listServiceNetworkVpcEndpointAssociationsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServiceNetworkVpcEndpointAssociationsPaginator(ListServiceNetworkVpcEndpointAssociationsRequest.builder()
                .applyMutation(listServiceNetworkVpcEndpointAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the service networks owned by or shared with this account. The account ID in the ARN shows which account
     * owns the service network.
     * </p>
     *
     * @param listServiceNetworksRequest
     * @return Result of the ListServiceNetworks operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksResponse listServiceNetworks(ListServiceNetworksRequest listServiceNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the service networks owned by or shared with this account. The account ID in the ARN shows which account
     * owns the service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceNetworksRequest#builder()}
     * </p>
     *
     * @param listServiceNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest.Builder} to create a
     *        request.
     * @return Result of the ListServiceNetworks operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksResponse listServiceNetworks(
            Consumer<ListServiceNetworksRequest.Builder> listServiceNetworksRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listServiceNetworks(ListServiceNetworksRequest.builder().applyMutation(listServiceNetworksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client.listServiceNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client
     *             .listServiceNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client.listServiceNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceNetworksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksIterable listServiceNetworksPaginator(ListServiceNetworksRequest listServiceNetworksRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListServiceNetworksIterable(this, listServiceNetworksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client.listServiceNetworksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client
     *             .listServiceNetworksPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServiceNetworksIterable responses = client.listServiceNetworksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceNetworks(software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceNetworksRequest.Builder} avoiding the
     * need to create one manually via {@link ListServiceNetworksRequest#builder()}
     * </p>
     *
     * @param listServiceNetworksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServiceNetworksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServiceNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServiceNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceNetworksIterable listServiceNetworksPaginator(
            Consumer<ListServiceNetworksRequest.Builder> listServiceNetworksRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listServiceNetworksPaginator(ListServiceNetworksRequest.builder().applyMutation(listServiceNetworksRequest)
                .build());
    }

    /**
     * <p>
     * Lists the services owned by the caller account or shared with the caller account.
     * </p>
     *
     * @param listServicesRequest
     * @return Result of the ListServices operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the services owned by the caller account or shared with the caller account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServicesRequest.Builder} to create a request.
     * @return Result of the ListServices operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return new ListServicesIterable(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.vpclattice.model.ListServicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListServicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListServices" target="_top">AWS API
     *      Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists your target groups. You can narrow your search by using the filters below in your request.
     * </p>
     *
     * @param listTargetGroupsRequest
     * @return Result of the ListTargetGroups operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsResponse listTargetGroups(ListTargetGroupsRequest listTargetGroupsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your target groups. You can narrow your search by using the filters below in your request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetGroupsRequest#builder()}
     * </p>
     *
     * @param listTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTargetGroups operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsResponse listTargetGroups(Consumer<ListTargetGroupsRequest.Builder> listTargetGroupsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listTargetGroups(ListTargetGroupsRequest.builder().applyMutation(listTargetGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client.listTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client
     *             .listTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client.listTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTargetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsIterable listTargetGroupsPaginator(ListTargetGroupsRequest listTargetGroupsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListTargetGroupsIterable(this, listTargetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client.listTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client
     *             .listTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetGroupsIterable responses = client.listTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargetGroups(software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTargetGroupsRequest#builder()}
     * </p>
     *
     * @param listTargetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTargetGroupsIterable listTargetGroupsPaginator(Consumer<ListTargetGroupsRequest.Builder> listTargetGroupsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listTargetGroupsPaginator(ListTargetGroupsRequest.builder().applyMutation(listTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the targets for the target group. By default, all targets are included. You can use this API to check the
     * health status of targets. You can also ﬁlter the results by target.
     * </p>
     *
     * @param listTargetsRequest
     * @return Result of the ListTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsResponse listTargets(ListTargetsRequest listTargetsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets for the target group. By default, all targets are included. You can use this API to check the
     * health status of targets. You can also ﬁlter the results by target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest.Builder} to create a request.
     * @return Result of the ListTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsResponse listTargets(Consumer<ListTargetsRequest.Builder> listTargetsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return listTargets(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)} operation.</b>
     * </p>
     *
     * @param listTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsIterable listTargetsPaginator(ListTargetsRequest listTargetsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return new ListTargetsIterable(this, listTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.vpclattice.model.ListTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.vpclattice.paginators.ListTargetsIterable responses = client.listTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTargets(software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTargetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTargetsRequest#builder()}
     * </p>
     *
     * @param listTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.ListTargetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.ListTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/ListTargets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTargetsIterable listTargetsPaginator(Consumer<ListTargetsRequest.Builder> listTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return listTargetsPaginator(ListTargetsRequest.builder().applyMutation(listTargetsRequest).build());
    }

    /**
     * <p>
     * Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html">Auth
     * policies</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     *
     * @param putAuthPolicyRequest
     * @return Result of the PutAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.PutAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAuthPolicyResponse putAuthPolicy(PutAuthPolicyRequest putAuthPolicyRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates the auth policy. The policy string in JSON must not contain newlines or blank lines.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/auth-policies.html">Auth
     * policies</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAuthPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link PutAuthPolicyRequest#builder()}
     * </p>
     *
     * @param putAuthPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.PutAuthPolicyRequest.Builder} to create a request.
     * @return Result of the PutAuthPolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.PutAuthPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutAuthPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default PutAuthPolicyResponse putAuthPolicy(Consumer<PutAuthPolicyRequest.Builder> putAuthPolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return putAuthPolicy(PutAuthPolicyRequest.builder().applyMutation(putAuthPolicyRequest).build());
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a service or service network. The policy must contain the same
     * actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing
     * services and service networks.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a resource-based permission policy to a service or service network. The policy must contain the same
     * actions and condition statements as the Amazon Web Services Resource Access Manager permission for sharing
     * services and service networks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.PutResourcePolicyRequest.Builder} to create a
     *        request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/PutResourcePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target
     * group.
     * </p>
     *
     * @param registerTargetsRequest
     * @return Result of the RegisterTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterTargetsResponse registerTargets(RegisterTargetsRequest registerTargetsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers the targets with the target group. If it's a Lambda target, you can only have one target in a target
     * group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterTargetsRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterTargetsRequest#builder()}
     * </p>
     *
     * @param registerTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.RegisterTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the RegisterTargets operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/RegisterTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default RegisterTargetsResponse registerTargets(Consumer<RegisterTargetsRequest.Builder> registerTargetsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return registerTargets(RegisterTargetsRequest.builder().applyMutation(registerTargetsRequest).build());
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified access log subscription.
     * </p>
     *
     * @param updateAccessLogSubscriptionRequest
     * @return Result of the UpdateAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessLogSubscriptionResponse updateAccessLogSubscription(
            UpdateAccessLogSubscriptionRequest updateAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified access log subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessLogSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAccessLogSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateAccessLogSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateAccessLogSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAccessLogSubscription operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateAccessLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateAccessLogSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessLogSubscriptionResponse updateAccessLogSubscription(
            Consumer<UpdateAccessLogSubscriptionRequest.Builder> updateAccessLogSubscriptionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return updateAccessLogSubscription(UpdateAccessLogSubscriptionRequest.builder()
                .applyMutation(updateAccessLogSubscriptionRequest).build());
    }

    /**
     * <p>
     * Updates the specified listener for the specified service.
     * </p>
     *
     * @param updateListenerRequest
     * @return Result of the UpdateListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateListenerResponse updateListener(UpdateListenerRequest updateListenerRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified listener for the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateListenerRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateListenerRequest#builder()}
     * </p>
     *
     * @param updateListenerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateListenerRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateListener operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateListener" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateListenerResponse updateListener(Consumer<UpdateListenerRequest.Builder> updateListenerRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateListener(UpdateListenerRequest.builder().applyMutation(updateListenerRequest).build());
    }

    /**
     * <p>
     * Updates the specified resource configuration.
     * </p>
     *
     * @param updateResourceConfigurationRequest
     * @return Result of the UpdateResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceConfigurationResponse updateResourceConfiguration(
            UpdateResourceConfigurationRequest updateResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified resource configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateResourceConfigurationRequest#builder()}
     * </p>
     *
     * @param updateResourceConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateResourceConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateResourceConfiguration operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateResourceConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceConfigurationResponse updateResourceConfiguration(
            Consumer<UpdateResourceConfigurationRequest.Builder> updateResourceConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateResourceConfiguration(UpdateResourceConfigurationRequest.builder()
                .applyMutation(updateResourceConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the specified resource gateway.
     * </p>
     *
     * @param updateResourceGatewayRequest
     * @return Result of the UpdateResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceGatewayResponse updateResourceGateway(UpdateResourceGatewayRequest updateResourceGatewayRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified resource gateway.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResourceGatewayRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResourceGatewayRequest#builder()}
     * </p>
     *
     * @param updateResourceGatewayRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateResourceGatewayRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateResourceGateway operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateResourceGateway
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateResourceGateway"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResourceGatewayResponse updateResourceGateway(
            Consumer<UpdateResourceGatewayRequest.Builder> updateResourceGatewayRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, VpcLatticeException {
        return updateResourceGateway(UpdateResourceGatewayRequest.builder().applyMutation(updateResourceGatewayRequest).build());
    }

    /**
     * <p>
     * Updates a specified rule for the listener. You can't modify a default listener rule. To modify a default listener
     * rule, use <code>UpdateListener</code>.
     * </p>
     *
     * @param updateRuleRequest
     * @return Result of the UpdateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleResponse updateRule(UpdateRuleRequest updateRuleRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, ConflictException, ServiceQuotaExceededException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specified rule for the listener. You can't modify a default listener rule. To modify a default listener
     * rule, use <code>UpdateListener</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRuleRequest#builder()}
     * </p>
     *
     * @param updateRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateRuleRequest.Builder} to create a request.
     * @return Result of the UpdateRule operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateRuleResponse updateRule(Consumer<UpdateRuleRequest.Builder> updateRuleRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateRule(UpdateRuleRequest.builder().applyMutation(updateRuleRequest).build());
    }

    /**
     * <p>
     * Updates the specified service.
     * </p>
     *
     * @param updateServiceRequest
     * @return Result of the UpdateService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServiceRequest#builder()}
     * </p>
     *
     * @param updateServiceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceRequest.Builder} to create a request.
     * @return Result of the UpdateService operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateService" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateServiceResponse updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateService(UpdateServiceRequest.builder().applyMutation(updateServiceRequest).build());
    }

    /**
     * <p>
     * Updates the specified service network.
     * </p>
     *
     * @param updateServiceNetworkRequest
     * @return Result of the UpdateServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceNetworkResponse updateServiceNetwork(UpdateServiceNetworkRequest updateServiceNetworkRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified service network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceNetworkRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateServiceNetworkRequest#builder()}
     * </p>
     *
     * @param updateServiceNetworkRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateServiceNetwork operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateServiceNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceNetworkResponse updateServiceNetwork(
            Consumer<UpdateServiceNetworkRequest.Builder> updateServiceNetworkRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        return updateServiceNetwork(UpdateServiceNetworkRequest.builder().applyMutation(updateServiceNetworkRequest).build());
    }

    /**
     * <p>
     * Updates the service network and VPC association. If you add a security group to the service network and VPC
     * association, the association must continue to have at least one security group. You can add or edit security
     * groups at any time. However, to remove all security groups, you must first delete the association and then
     * recreate it without security groups.
     * </p>
     *
     * @param updateServiceNetworkVpcAssociationRequest
     * @return Result of the UpdateServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceNetworkVpcAssociationResponse updateServiceNetworkVpcAssociation(
            UpdateServiceNetworkVpcAssociationRequest updateServiceNetworkVpcAssociationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the service network and VPC association. If you add a security group to the service network and VPC
     * association, the association must continue to have at least one security group. You can add or edit security
     * groups at any time. However, to remove all security groups, you must first delete the association and then
     * recreate it without security groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateServiceNetworkVpcAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateServiceNetworkVpcAssociationRequest#builder()}
     * </p>
     *
     * @param updateServiceNetworkVpcAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateServiceNetworkVpcAssociation operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateServiceNetworkVpcAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateServiceNetworkVpcAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateServiceNetworkVpcAssociationResponse updateServiceNetworkVpcAssociation(
            Consumer<UpdateServiceNetworkVpcAssociationRequest.Builder> updateServiceNetworkVpcAssociationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateServiceNetworkVpcAssociation(UpdateServiceNetworkVpcAssociationRequest.builder()
                .applyMutation(updateServiceNetworkVpcAssociationRequest).build());
    }

    /**
     * <p>
     * Updates the specified target group.
     * </p>
     *
     * @param updateTargetGroupRequest
     * @return Result of the UpdateTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTargetGroupResponse updateTargetGroup(UpdateTargetGroupRequest updateTargetGroupRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified target group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTargetGroupRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTargetGroupRequest#builder()}
     * </p>
     *
     * @param updateTargetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.vpclattice.model.UpdateTargetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateTargetGroup operation returned by the service.
     * @throws ValidationException
     *         The input does not satisfy the constraints specified by an Amazon Web Services service.
     * @throws AccessDeniedException
     *         The user does not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request references a resource that does not exist.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. Updating or deleting a resource can cause
     *         an inconsistent state.
     * @throws ServiceQuotaExceededException
     *         The request would cause a service quota to be exceeded.
     * @throws InternalServerException
     *         An unexpected error occurred while processing the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws VpcLatticeException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample VpcLatticeClient.UpdateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/vpc-lattice-2022-11-30/UpdateTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateTargetGroupResponse updateTargetGroup(Consumer<UpdateTargetGroupRequest.Builder> updateTargetGroupRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, ConflictException,
            ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, VpcLatticeException {
        return updateTargetGroup(UpdateTargetGroupRequest.builder().applyMutation(updateTargetGroupRequest).build());
    }

    /**
     * Create a {@link VpcLatticeClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static VpcLatticeClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link VpcLatticeClient}.
     */
    static VpcLatticeClientBuilder builder() {
        return new DefaultVpcLatticeClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default VpcLatticeServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
