/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an access log subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLogSubscriptionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessLogSubscriptionSummary.Builder, AccessLogSubscriptionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(AccessLogSubscriptionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AccessLogSubscriptionSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(AccessLogSubscriptionSummary::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AccessLogSubscriptionSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(AccessLogSubscriptionSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(AccessLogSubscriptionSummary::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(AccessLogSubscriptionSummary::resourceId))
            .setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkLogType").getter(getter(AccessLogSubscriptionSummary::serviceNetworkLogTypeAsString))
            .setter(setter(Builder::serviceNetworkLogType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkLogType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            DESTINATION_ARN_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD,
            SERVICE_NETWORK_LOG_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String destinationArn;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String resourceArn;

    private final String resourceId;

    private final String serviceNetworkLogType;

    private AccessLogSubscriptionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.destinationArn = builder.destinationArn;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.serviceNetworkLogType = builder.serviceNetworkLogType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access log subscription
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access log subscription
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the access log subscription was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the access log subscription was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the destination.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the destination.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    /**
     * <p>
     * The ID of the access log subscription.
     * </p>
     * 
     * @return The ID of the access log subscription.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the access log subscription was last updated, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the access log subscription was last updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service or service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service or service network.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ID of the service or service network.
     * </p>
     * 
     * @return The ID of the service or service network.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * Log type of the service network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNetworkLogType} will return {@link ServiceNetworkLogType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceNetworkLogTypeAsString}.
     * </p>
     * 
     * @return Log type of the service network.
     * @see ServiceNetworkLogType
     */
    public final ServiceNetworkLogType serviceNetworkLogType() {
        return ServiceNetworkLogType.fromValue(serviceNetworkLogType);
    }

    /**
     * <p>
     * Log type of the service network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceNetworkLogType} will return {@link ServiceNetworkLogType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #serviceNetworkLogTypeAsString}.
     * </p>
     * 
     * @return Log type of the service network.
     * @see ServiceNetworkLogType
     */
    public final String serviceNetworkLogTypeAsString() {
        return serviceNetworkLogType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkLogTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLogSubscriptionSummary)) {
            return false;
        }
        AccessLogSubscriptionSummary other = (AccessLogSubscriptionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(destinationArn(), other.destinationArn()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(serviceNetworkLogTypeAsString(), other.serviceNetworkLogTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessLogSubscriptionSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("DestinationArn", destinationArn()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt())
                .add("ResourceArn", resourceArn()).add("ResourceId", resourceId())
                .add("ServiceNetworkLogType", serviceNetworkLogTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "serviceNetworkLogType":
            return Optional.ofNullable(clazz.cast(serviceNetworkLogTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("destinationArn", DESTINATION_ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("serviceNetworkLogType", SERVICE_NETWORK_LOG_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessLogSubscriptionSummary, T> g) {
        return obj -> g.apply((AccessLogSubscriptionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLogSubscriptionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access log subscription
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the access log subscription
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the access log subscription was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the access log subscription was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the destination.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);

        /**
         * <p>
         * The ID of the access log subscription.
         * </p>
         * 
         * @param id
         *        The ID of the access log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the access log subscription was last updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time that the access log subscription was last updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service or service network.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the service or service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ID of the service or service network.
         * </p>
         * 
         * @param resourceId
         *        The ID of the service or service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * Log type of the service network.
         * </p>
         * 
         * @param serviceNetworkLogType
         *        Log type of the service network.
         * @see ServiceNetworkLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkLogType
         */
        Builder serviceNetworkLogType(String serviceNetworkLogType);

        /**
         * <p>
         * Log type of the service network.
         * </p>
         * 
         * @param serviceNetworkLogType
         *        Log type of the service network.
         * @see ServiceNetworkLogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkLogType
         */
        Builder serviceNetworkLogType(ServiceNetworkLogType serviceNetworkLogType);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String destinationArn;

        private String id;

        private Instant lastUpdatedAt;

        private String resourceArn;

        private String resourceId;

        private String serviceNetworkLogType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLogSubscriptionSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            destinationArn(model.destinationArn);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            resourceArn(model.resourceArn);
            resourceId(model.resourceId);
            serviceNetworkLogType(model.serviceNetworkLogType);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getServiceNetworkLogType() {
            return serviceNetworkLogType;
        }

        public final void setServiceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
        }

        @Override
        public final Builder serviceNetworkLogType(String serviceNetworkLogType) {
            this.serviceNetworkLogType = serviceNetworkLogType;
            return this;
        }

        @Override
        public final Builder serviceNetworkLogType(ServiceNetworkLogType serviceNetworkLogType) {
            this.serviceNetworkLogType(serviceNetworkLogType == null ? null : serviceNetworkLogType.toString());
            return this;
        }

        @Override
        public AccessLogSubscriptionSummary build() {
            return new AccessLogSubscriptionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
