/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceNetworkResourceAssociationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<GetServiceNetworkResourceAssociationResponse.Builder, GetServiceNetworkResourceAssociationResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(GetServiceNetworkResourceAssociationResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("dnsEntry").getter(getter(GetServiceNetworkResourceAssociationResponse::dnsEntry))
            .setter(setter(Builder::dnsEntry)).constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(GetServiceNetworkResourceAssociationResponse::failureCode))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(GetServiceNetworkResourceAssociationResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> IS_MANAGED_ASSOCIATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isManagedAssociation")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::isManagedAssociation))
            .setter(setter(Builder::isManagedAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isManagedAssociation").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<DnsEntry> PRIVATE_DNS_ENTRY_FIELD = SdkField.<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("privateDnsEntry").getter(getter(GetServiceNetworkResourceAssociationResponse::privateDnsEntry))
            .setter(setter(Builder::privateDnsEntry)).constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsEntry").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationArn")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArn").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationId")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::resourceConfigurationId))
            .setter(setter(Builder::resourceConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationId").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationName")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::resourceConfigurationName))
            .setter(setter(Builder::resourceConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationName").build())
            .build();

    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkArn").getter(getter(GetServiceNetworkResourceAssociationResponse::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkId").getter(getter(GetServiceNetworkResourceAssociationResponse::serviceNetworkId))
            .setter(setter(Builder::serviceNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkName").getter(getter(GetServiceNetworkResourceAssociationResponse::serviceNetworkName))
            .setter(setter(Builder::serviceNetworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetServiceNetworkResourceAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, DNS_ENTRY_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, ID_FIELD, IS_MANAGED_ASSOCIATION_FIELD,
            LAST_UPDATED_AT_FIELD, PRIVATE_DNS_ENTRY_FIELD, RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_CONFIGURATION_ID_FIELD,
            RESOURCE_CONFIGURATION_NAME_FIELD, SERVICE_NETWORK_ARN_FIELD, SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant createdAt;

    private final String createdBy;

    private final DnsEntry dnsEntry;

    private final String failureCode;

    private final String failureReason;

    private final String id;

    private final Boolean isManagedAssociation;

    private final Instant lastUpdatedAt;

    private final DnsEntry privateDnsEntry;

    private final String resourceConfigurationArn;

    private final String resourceConfigurationId;

    private final String resourceConfigurationName;

    private final String serviceNetworkArn;

    private final String serviceNetworkId;

    private final String serviceNetworkName;

    private final String status;

    private GetServiceNetworkResourceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.dnsEntry = builder.dnsEntry;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.id = builder.id;
        this.isManagedAssociation = builder.isManagedAssociation;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.privateDnsEntry = builder.privateDnsEntry;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceConfigurationId = builder.resourceConfigurationId;
        this.resourceConfigurationName = builder.resourceConfigurationName;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the association was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the association was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The account that created the association.
     * </p>
     * 
     * @return The account that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The DNS entry for the service.
     * </p>
     * 
     * @return The DNS entry for the service.
     */
    public final DnsEntry dnsEntry() {
        return dnsEntry;
    }

    /**
     * <p>
     * The failure code.
     * </p>
     * 
     * @return The failure code.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The reason the association request failed.
     * </p>
     * 
     * @return The reason the association request failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates whether the association is managed by Amazon.
     * </p>
     * 
     * @return Indicates whether the association is managed by Amazon.
     */
    public final Boolean isManagedAssociation() {
        return isManagedAssociation;
    }

    /**
     * <p>
     * The most recent date and time that the association was updated, in ISO-8601 format.
     * </p>
     * 
     * @return The most recent date and time that the association was updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The private DNS entry for the service.
     * </p>
     * 
     * @return The private DNS entry for the service.
     */
    public final DnsEntry privateDnsEntry() {
        return privateDnsEntry;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * The ID of the resource configuration that is associated with the service network.
     * </p>
     * 
     * @return The ID of the resource configuration that is associated with the service network.
     */
    public final String resourceConfigurationId() {
        return resourceConfigurationId;
    }

    /**
     * <p>
     * The name of the resource configuration that is associated with the service network.
     * </p>
     * 
     * @return The name of the resource configuration that is associated with the service network.
     */
    public final String resourceConfigurationName() {
        return resourceConfigurationName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network that is associated with the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network that is associated with the resource configuration.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The ID of the service network that is associated with the resource configuration.
     * </p>
     * 
     * @return The ID of the service network that is associated with the resource configuration.
     */
    public final String serviceNetworkId() {
        return serviceNetworkId;
    }

    /**
     * <p>
     * The name of the service network that is associated with the resource configuration.
     * </p>
     * 
     * @return The name of the service network that is associated with the resource configuration.
     */
    public final String serviceNetworkName() {
        return serviceNetworkName;
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkResourceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ServiceNetworkResourceAssociationStatus
     */
    public final ServiceNetworkResourceAssociationStatus status() {
        return ServiceNetworkResourceAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkResourceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the association.
     * @see ServiceNetworkResourceAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isManagedAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceNetworkResourceAssociationResponse)) {
            return false;
        }
        GetServiceNetworkResourceAssociationResponse other = (GetServiceNetworkResourceAssociationResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(dnsEntry(), other.dnsEntry())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(id(), other.id()) && Objects.equals(isManagedAssociation(), other.isManagedAssociation())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(privateDnsEntry(), other.privateDnsEntry())
                && Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(resourceConfigurationId(), other.resourceConfigurationId())
                && Objects.equals(resourceConfigurationName(), other.resourceConfigurationName())
                && Objects.equals(serviceNetworkArn(), other.serviceNetworkArn())
                && Objects.equals(serviceNetworkId(), other.serviceNetworkId())
                && Objects.equals(serviceNetworkName(), other.serviceNetworkName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceNetworkResourceAssociationResponse").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("DnsEntry", dnsEntry()).add("FailureCode", failureCode())
                .add("FailureReason", failureReason()).add("Id", id()).add("IsManagedAssociation", isManagedAssociation())
                .add("LastUpdatedAt", lastUpdatedAt()).add("PrivateDnsEntry", privateDnsEntry())
                .add("ResourceConfigurationArn", resourceConfigurationArn())
                .add("ResourceConfigurationId", resourceConfigurationId())
                .add("ResourceConfigurationName", resourceConfigurationName()).add("ServiceNetworkArn", serviceNetworkArn())
                .add("ServiceNetworkId", serviceNetworkId()).add("ServiceNetworkName", serviceNetworkName())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "dnsEntry":
            return Optional.ofNullable(clazz.cast(dnsEntry()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "isManagedAssociation":
            return Optional.ofNullable(clazz.cast(isManagedAssociation()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "privateDnsEntry":
            return Optional.ofNullable(clazz.cast(privateDnsEntry()));
        case "resourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "resourceConfigurationId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationId()));
        case "resourceConfigurationName":
            return Optional.ofNullable(clazz.cast(resourceConfigurationName()));
        case "serviceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "serviceNetworkId":
            return Optional.ofNullable(clazz.cast(serviceNetworkId()));
        case "serviceNetworkName":
            return Optional.ofNullable(clazz.cast(serviceNetworkName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("id", ID_FIELD);
        map.put("isManagedAssociation", IS_MANAGED_ASSOCIATION_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("privateDnsEntry", PRIVATE_DNS_ENTRY_FIELD);
        map.put("resourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("resourceConfigurationId", RESOURCE_CONFIGURATION_ID_FIELD);
        map.put("resourceConfigurationName", RESOURCE_CONFIGURATION_NAME_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("serviceNetworkId", SERVICE_NETWORK_ID_FIELD);
        map.put("serviceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceNetworkResourceAssociationResponse, T> g) {
        return obj -> g.apply((GetServiceNetworkResourceAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetServiceNetworkResourceAssociationResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the association was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the association was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The account that created the association.
         * </p>
         * 
         * @param createdBy
         *        The account that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The DNS entry for the service.
         * </p>
         * 
         * @param dnsEntry
         *        The DNS entry for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntry(DnsEntry dnsEntry);

        /**
         * <p>
         * The DNS entry for the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #dnsEntry(DnsEntry)}.
         * 
         * @param dnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsEntry(DnsEntry)
         */
        default Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return dnsEntry(DnsEntry.builder().applyMutation(dnsEntry).build());
        }

        /**
         * <p>
         * The failure code.
         * </p>
         * 
         * @param failureCode
         *        The failure code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The reason the association request failed.
         * </p>
         * 
         * @param failureReason
         *        The reason the association request failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates whether the association is managed by Amazon.
         * </p>
         * 
         * @param isManagedAssociation
         *        Indicates whether the association is managed by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isManagedAssociation(Boolean isManagedAssociation);

        /**
         * <p>
         * The most recent date and time that the association was updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The most recent date and time that the association was updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The private DNS entry for the service.
         * </p>
         * 
         * @param privateDnsEntry
         *        The private DNS entry for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsEntry(DnsEntry privateDnsEntry);

        /**
         * <p>
         * The private DNS entry for the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #privateDnsEntry(DnsEntry)}.
         * 
         * @param privateDnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateDnsEntry(DnsEntry)
         */
        default Builder privateDnsEntry(Consumer<DnsEntry.Builder> privateDnsEntry) {
            return privateDnsEntry(DnsEntry.builder().applyMutation(privateDnsEntry).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * The ID of the resource configuration that is associated with the service network.
         * </p>
         * 
         * @param resourceConfigurationId
         *        The ID of the resource configuration that is associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationId(String resourceConfigurationId);

        /**
         * <p>
         * The name of the resource configuration that is associated with the service network.
         * </p>
         * 
         * @param resourceConfigurationName
         *        The name of the resource configuration that is associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationName(String resourceConfigurationName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network that is associated with the resource configuration.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of the service network that is associated with the resource
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The ID of the service network that is associated with the resource configuration.
         * </p>
         * 
         * @param serviceNetworkId
         *        The ID of the service network that is associated with the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkId(String serviceNetworkId);

        /**
         * <p>
         * The name of the service network that is associated with the resource configuration.
         * </p>
         * 
         * @param serviceNetworkName
         *        The name of the service network that is associated with the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkName(String serviceNetworkName);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param status
         *        The status of the association.
         * @see ServiceNetworkResourceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkResourceAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the association.
         * </p>
         * 
         * @param status
         *        The status of the association.
         * @see ServiceNetworkResourceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkResourceAssociationStatus
         */
        Builder status(ServiceNetworkResourceAssociationStatus status);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String createdBy;

        private DnsEntry dnsEntry;

        private String failureCode;

        private String failureReason;

        private String id;

        private Boolean isManagedAssociation;

        private Instant lastUpdatedAt;

        private DnsEntry privateDnsEntry;

        private String resourceConfigurationArn;

        private String resourceConfigurationId;

        private String resourceConfigurationName;

        private String serviceNetworkArn;

        private String serviceNetworkId;

        private String serviceNetworkName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceNetworkResourceAssociationResponse model) {
            super(model);
            arn(model.arn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            dnsEntry(model.dnsEntry);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
            id(model.id);
            isManagedAssociation(model.isManagedAssociation);
            lastUpdatedAt(model.lastUpdatedAt);
            privateDnsEntry(model.privateDnsEntry);
            resourceConfigurationArn(model.resourceConfigurationArn);
            resourceConfigurationId(model.resourceConfigurationId);
            resourceConfigurationName(model.resourceConfigurationName);
            serviceNetworkArn(model.serviceNetworkArn);
            serviceNetworkId(model.serviceNetworkId);
            serviceNetworkName(model.serviceNetworkName);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return dnsEntry != null ? dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsManagedAssociation() {
            return isManagedAssociation;
        }

        public final void setIsManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
        }

        @Override
        public final Builder isManagedAssociation(Boolean isManagedAssociation) {
            this.isManagedAssociation = isManagedAssociation;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final DnsEntry.Builder getPrivateDnsEntry() {
            return privateDnsEntry != null ? privateDnsEntry.toBuilder() : null;
        }

        public final void setPrivateDnsEntry(DnsEntry.BuilderImpl privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry != null ? privateDnsEntry.build() : null;
        }

        @Override
        public final Builder privateDnsEntry(DnsEntry privateDnsEntry) {
            this.privateDnsEntry = privateDnsEntry;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceConfigurationId() {
            return resourceConfigurationId;
        }

        public final void setResourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
        }

        @Override
        public final Builder resourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
            return this;
        }

        public final String getResourceConfigurationName() {
            return resourceConfigurationName;
        }

        public final void setResourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
        }

        @Override
        public final Builder resourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
            return this;
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkResourceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetServiceNetworkResourceAssociationResponse build() {
            return new GetServiceNetworkResourceAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
