/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceNetworkResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<GetServiceNetworkResponse.Builder, GetServiceNetworkResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetServiceNetworkResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(GetServiceNetworkResponse::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetServiceNetworkResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetServiceNetworkResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetServiceNetworkResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetServiceNetworkResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_SERVICES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAssociatedServices")
            .getter(getter(GetServiceNetworkResponse::numberOfAssociatedServices))
            .setter(setter(Builder::numberOfAssociatedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedServices").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_VP_CS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAssociatedVPCs").getter(getter(GetServiceNetworkResponse::numberOfAssociatedVPCs))
            .setter(setter(Builder::numberOfAssociatedVPCs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedVPCs").build())
            .build();

    private static final SdkField<SharingConfig> SHARING_CONFIG_FIELD = SdkField
            .<SharingConfig> builder(MarshallingType.SDK_POJO).memberName("sharingConfig")
            .getter(getter(GetServiceNetworkResponse::sharingConfig)).setter(setter(Builder::sharingConfig))
            .constructor(SharingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AUTH_TYPE_FIELD,
            CREATED_AT_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, NUMBER_OF_ASSOCIATED_SERVICES_FIELD,
            NUMBER_OF_ASSOCIATED_VP_CS_FIELD, SHARING_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String authType;

    private final Instant createdAt;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String name;

    private final Long numberOfAssociatedServices;

    private final Long numberOfAssociatedVPCs;

    private final SharingConfig sharingConfig;

    private GetServiceNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.authType = builder.authType;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.numberOfAssociatedServices = builder.numberOfAssociatedServices;
        this.numberOfAssociatedVPCs = builder.numberOfAssociatedVPCs;
        this.sharingConfig = builder.sharingConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    /**
     * <p>
     * The date and time that the service network was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the service network was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the service network.
     * </p>
     * 
     * @return The ID of the service network.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time of the last update, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time of the last update, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the service network.
     * </p>
     * 
     * @return The name of the service network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of services associated with the service network.
     * </p>
     * 
     * @return The number of services associated with the service network.
     */
    public final Long numberOfAssociatedServices() {
        return numberOfAssociatedServices;
    }

    /**
     * <p>
     * The number of VPCs associated with the service network.
     * </p>
     * 
     * @return The number of VPCs associated with the service network.
     */
    public final Long numberOfAssociatedVPCs() {
        return numberOfAssociatedVPCs;
    }

    /**
     * <p>
     * Specifies if the service network is enabled for sharing.
     * </p>
     * 
     * @return Specifies if the service network is enabled for sharing.
     */
    public final SharingConfig sharingConfig() {
        return sharingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedServices());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedVPCs());
        hashCode = 31 * hashCode + Objects.hashCode(sharingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceNetworkResponse)) {
            return false;
        }
        GetServiceNetworkResponse other = (GetServiceNetworkResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(authTypeAsString(), other.authTypeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(name(), other.name())
                && Objects.equals(numberOfAssociatedServices(), other.numberOfAssociatedServices())
                && Objects.equals(numberOfAssociatedVPCs(), other.numberOfAssociatedVPCs())
                && Objects.equals(sharingConfig(), other.sharingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetServiceNetworkResponse").add("Arn", arn()).add("AuthType", authTypeAsString())
                .add("CreatedAt", createdAt()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt()).add("Name", name())
                .add("NumberOfAssociatedServices", numberOfAssociatedServices())
                .add("NumberOfAssociatedVPCs", numberOfAssociatedVPCs()).add("SharingConfig", sharingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "numberOfAssociatedServices":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedServices()));
        case "numberOfAssociatedVPCs":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedVPCs()));
        case "sharingConfig":
            return Optional.ofNullable(clazz.cast(sharingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("numberOfAssociatedServices", NUMBER_OF_ASSOCIATED_SERVICES_FIELD);
        map.put("numberOfAssociatedVPCs", NUMBER_OF_ASSOCIATED_VP_CS_FIELD);
        map.put("sharingConfig", SHARING_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetServiceNetworkResponse, T> g) {
        return obj -> g.apply((GetServiceNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServiceNetworkResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * 
         * @param authType
         *        The type of IAM policy.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * 
         * @param authType
         *        The type of IAM policy.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        /**
         * <p>
         * The date and time that the service network was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the service network was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the service network.
         * </p>
         * 
         * @param id
         *        The ID of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time of the last update, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time of the last update, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The name of the service network.
         * </p>
         * 
         * @param name
         *        The name of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of services associated with the service network.
         * </p>
         * 
         * @param numberOfAssociatedServices
         *        The number of services associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedServices(Long numberOfAssociatedServices);

        /**
         * <p>
         * The number of VPCs associated with the service network.
         * </p>
         * 
         * @param numberOfAssociatedVPCs
         *        The number of VPCs associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedVPCs(Long numberOfAssociatedVPCs);

        /**
         * <p>
         * Specifies if the service network is enabled for sharing.
         * </p>
         * 
         * @param sharingConfig
         *        Specifies if the service network is enabled for sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharingConfig(SharingConfig sharingConfig);

        /**
         * <p>
         * Specifies if the service network is enabled for sharing.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharingConfig.Builder} avoiding the need
         * to create one manually via {@link SharingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sharingConfig(SharingConfig)}.
         * 
         * @param sharingConfig
         *        a consumer that will call methods on {@link SharingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharingConfig(SharingConfig)
         */
        default Builder sharingConfig(Consumer<SharingConfig.Builder> sharingConfig) {
            return sharingConfig(SharingConfig.builder().applyMutation(sharingConfig).build());
        }
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String arn;

        private String authType;

        private Instant createdAt;

        private String id;

        private Instant lastUpdatedAt;

        private String name;

        private Long numberOfAssociatedServices;

        private Long numberOfAssociatedVPCs;

        private SharingConfig sharingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceNetworkResponse model) {
            super(model);
            arn(model.arn);
            authType(model.authType);
            createdAt(model.createdAt);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            name(model.name);
            numberOfAssociatedServices(model.numberOfAssociatedServices);
            numberOfAssociatedVPCs(model.numberOfAssociatedVPCs);
            sharingConfig(model.sharingConfig);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getNumberOfAssociatedServices() {
            return numberOfAssociatedServices;
        }

        public final void setNumberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
        }

        @Override
        public final Builder numberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
            return this;
        }

        public final Long getNumberOfAssociatedVPCs() {
            return numberOfAssociatedVPCs;
        }

        public final void setNumberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
        }

        @Override
        public final Builder numberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
            return this;
        }

        public final SharingConfig.Builder getSharingConfig() {
            return sharingConfig != null ? sharingConfig.toBuilder() : null;
        }

        public final void setSharingConfig(SharingConfig.BuilderImpl sharingConfig) {
            this.sharingConfig = sharingConfig != null ? sharingConfig.build() : null;
        }

        @Override
        public final Builder sharingConfig(SharingConfig sharingConfig) {
            this.sharingConfig = sharingConfig;
            return this;
        }

        @Override
        public GetServiceNetworkResponse build() {
            return new GetServiceNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
