/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the constraints for a header match. Matches incoming requests with rule based on request header value
 * before applying rule action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HeaderMatch implements SdkPojo, Serializable, ToCopyableBuilder<HeaderMatch.Builder, HeaderMatch> {
    private static final SdkField<Boolean> CASE_SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("caseSensitive").getter(getter(HeaderMatch::caseSensitive)).setter(setter(Builder::caseSensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseSensitive").build()).build();

    private static final SdkField<HeaderMatchType> MATCH_FIELD = SdkField.<HeaderMatchType> builder(MarshallingType.SDK_POJO)
            .memberName("match").getter(getter(HeaderMatch::match)).setter(setter(Builder::match))
            .constructor(HeaderMatchType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(HeaderMatch::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_SENSITIVE_FIELD,
            MATCH_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean caseSensitive;

    private final HeaderMatchType match;

    private final String name;

    private HeaderMatch(BuilderImpl builder) {
        this.caseSensitive = builder.caseSensitive;
        this.match = builder.match;
        this.name = builder.name;
    }

    /**
     * <p>
     * Indicates whether the match is case sensitive.
     * </p>
     * 
     * @return Indicates whether the match is case sensitive.
     */
    public final Boolean caseSensitive() {
        return caseSensitive;
    }

    /**
     * <p>
     * The header match type.
     * </p>
     * 
     * @return The header match type.
     */
    public final HeaderMatchType match() {
        return match;
    }

    /**
     * <p>
     * The name of the header.
     * </p>
     * 
     * @return The name of the header.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseSensitive());
        hashCode = 31 * hashCode + Objects.hashCode(match());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeaderMatch)) {
            return false;
        }
        HeaderMatch other = (HeaderMatch) obj;
        return Objects.equals(caseSensitive(), other.caseSensitive()) && Objects.equals(match(), other.match())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HeaderMatch").add("CaseSensitive", caseSensitive()).add("Match", match()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseSensitive":
            return Optional.ofNullable(clazz.cast(caseSensitive()));
        case "match":
            return Optional.ofNullable(clazz.cast(match()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseSensitive", CASE_SENSITIVE_FIELD);
        map.put("match", MATCH_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HeaderMatch, T> g) {
        return obj -> g.apply((HeaderMatch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HeaderMatch> {
        /**
         * <p>
         * Indicates whether the match is case sensitive.
         * </p>
         * 
         * @param caseSensitive
         *        Indicates whether the match is case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseSensitive(Boolean caseSensitive);

        /**
         * <p>
         * The header match type.
         * </p>
         * 
         * @param match
         *        The header match type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder match(HeaderMatchType match);

        /**
         * <p>
         * The header match type.
         * </p>
         * This is a convenience method that creates an instance of the {@link HeaderMatchType.Builder} avoiding the
         * need to create one manually via {@link HeaderMatchType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HeaderMatchType.Builder#build()} is called immediately and its
         * result is passed to {@link #match(HeaderMatchType)}.
         * 
         * @param match
         *        a consumer that will call methods on {@link HeaderMatchType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #match(HeaderMatchType)
         */
        default Builder match(Consumer<HeaderMatchType.Builder> match) {
            return match(HeaderMatchType.builder().applyMutation(match).build());
        }

        /**
         * <p>
         * The name of the header.
         * </p>
         * 
         * @param name
         *        The name of the header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private Boolean caseSensitive;

        private HeaderMatchType match;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(HeaderMatch model) {
            caseSensitive(model.caseSensitive);
            match(model.match);
            name(model.name);
        }

        public final Boolean getCaseSensitive() {
            return caseSensitive;
        }

        public final void setCaseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        @Override
        public final Builder caseSensitive(Boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public final HeaderMatchType.Builder getMatch() {
            return match != null ? match.toBuilder() : null;
        }

        public final void setMatch(HeaderMatchType.BuilderImpl match) {
            this.match = match != null ? match.build() : null;
        }

        @Override
        public final Builder match(HeaderMatchType match) {
            this.match = match;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public HeaderMatch build() {
            return new HeaderMatch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
