/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceConfigurationsRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<ListResourceConfigurationsRequest.Builder, ListResourceConfigurationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListResourceConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResourceConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupIdentifier")
            .getter(getter(ListResourceConfigurationsRequest::resourceConfigurationGroupIdentifier))
            .setter(setter(Builder::resourceConfigurationGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("resourceConfigurationGroupIdentifier").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayIdentifier")
            .getter(getter(ListResourceConfigurationsRequest::resourceGatewayIdentifier))
            .setter(setter(Builder::resourceGatewayIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceGatewayIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD, RESOURCE_GATEWAY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceConfigurationGroupIdentifier;

    private final String resourceGatewayIdentifier;

    private ListResourceConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceConfigurationGroupIdentifier = builder.resourceConfigurationGroupIdentifier;
        this.resourceGatewayIdentifier = builder.resourceGatewayIdentifier;
    }

    /**
     * <p>
     * The maximum page size.
     * </p>
     * 
     * @return The maximum page size.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token for the next page of results.
     * </p>
     * 
     * @return A pagination token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the group resource configuration.
     * </p>
     * 
     * @return The ID of the group resource configuration.
     */
    public final String resourceConfigurationGroupIdentifier() {
        return resourceConfigurationGroupIdentifier;
    }

    /**
     * <p>
     * The ID of the resource gateway for the resource configuration.
     * </p>
     * 
     * @return The ID of the resource gateway for the resource configuration.
     */
    public final String resourceGatewayIdentifier() {
        return resourceGatewayIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceConfigurationsRequest)) {
            return false;
        }
        ListResourceConfigurationsRequest other = (ListResourceConfigurationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceConfigurationGroupIdentifier(), other.resourceConfigurationGroupIdentifier())
                && Objects.equals(resourceGatewayIdentifier(), other.resourceGatewayIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceConfigurationsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken())
                .add("ResourceConfigurationGroupIdentifier", resourceConfigurationGroupIdentifier())
                .add("ResourceGatewayIdentifier", resourceGatewayIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourceConfigurationGroupIdentifier":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupIdentifier()));
        case "resourceGatewayIdentifier":
            return Optional.ofNullable(clazz.cast(resourceGatewayIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceConfigurationGroupIdentifier", RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD);
        map.put("resourceGatewayIdentifier", RESOURCE_GATEWAY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceConfigurationsRequest, T> g) {
        return obj -> g.apply((ListResourceConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceConfigurationsRequest> {
        /**
         * <p>
         * The maximum page size.
         * </p>
         * 
         * @param maxResults
         *        The maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupIdentifier
         *        The ID of the group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier);

        /**
         * <p>
         * The ID of the resource gateway for the resource configuration.
         * </p>
         * 
         * @param resourceGatewayIdentifier
         *        The ID of the resource gateway for the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayIdentifier(String resourceGatewayIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String resourceConfigurationGroupIdentifier;

        private String resourceGatewayIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceConfigurationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceConfigurationGroupIdentifier(model.resourceConfigurationGroupIdentifier);
            resourceGatewayIdentifier(model.resourceGatewayIdentifier);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceConfigurationGroupIdentifier() {
            return resourceConfigurationGroupIdentifier;
        }

        public final void setResourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
        }

        @Override
        public final Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
            return this;
        }

        public final String getResourceGatewayIdentifier() {
            return resourceGatewayIdentifier;
        }

        public final void setResourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
        }

        @Override
        public final Builder resourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceConfigurationsRequest build() {
            return new ListResourceConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
