/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceEndpointAssociationsRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<ListResourceEndpointAssociationsRequest.Builder, ListResourceEndpointAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListResourceEndpointAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListResourceEndpointAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationIdentifier")
            .getter(getter(ListResourceEndpointAssociationsRequest::resourceConfigurationIdentifier))
            .setter(setter(Builder::resourceConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("resourceConfigurationIdentifier").build()).build();

    private static final SdkField<String> RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceEndpointAssociationIdentifier")
            .getter(getter(ListResourceEndpointAssociationsRequest::resourceEndpointAssociationIdentifier))
            .setter(setter(Builder::resourceEndpointAssociationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("resourceEndpointAssociationIdentifier").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointId").getter(getter(ListResourceEndpointAssociationsRequest::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointOwner").getter(getter(ListResourceEndpointAssociationsRequest::vpcEndpointOwner))
            .setter(setter(Builder::vpcEndpointOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("vpcEndpointOwner").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, RESOURCE_CONFIGURATION_IDENTIFIER_FIELD, RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD,
            VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String resourceConfigurationIdentifier;

    private final String resourceEndpointAssociationIdentifier;

    private final String vpcEndpointId;

    private final String vpcEndpointOwner;

    private ListResourceEndpointAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.resourceConfigurationIdentifier = builder.resourceConfigurationIdentifier;
        this.resourceEndpointAssociationIdentifier = builder.resourceEndpointAssociationIdentifier;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
    }

    /**
     * <p>
     * The maximum page size.
     * </p>
     * 
     * @return The maximum page size.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token for the next page of results.
     * </p>
     * 
     * @return A pagination token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID for the resource configuration associated with the VPC endpoint.
     * </p>
     * 
     * @return The ID for the resource configuration associated with the VPC endpoint.
     */
    public final String resourceConfigurationIdentifier() {
        return resourceConfigurationIdentifier;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String resourceEndpointAssociationIdentifier() {
        return resourceEndpointAssociationIdentifier;
    }

    /**
     * <p>
     * The ID of the VPC endpoint in the association.
     * </p>
     * 
     * @return The ID of the VPC endpoint in the association.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The owner of the VPC endpoint in the association.
     * </p>
     * 
     * @return The owner of the VPC endpoint in the association.
     */
    public final String vpcEndpointOwner() {
        return vpcEndpointOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceEndpointAssociationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceEndpointAssociationsRequest)) {
            return false;
        }
        ListResourceEndpointAssociationsRequest other = (ListResourceEndpointAssociationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(resourceConfigurationIdentifier(), other.resourceConfigurationIdentifier())
                && Objects.equals(resourceEndpointAssociationIdentifier(), other.resourceEndpointAssociationIdentifier())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcEndpointOwner(), other.vpcEndpointOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceEndpointAssociationsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ResourceConfigurationIdentifier", resourceConfigurationIdentifier())
                .add("ResourceEndpointAssociationIdentifier", resourceEndpointAssociationIdentifier())
                .add("VpcEndpointId", vpcEndpointId()).add("VpcEndpointOwner", vpcEndpointOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "resourceConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(resourceConfigurationIdentifier()));
        case "resourceEndpointAssociationIdentifier":
            return Optional.ofNullable(clazz.cast(resourceEndpointAssociationIdentifier()));
        case "vpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "vpcEndpointOwner":
            return Optional.ofNullable(clazz.cast(vpcEndpointOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("resourceConfigurationIdentifier", RESOURCE_CONFIGURATION_IDENTIFIER_FIELD);
        map.put("resourceEndpointAssociationIdentifier", RESOURCE_ENDPOINT_ASSOCIATION_IDENTIFIER_FIELD);
        map.put("vpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("vpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceEndpointAssociationsRequest, T> g) {
        return obj -> g.apply((ListResourceEndpointAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceEndpointAssociationsRequest> {
        /**
         * <p>
         * The maximum page size.
         * </p>
         * 
         * @param maxResults
         *        The maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID for the resource configuration associated with the VPC endpoint.
         * </p>
         * 
         * @param resourceConfigurationIdentifier
         *        The ID for the resource configuration associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param resourceEndpointAssociationIdentifier
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier);

        /**
         * <p>
         * The ID of the VPC endpoint in the association.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The owner of the VPC endpoint in the association.
         * </p>
         * 
         * @param vpcEndpointOwner
         *        The owner of the VPC endpoint in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointOwner(String vpcEndpointOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String resourceConfigurationIdentifier;

        private String resourceEndpointAssociationIdentifier;

        private String vpcEndpointId;

        private String vpcEndpointOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceEndpointAssociationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            resourceConfigurationIdentifier(model.resourceConfigurationIdentifier);
            resourceEndpointAssociationIdentifier(model.resourceEndpointAssociationIdentifier);
            vpcEndpointId(model.vpcEndpointId);
            vpcEndpointOwner(model.vpcEndpointOwner);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getResourceConfigurationIdentifier() {
            return resourceConfigurationIdentifier;
        }

        public final void setResourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
        }

        @Override
        public final Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
            return this;
        }

        public final String getResourceEndpointAssociationIdentifier() {
            return resourceEndpointAssociationIdentifier;
        }

        public final void setResourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
        }

        @Override
        public final Builder resourceEndpointAssociationIdentifier(String resourceEndpointAssociationIdentifier) {
            this.resourceEndpointAssociationIdentifier = resourceEndpointAssociationIdentifier;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceEndpointAssociationsRequest build() {
            return new ListResourceEndpointAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
