/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceNetworkVpcEndpointAssociationsRequest extends VpcLatticeRequest
        implements
        ToCopyableBuilder<ListServiceNetworkVpcEndpointAssociationsRequest.Builder, ListServiceNetworkVpcEndpointAssociationsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceNetworkVpcEndpointAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceNetworkVpcEndpointAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkIdentifier")
            .getter(getter(ListServiceNetworkVpcEndpointAssociationsRequest::serviceNetworkIdentifier))
            .setter(setter(Builder::serviceNetworkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceNetworkIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SERVICE_NETWORK_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String serviceNetworkIdentifier;

    private ListServiceNetworkVpcEndpointAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
    }

    /**
     * <p>
     * The maximum page size.
     * </p>
     * 
     * @return The maximum page size.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If there are additional results, a pagination token for the next page of results.
     * </p>
     * 
     * @return If there are additional results, a pagination token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ID of the service network associated with the VPC endpoint.
     * </p>
     * 
     * @return The ID of the service network associated with the VPC endpoint.
     */
    public final String serviceNetworkIdentifier() {
        return serviceNetworkIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceNetworkVpcEndpointAssociationsRequest)) {
            return false;
        }
        ListServiceNetworkVpcEndpointAssociationsRequest other = (ListServiceNetworkVpcEndpointAssociationsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(serviceNetworkIdentifier(), other.serviceNetworkIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceNetworkVpcEndpointAssociationsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ServiceNetworkIdentifier", serviceNetworkIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "serviceNetworkIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceNetworkVpcEndpointAssociationsRequest, T> g) {
        return obj -> g.apply((ListServiceNetworkVpcEndpointAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceNetworkVpcEndpointAssociationsRequest> {
        /**
         * <p>
         * The maximum page size.
         * </p>
         * 
         * @param maxResults
         *        The maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If there are additional results, a pagination token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, a pagination token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ID of the service network associated with the VPC endpoint.
         * </p>
         * 
         * @param serviceNetworkIdentifier
         *        The ID of the service network associated with the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkIdentifier(String serviceNetworkIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String serviceNetworkIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceNetworkVpcEndpointAssociationsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            serviceNetworkIdentifier(model.serviceNetworkIdentifier);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServiceNetworkIdentifier() {
            return serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceNetworkVpcEndpointAssociationsRequest build() {
            return new ListServiceNetworkVpcEndpointAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
