/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a VPC endpoint association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceEndpointAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceEndpointAssociationSummary.Builder, ResourceEndpointAssociationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceEndpointAssociationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ResourceEndpointAssociationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ResourceEndpointAssociationSummary::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ResourceEndpointAssociationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationArn").getter(getter(ResourceEndpointAssociationSummary::resourceConfigurationArn))
            .setter(setter(Builder::resourceConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArn").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationId").getter(getter(ResourceEndpointAssociationSummary::resourceConfigurationId))
            .setter(setter(Builder::resourceConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationId").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationName")
            .getter(getter(ResourceEndpointAssociationSummary::resourceConfigurationName))
            .setter(setter(Builder::resourceConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationName").build())
            .build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointId").getter(getter(ResourceEndpointAssociationSummary::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointOwner").getter(getter(ResourceEndpointAssociationSummary::vpcEndpointOwner))
            .setter(setter(Builder::vpcEndpointOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointOwner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            CREATED_BY_FIELD, ID_FIELD, RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_CONFIGURATION_ID_FIELD,
            RESOURCE_CONFIGURATION_NAME_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String createdBy;

    private final String id;

    private final String resourceConfigurationArn;

    private final String resourceConfigurationId;

    private final String resourceConfigurationName;

    private final String vpcEndpointId;

    private final String vpcEndpointOwner;

    private ResourceEndpointAssociationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.id = builder.id;
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceConfigurationId = builder.resourceConfigurationId;
        this.resourceConfigurationName = builder.resourceConfigurationName;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwner = builder.vpcEndpointOwner;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the VPC endpoint association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the VPC endpoint association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the VPC endpoint association was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the VPC endpoint association was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The account that created the association.
     * </p>
     * 
     * @return The account that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The ID of the VPC endpoint association.
     * </p>
     * 
     * @return The ID of the VPC endpoint association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration.
     */
    public final String resourceConfigurationArn() {
        return resourceConfigurationArn;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String resourceConfigurationId() {
        return resourceConfigurationId;
    }

    /**
     * <p>
     * The name of the resource configuration.
     * </p>
     * 
     * @return The name of the resource configuration.
     */
    public final String resourceConfigurationName() {
        return resourceConfigurationName;
    }

    /**
     * <p>
     * The ID of the VPC endpoint.
     * </p>
     * 
     * @return The ID of the VPC endpoint.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The owner of the VPC endpoint.
     * </p>
     * 
     * @return The owner of the VPC endpoint.
     */
    public final String vpcEndpointOwner() {
        return vpcEndpointOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointOwner());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEndpointAssociationSummary)) {
            return false;
        }
        ResourceEndpointAssociationSummary other = (ResourceEndpointAssociationSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(id(), other.id())
                && Objects.equals(resourceConfigurationArn(), other.resourceConfigurationArn())
                && Objects.equals(resourceConfigurationId(), other.resourceConfigurationId())
                && Objects.equals(resourceConfigurationName(), other.resourceConfigurationName())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcEndpointOwner(), other.vpcEndpointOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceEndpointAssociationSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy()).add("Id", id()).add("ResourceConfigurationArn", resourceConfigurationArn())
                .add("ResourceConfigurationId", resourceConfigurationId())
                .add("ResourceConfigurationName", resourceConfigurationName()).add("VpcEndpointId", vpcEndpointId())
                .add("VpcEndpointOwner", vpcEndpointOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resourceConfigurationArn":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArn()));
        case "resourceConfigurationId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationId()));
        case "resourceConfigurationName":
            return Optional.ofNullable(clazz.cast(resourceConfigurationName()));
        case "vpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "vpcEndpointOwner":
            return Optional.ofNullable(clazz.cast(vpcEndpointOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("id", ID_FIELD);
        map.put("resourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("resourceConfigurationId", RESOURCE_CONFIGURATION_ID_FIELD);
        map.put("resourceConfigurationName", RESOURCE_CONFIGURATION_NAME_FIELD);
        map.put("vpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("vpcEndpointOwner", VPC_ENDPOINT_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceEndpointAssociationSummary, T> g) {
        return obj -> g.apply((ResourceEndpointAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceEndpointAssociationSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the VPC endpoint association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the VPC endpoint association was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the VPC endpoint association was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The account that created the association.
         * </p>
         * 
         * @param createdBy
         *        The account that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The ID of the VPC endpoint association.
         * </p>
         * 
         * @param id
         *        The ID of the VPC endpoint association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationArn
         *        The Amazon Resource Name (ARN) of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArn(String resourceConfigurationArn);

        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationId
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationId(String resourceConfigurationId);

        /**
         * <p>
         * The name of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationName
         *        The name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationName(String resourceConfigurationName);

        /**
         * <p>
         * The ID of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The owner of the VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointOwner
         *        The owner of the VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointOwner(String vpcEndpointOwner);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String createdBy;

        private String id;

        private String resourceConfigurationArn;

        private String resourceConfigurationId;

        private String resourceConfigurationName;

        private String vpcEndpointId;

        private String vpcEndpointOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEndpointAssociationSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            id(model.id);
            resourceConfigurationArn(model.resourceConfigurationArn);
            resourceConfigurationId(model.resourceConfigurationId);
            resourceConfigurationName(model.resourceConfigurationName);
            vpcEndpointId(model.vpcEndpointId);
            vpcEndpointOwner(model.vpcEndpointOwner);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResourceConfigurationArn() {
            return resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceConfigurationId() {
            return resourceConfigurationId;
        }

        public final void setResourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
        }

        @Override
        public final Builder resourceConfigurationId(String resourceConfigurationId) {
            this.resourceConfigurationId = resourceConfigurationId;
            return this;
        }

        public final String getResourceConfigurationName() {
            return resourceConfigurationName;
        }

        public final void setResourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
        }

        @Override
        public final Builder resourceConfigurationName(String resourceConfigurationName) {
            this.resourceConfigurationName = resourceConfigurationName;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwner() {
            return vpcEndpointOwner;
        }

        public final void setVpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
        }

        @Override
        public final Builder vpcEndpointOwner(String vpcEndpointOwner) {
            this.vpcEndpointOwner = vpcEndpointOwner;
            return this;
        }

        @Override
        public ResourceEndpointAssociationSummary build() {
            return new ResourceEndpointAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
