/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the action for a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleAction implements SdkPojo, Serializable, ToCopyableBuilder<RuleAction.Builder, RuleAction> {
    private static final SdkField<FixedResponseAction> FIXED_RESPONSE_FIELD = SdkField
            .<FixedResponseAction> builder(MarshallingType.SDK_POJO).memberName("fixedResponse")
            .getter(getter(RuleAction::fixedResponse)).setter(setter(Builder::fixedResponse))
            .constructor(FixedResponseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedResponse").build()).build();

    private static final SdkField<ForwardAction> FORWARD_FIELD = SdkField.<ForwardAction> builder(MarshallingType.SDK_POJO)
            .memberName("forward").getter(getter(RuleAction::forward)).setter(setter(Builder::forward))
            .constructor(ForwardAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forward").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIXED_RESPONSE_FIELD,
            FORWARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FixedResponseAction fixedResponse;

    private final ForwardAction forward;

    private final Type type;

    private RuleAction(BuilderImpl builder) {
        this.fixedResponse = builder.fixedResponse;
        this.forward = builder.forward;
        this.type = builder.type;
    }

    /**
     * <p>
     * The fixed response action. The rule returns a custom HTTP response.
     * </p>
     * 
     * @return The fixed response action. The rule returns a custom HTTP response.
     */
    public final FixedResponseAction fixedResponse() {
        return fixedResponse;
    }

    /**
     * <p>
     * The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     * </p>
     * 
     * @return The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    public final ForwardAction forward() {
        return forward;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fixedResponse());
        hashCode = 31 * hashCode + Objects.hashCode(forward());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction) obj;
        return Objects.equals(fixedResponse(), other.fixedResponse()) && Objects.equals(forward(), other.forward());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleAction").add("FixedResponse", fixedResponse()).add("Forward", forward()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fixedResponse":
            return Optional.ofNullable(clazz.cast(fixedResponse()));
        case "forward":
            return Optional.ofNullable(clazz.cast(forward()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fixedResponse()} initialized to the given value.
     *
     * <p>
     * The fixed response action. The rule returns a custom HTTP response.
     * </p>
     * 
     * @param fixedResponse
     *        The fixed response action. The rule returns a custom HTTP response.
     */
    public static RuleAction fromFixedResponse(FixedResponseAction fixedResponse) {
        return builder().fixedResponse(fixedResponse).build();
    }

    /**
     * Create an instance of this class with {@link #fixedResponse()} initialized to the given value.
     *
     * <p>
     * The fixed response action. The rule returns a custom HTTP response.
     * </p>
     * 
     * @param fixedResponse
     *        The fixed response action. The rule returns a custom HTTP response.
     */
    public static RuleAction fromFixedResponse(Consumer<FixedResponseAction.Builder> fixedResponse) {
        FixedResponseAction.Builder builder = FixedResponseAction.builder();
        fixedResponse.accept(builder);
        return fromFixedResponse(builder.build());
    }

    /**
     * Create an instance of this class with {@link #forward()} initialized to the given value.
     *
     * <p>
     * The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     * </p>
     * 
     * @param forward
     *        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    public static RuleAction fromForward(ForwardAction forward) {
        return builder().forward(forward).build();
    }

    /**
     * Create an instance of this class with {@link #forward()} initialized to the given value.
     *
     * <p>
     * The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     * </p>
     * 
     * @param forward
     *        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
     */
    public static RuleAction fromForward(Consumer<ForwardAction.Builder> forward) {
        ForwardAction.Builder builder = ForwardAction.builder();
        forward.accept(builder);
        return fromForward(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fixedResponse", FIXED_RESPONSE_FIELD);
        map.put("forward", FORWARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleAction> {
        /**
         * <p>
         * The fixed response action. The rule returns a custom HTTP response.
         * </p>
         * 
         * @param fixedResponse
         *        The fixed response action. The rule returns a custom HTTP response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedResponse(FixedResponseAction fixedResponse);

        /**
         * <p>
         * The fixed response action. The rule returns a custom HTTP response.
         * </p>
         * This is a convenience method that creates an instance of the {@link FixedResponseAction.Builder} avoiding the
         * need to create one manually via {@link FixedResponseAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FixedResponseAction.Builder#build()} is called immediately and
         * its result is passed to {@link #fixedResponse(FixedResponseAction)}.
         * 
         * @param fixedResponse
         *        a consumer that will call methods on {@link FixedResponseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fixedResponse(FixedResponseAction)
         */
        default Builder fixedResponse(Consumer<FixedResponseAction.Builder> fixedResponse) {
            return fixedResponse(FixedResponseAction.builder().applyMutation(fixedResponse).build());
        }

        /**
         * <p>
         * The forward action. Traffic that matches the rule is forwarded to the specified target groups.
         * </p>
         * 
         * @param forward
         *        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forward(ForwardAction forward);

        /**
         * <p>
         * The forward action. Traffic that matches the rule is forwarded to the specified target groups.
         * </p>
         * This is a convenience method that creates an instance of the {@link ForwardAction.Builder} avoiding the need
         * to create one manually via {@link ForwardAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ForwardAction.Builder#build()} is called immediately and its
         * result is passed to {@link #forward(ForwardAction)}.
         * 
         * @param forward
         *        a consumer that will call methods on {@link ForwardAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forward(ForwardAction)
         */
        default Builder forward(Consumer<ForwardAction.Builder> forward) {
            return forward(ForwardAction.builder().applyMutation(forward).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FixedResponseAction fixedResponse;

        private ForwardAction forward;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            fixedResponse(model.fixedResponse);
            forward(model.forward);
        }

        public final FixedResponseAction.Builder getFixedResponse() {
            return fixedResponse != null ? fixedResponse.toBuilder() : null;
        }

        public final void setFixedResponse(FixedResponseAction.BuilderImpl fixedResponse) {
            Object oldValue = this.fixedResponse;
            this.fixedResponse = fixedResponse != null ? fixedResponse.build() : null;
            handleUnionValueChange(Type.FIXED_RESPONSE, oldValue, this.fixedResponse);
        }

        @Override
        public final Builder fixedResponse(FixedResponseAction fixedResponse) {
            Object oldValue = this.fixedResponse;
            this.fixedResponse = fixedResponse;
            handleUnionValueChange(Type.FIXED_RESPONSE, oldValue, this.fixedResponse);
            return this;
        }

        public final ForwardAction.Builder getForward() {
            return forward != null ? forward.toBuilder() : null;
        }

        public final void setForward(ForwardAction.BuilderImpl forward) {
            Object oldValue = this.forward;
            this.forward = forward != null ? forward.build() : null;
            handleUnionValueChange(Type.FORWARD, oldValue, this.forward);
        }

        @Override
        public final Builder forward(ForwardAction forward) {
            Object oldValue = this.forward;
            this.forward = forward;
            handleUnionValueChange(Type.FORWARD, oldValue, this.forward);
            return this;
        }

        @Override
        public RuleAction build() {
            return new RuleAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleAction#type()
     */
    public enum Type {
        FIXED_RESPONSE,

        FORWARD,

        UNKNOWN_TO_SDK_VERSION
    }
}
