/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the association between a service network and a VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNetworkEndpointAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNetworkEndpointAssociation.Builder, ServiceNetworkEndpointAssociation> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ServiceNetworkEndpointAssociation::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceNetworkEndpointAssociation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkArn").getter(getter(ServiceNetworkEndpointAssociation::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ServiceNetworkEndpointAssociation::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointId").getter(getter(ServiceNetworkEndpointAssociation::vpcEndpointId))
            .setter(setter(Builder::vpcEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointId").build()).build();

    private static final SdkField<String> VPC_ENDPOINT_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointOwnerId").getter(getter(ServiceNetworkEndpointAssociation::vpcEndpointOwnerId))
            .setter(setter(Builder::vpcEndpointOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointOwnerId").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(ServiceNetworkEndpointAssociation::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ID_FIELD,
            SERVICE_NETWORK_ARN_FIELD, STATE_FIELD, VPC_ENDPOINT_ID_FIELD, VPC_ENDPOINT_OWNER_ID_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String id;

    private final String serviceNetworkArn;

    private final String state;

    private final String vpcEndpointId;

    private final String vpcEndpointOwnerId;

    private final String vpcId;

    private ServiceNetworkEndpointAssociation(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.state = builder.state;
        this.vpcEndpointId = builder.vpcEndpointId;
        this.vpcEndpointOwnerId = builder.vpcEndpointOwnerId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The date and time that the association was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the association was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The state of the association.
     * </p>
     * 
     * @return The state of the association.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The ID of the VPC endpoint associated with the service network.
     * </p>
     * 
     * @return The ID of the VPC endpoint associated with the service network.
     */
    public final String vpcEndpointId() {
        return vpcEndpointId;
    }

    /**
     * <p>
     * The owner of the VPC endpoint associated with the service network.
     * </p>
     * 
     * @return The owner of the VPC endpoint associated with the service network.
     */
    public final String vpcEndpointOwnerId() {
        return vpcEndpointOwnerId;
    }

    /**
     * <p>
     * The ID of the VPC for the association.
     * </p>
     * 
     * @return The ID of the VPC for the association.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkEndpointAssociation)) {
            return false;
        }
        ServiceNetworkEndpointAssociation other = (ServiceNetworkEndpointAssociation) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(state(), other.state())
                && Objects.equals(vpcEndpointId(), other.vpcEndpointId())
                && Objects.equals(vpcEndpointOwnerId(), other.vpcEndpointOwnerId()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNetworkEndpointAssociation").add("CreatedAt", createdAt()).add("Id", id())
                .add("ServiceNetworkArn", serviceNetworkArn()).add("State", state()).add("VpcEndpointId", vpcEndpointId())
                .add("VpcEndpointOwnerId", vpcEndpointOwnerId()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "serviceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        case "vpcEndpointId":
            return Optional.ofNullable(clazz.cast(vpcEndpointId()));
        case "vpcEndpointOwnerId":
            return Optional.ofNullable(clazz.cast(vpcEndpointOwnerId()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("state", STATE_FIELD);
        map.put("vpcEndpointId", VPC_ENDPOINT_ID_FIELD);
        map.put("vpcEndpointOwnerId", VPC_ENDPOINT_OWNER_ID_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkEndpointAssociation, T> g) {
        return obj -> g.apply((ServiceNetworkEndpointAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNetworkEndpointAssociation> {
        /**
         * <p>
         * The date and time that the association was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the association was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The state of the association.
         * </p>
         * 
         * @param state
         *        The state of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The ID of the VPC endpoint associated with the service network.
         * </p>
         * 
         * @param vpcEndpointId
         *        The ID of the VPC endpoint associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointId(String vpcEndpointId);

        /**
         * <p>
         * The owner of the VPC endpoint associated with the service network.
         * </p>
         * 
         * @param vpcEndpointOwnerId
         *        The owner of the VPC endpoint associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointOwnerId(String vpcEndpointOwnerId);

        /**
         * <p>
         * The ID of the VPC for the association.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String id;

        private String serviceNetworkArn;

        private String state;

        private String vpcEndpointId;

        private String vpcEndpointOwnerId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkEndpointAssociation model) {
            createdAt(model.createdAt);
            id(model.id);
            serviceNetworkArn(model.serviceNetworkArn);
            state(model.state);
            vpcEndpointId(model.vpcEndpointId);
            vpcEndpointOwnerId(model.vpcEndpointOwnerId);
            vpcId(model.vpcId);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getVpcEndpointId() {
            return vpcEndpointId;
        }

        public final void setVpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
        }

        @Override
        public final Builder vpcEndpointId(String vpcEndpointId) {
            this.vpcEndpointId = vpcEndpointId;
            return this;
        }

        public final String getVpcEndpointOwnerId() {
            return vpcEndpointOwnerId;
        }

        public final void setVpcEndpointOwnerId(String vpcEndpointOwnerId) {
            this.vpcEndpointOwnerId = vpcEndpointOwnerId;
        }

        @Override
        public final Builder vpcEndpointOwnerId(String vpcEndpointOwnerId) {
            this.vpcEndpointOwnerId = vpcEndpointOwnerId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public ServiceNetworkEndpointAssociation build() {
            return new ServiceNetworkEndpointAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
