/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetSummary implements SdkPojo, Serializable, ToCopyableBuilder<TargetSummary.Builder, TargetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TargetSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(TargetSummary::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reasonCode").getter(getter(TargetSummary::reasonCode)).setter(setter(Builder::reasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasonCode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TargetSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, PORT_FIELD,
            REASON_CODE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Integer port;

    private final String reasonCode;

    private final String status;

    private TargetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.port = builder.port;
        this.reasonCode = builder.reasonCode;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the target
     * group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>, this is
     * the ARN of a Lambda function. If the target type is <code>ALB</code>, this is the ARN of an Application Load
     * Balancer.
     * </p>
     * 
     * @return The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the
     *         target group type is <code>IP</code>, this is an IP address. If the target group type is
     *         <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target type is <code>ALB</code>, this
     *         is the ARN of an Application Load Balancer.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The port on which the target is listening.
     * </p>
     * 
     * @return The port on which the target is listening.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The code for why the target status is what it is.
     * </p>
     * 
     * @return The code for why the target status is what it is.
     */
    public final String reasonCode() {
        return reasonCode;
    }

    /**
     * <p>
     * The status of the target.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while current
     * connections are being drained. The default draining time is 5 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HEALTHY</code>: The target is healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>: The target is unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INITIAL</code>: Initial health checks on the target are being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNUSED</code>: Target group is not used in a service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the target.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while
     *         current connections are being drained. The default draining time is 5 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>: The target is healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>: The target is unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INITIAL</code>: Initial health checks on the target are being performed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNUSED</code>: Target group is not used in a service.
     *         </p>
     *         </li>
     * @see TargetStatus
     */
    public final TargetStatus status() {
        return TargetStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the target.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while current
     * connections are being drained. The default draining time is 5 minutes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HEALTHY</code>: The target is healthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNHEALTHY</code>: The target is unhealthy.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INITIAL</code>: Initial health checks on the target are being performed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UNUSED</code>: Target group is not used in a service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the target.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while
     *         current connections are being drained. The default draining time is 5 minutes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>: The target is healthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNHEALTHY</code>: The target is unhealthy.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INITIAL</code>: Initial health checks on the target are being performed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UNUSED</code>: Target group is not used in a service.
     *         </p>
     *         </li>
     * @see TargetStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(reasonCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetSummary)) {
            return false;
        }
        TargetSummary other = (TargetSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(port(), other.port())
                && Objects.equals(reasonCode(), other.reasonCode()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetSummary").add("Id", id()).add("Port", port()).add("ReasonCode", reasonCode())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "reasonCode":
            return Optional.ofNullable(clazz.cast(reasonCode()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("port", PORT_FIELD);
        map.put("reasonCode", REASON_CODE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetSummary, T> g) {
        return obj -> g.apply((TargetSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetSummary> {
        /**
         * <p>
         * The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If the
         * target group type is <code>IP</code>, this is an IP address. If the target group type is <code>LAMBDA</code>,
         * this is the ARN of a Lambda function. If the target type is <code>ALB</code>, this is the ARN of an
         * Application Load Balancer.
         * </p>
         * 
         * @param id
         *        The ID of the target. If the target group type is <code>INSTANCE</code>, this is an instance ID. If
         *        the target group type is <code>IP</code>, this is an IP address. If the target group type is
         *        <code>LAMBDA</code>, this is the ARN of a Lambda function. If the target type is <code>ALB</code>,
         *        this is the ARN of an Application Load Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The port on which the target is listening.
         * </p>
         * 
         * @param port
         *        The port on which the target is listening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The code for why the target status is what it is.
         * </p>
         * 
         * @param reasonCode
         *        The code for why the target status is what it is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasonCode(String reasonCode);

        /**
         * <p>
         * The status of the target.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while
         * current connections are being drained. The default draining time is 5 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HEALTHY</code>: The target is healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>: The target is unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INITIAL</code>: Initial health checks on the target are being performed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNUSED</code>: Target group is not used in a service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the target.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target
         *        while current connections are being drained. The default draining time is 5 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>: The target is healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>: The target is unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INITIAL</code>: Initial health checks on the target are being performed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNUSED</code>: Target group is not used in a service.
         *        </p>
         *        </li>
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the target.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target while
         * current connections are being drained. The default draining time is 5 minutes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HEALTHY</code>: The target is healthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNHEALTHY</code>: The target is unhealthy.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INITIAL</code>: Initial health checks on the target are being performed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UNUSED</code>: Target group is not used in a service.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the target.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DRAINING</code>: The target is being deregistered. No new connections are sent to this target
         *        while current connections are being drained. The default draining time is 5 minutes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNAVAILABLE</code>: Health checks are unavailable for the target group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>: The target is healthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNHEALTHY</code>: The target is unhealthy.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INITIAL</code>: Initial health checks on the target are being performed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UNUSED</code>: Target group is not used in a service.
         *        </p>
         *        </li>
         * @see TargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStatus
         */
        Builder status(TargetStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Integer port;

        private String reasonCode;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetSummary model) {
            id(model.id);
            port(model.port);
            reasonCode(model.reasonCode);
            status(model.status);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getReasonCode() {
            return reasonCode;
        }

        public final void setReasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
        }

        @Override
        public final Builder reasonCode(String reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public TargetSummary build() {
            return new TargetSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
