/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationStatus;
import software.amazon.awssdk.services.vpclattice.model.ResourceConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceConfigurationSummary> {
    private static final SdkField<Boolean> AMAZON_MANAGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("amazonManaged").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::amazonManaged)).setter(ResourceConfigurationSummary.setter(Builder::amazonManaged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonManaged").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::arn)).setter(ResourceConfigurationSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::createdAt)).setter(ResourceConfigurationSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::id)).setter(ResourceConfigurationSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::lastUpdatedAt)).setter(ResourceConfigurationSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::name)).setter(ResourceConfigurationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceConfigurationGroupId").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::resourceConfigurationGroupId)).setter(ResourceConfigurationSummary.setter(Builder::resourceConfigurationGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId").build()}).build();
    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGatewayId").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::resourceGatewayId)).setter(ResourceConfigurationSummary.setter(Builder::resourceGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::statusAsString)).setter(ResourceConfigurationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ResourceConfigurationSummary.getter(ResourceConfigurationSummary::typeAsString)).setter(ResourceConfigurationSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_MANAGED_FIELD, ARN_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, RESOURCE_GATEWAY_ID_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean amazonManaged;
    private final String arn;
    private final Instant createdAt;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final String resourceConfigurationGroupId;
    private final String resourceGatewayId;
    private final String status;
    private final String type;

    private ResourceConfigurationSummary(BuilderImpl builder) {
        this.amazonManaged = builder.amazonManaged;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final Boolean amazonManaged() {
        return this.amazonManaged;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String resourceConfigurationGroupId() {
        return this.resourceConfigurationGroupId;
    }

    public final String resourceGatewayId() {
        return this.resourceGatewayId;
    }

    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonManaged());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigurationSummary)) {
            return false;
        }
        ResourceConfigurationSummary other = (ResourceConfigurationSummary)obj;
        return Objects.equals(this.amazonManaged(), other.amazonManaged()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.resourceConfigurationGroupId(), other.resourceConfigurationGroupId()) && Objects.equals(this.resourceGatewayId(), other.resourceGatewayId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceConfigurationSummary").add("AmazonManaged", (Object)this.amazonManaged()).add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)this.name()).add("ResourceConfigurationGroupId", (Object)this.resourceConfigurationGroupId()).add("ResourceGatewayId", (Object)this.resourceGatewayId()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "amazonManaged": {
                return Optional.ofNullable(clazz.cast(this.amazonManaged()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "resourceConfigurationGroupId": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationGroupId()));
            }
            case "resourceGatewayId": {
                return Optional.ofNullable(clazz.cast(this.resourceGatewayId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amazonManaged", AMAZON_MANAGED_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigurationSummary, T> g) {
        return obj -> g.apply((ResourceConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean amazonManaged;
        private String arn;
        private Instant createdAt;
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private String resourceConfigurationGroupId;
        private String resourceGatewayId;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigurationSummary model) {
            this.amazonManaged(model.amazonManaged);
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            this.resourceGatewayId(model.resourceGatewayId);
            this.status(model.status);
            this.type(model.type);
        }

        public final Boolean getAmazonManaged() {
            return this.amazonManaged;
        }

        public final void setAmazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
        }

        @Override
        public final Builder amazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return this.resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getResourceGatewayId() {
            return this.resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public ResourceConfigurationSummary build() {
            return new ResourceConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceConfigurationSummary> {
        public Builder amazonManaged(Boolean var1);

        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder resourceConfigurationGroupId(String var1);

        public Builder resourceGatewayId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceConfigurationStatus var1);

        public Builder type(String var1);

        public Builder type(ResourceConfigurationType var1);
    }
}

