/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.vpclattice.model.UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier;
import software.amazon.awssdk.services.vpclattice.model.VpcLatticeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServiceNetworkVpcAssociationRequest
extends VpcLatticeRequest
implements ToCopyableBuilder<Builder, UpdateServiceNetworkVpcAssociationRequest> {
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("securityGroupIds").getter(UpdateServiceNetworkVpcAssociationRequest.getter(UpdateServiceNetworkVpcAssociationRequest::securityGroupIds)).setter(UpdateServiceNetworkVpcAssociationRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_NETWORK_VPC_ASSOCIATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceNetworkVpcAssociationIdentifier").getter(UpdateServiceNetworkVpcAssociationRequest.getter(UpdateServiceNetworkVpcAssociationRequest::serviceNetworkVpcAssociationIdentifier)).setter(UpdateServiceNetworkVpcAssociationRequest.setter(Builder::serviceNetworkVpcAssociationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceNetworkVpcAssociationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_IDS_FIELD, SERVICE_NETWORK_VPC_ASSOCIATION_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServiceNetworkVpcAssociationRequest.memberNameToFieldInitializer();
    private final List<String> securityGroupIds;
    private final String serviceNetworkVpcAssociationIdentifier;

    private UpdateServiceNetworkVpcAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceNetworkVpcAssociationIdentifier = builder.serviceNetworkVpcAssociationIdentifier;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String serviceNetworkVpcAssociationIdentifier() {
        return this.serviceNetworkVpcAssociationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNetworkVpcAssociationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceNetworkVpcAssociationRequest)) {
            return false;
        }
        UpdateServiceNetworkVpcAssociationRequest other = (UpdateServiceNetworkVpcAssociationRequest)((Object)obj);
        return this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serviceNetworkVpcAssociationIdentifier(), other.serviceNetworkVpcAssociationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServiceNetworkVpcAssociationRequest").add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("ServiceNetworkVpcAssociationIdentifier", (Object)this.serviceNetworkVpcAssociationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "serviceNetworkVpcAssociationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.serviceNetworkVpcAssociationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("securityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("serviceNetworkVpcAssociationIdentifier", SERVICE_NETWORK_VPC_ASSOCIATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceNetworkVpcAssociationRequest, T> g) {
        return obj -> g.apply((UpdateServiceNetworkVpcAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VpcLatticeRequest.BuilderImpl
    implements Builder {
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceNetworkVpcAssociationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceNetworkVpcAssociationRequest model) {
            super(model);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceNetworkVpcAssociationIdentifier(model.serviceNetworkVpcAssociationIdentifier);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = UpdateServiceNetworkVpcAssociationRequestSecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getServiceNetworkVpcAssociationIdentifier() {
            return this.serviceNetworkVpcAssociationIdentifier;
        }

        public final void setServiceNetworkVpcAssociationIdentifier(String serviceNetworkVpcAssociationIdentifier) {
            this.serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier;
        }

        @Override
        public final Builder serviceNetworkVpcAssociationIdentifier(String serviceNetworkVpcAssociationIdentifier) {
            this.serviceNetworkVpcAssociationIdentifier = serviceNetworkVpcAssociationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceNetworkVpcAssociationRequest build() {
            return new UpdateServiceNetworkVpcAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends VpcLatticeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServiceNetworkVpcAssociationRequest> {
        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceNetworkVpcAssociationIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

