/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.vpclattice.model.FixedResponseAction;
import software.amazon.awssdk.services.vpclattice.model.ForwardAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleAction> {
    private static final SdkField<ForwardAction> FORWARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("forward").getter(RuleAction.getter(RuleAction::forward)).setter(RuleAction.setter(Builder::forward)).constructor(ForwardAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forward").build()}).build();
    private static final SdkField<FixedResponseAction> FIXED_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fixedResponse").getter(RuleAction.getter(RuleAction::fixedResponse)).setter(RuleAction.setter(Builder::fixedResponse)).constructor(FixedResponseAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORWARD_FIELD, FIXED_RESPONSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ForwardAction forward;
    private final FixedResponseAction fixedResponse;
    private final Type type;

    private RuleAction(BuilderImpl builder) {
        this.forward = builder.forward;
        this.fixedResponse = builder.fixedResponse;
        this.type = builder.type;
    }

    public final ForwardAction forward() {
        return this.forward;
    }

    public final FixedResponseAction fixedResponse() {
        return this.fixedResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forward());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedResponse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleAction)) {
            return false;
        }
        RuleAction other = (RuleAction)obj;
        return Objects.equals(this.forward(), other.forward()) && Objects.equals(this.fixedResponse(), other.fixedResponse());
    }

    public final String toString() {
        return ToString.builder((String)"RuleAction").add("Forward", (Object)this.forward()).add("FixedResponse", (Object)this.fixedResponse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "forward": {
                return Optional.ofNullable(clazz.cast(this.forward()));
            }
            case "fixedResponse": {
                return Optional.ofNullable(clazz.cast(this.fixedResponse()));
            }
        }
        return Optional.empty();
    }

    public static RuleAction fromForward(ForwardAction forward) {
        return (RuleAction)RuleAction.builder().forward(forward).build();
    }

    public static RuleAction fromForward(Consumer<ForwardAction.Builder> forward) {
        ForwardAction.Builder builder = ForwardAction.builder();
        forward.accept(builder);
        return RuleAction.fromForward((ForwardAction)builder.build());
    }

    public static RuleAction fromFixedResponse(FixedResponseAction fixedResponse) {
        return (RuleAction)RuleAction.builder().fixedResponse(fixedResponse).build();
    }

    public static RuleAction fromFixedResponse(Consumer<FixedResponseAction.Builder> fixedResponse) {
        FixedResponseAction.Builder builder = FixedResponseAction.builder();
        fixedResponse.accept(builder);
        return RuleAction.fromFixedResponse((FixedResponseAction)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("forward", FORWARD_FIELD);
        map.put("fixedResponse", FIXED_RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleAction, T> g) {
        return obj -> g.apply((RuleAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        FORWARD,
        FIXED_RESPONSE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ForwardAction forward;
        private FixedResponseAction fixedResponse;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleAction model) {
            this.forward(model.forward);
            this.fixedResponse(model.fixedResponse);
        }

        public final ForwardAction.Builder getForward() {
            return this.forward != null ? this.forward.toBuilder() : null;
        }

        public final void setForward(ForwardAction.BuilderImpl forward) {
            ForwardAction oldValue = this.forward;
            this.forward = forward != null ? forward.build() : null;
            this.handleUnionValueChange(Type.FORWARD, oldValue, this.forward);
        }

        @Override
        public final Builder forward(ForwardAction forward) {
            ForwardAction oldValue = this.forward;
            this.forward = forward;
            this.handleUnionValueChange(Type.FORWARD, oldValue, this.forward);
            return this;
        }

        public final FixedResponseAction.Builder getFixedResponse() {
            return this.fixedResponse != null ? this.fixedResponse.toBuilder() : null;
        }

        public final void setFixedResponse(FixedResponseAction.BuilderImpl fixedResponse) {
            FixedResponseAction oldValue = this.fixedResponse;
            this.fixedResponse = fixedResponse != null ? fixedResponse.build() : null;
            this.handleUnionValueChange(Type.FIXED_RESPONSE, oldValue, this.fixedResponse);
        }

        @Override
        public final Builder fixedResponse(FixedResponseAction fixedResponse) {
            FixedResponseAction oldValue = this.fixedResponse;
            this.fixedResponse = fixedResponse;
            this.handleUnionValueChange(Type.FIXED_RESPONSE, oldValue, this.fixedResponse);
            return this;
        }

        public RuleAction build() {
            return new RuleAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleAction> {
        public Builder forward(ForwardAction var1);

        default public Builder forward(Consumer<ForwardAction.Builder> forward) {
            return this.forward((ForwardAction)((ForwardAction.Builder)ForwardAction.builder().applyMutation(forward)).build());
        }

        public Builder fixedResponse(FixedResponseAction var1);

        default public Builder fixedResponse(Consumer<FixedResponseAction.Builder> fixedResponse) {
            return this.fixedResponse((FixedResponseAction)((FixedResponseAction.Builder)FixedResponseAction.builder().applyMutation(fixedResponse)).build());
        }
    }
}

