/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateResourceConfigurationRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<CreateResourceConfigurationRequest.Builder, CreateResourceConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateResourceConfigurationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateResourceConfigurationRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("portRanges")
            .getter(getter(CreateResourceConfigurationRequest::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(CreateResourceConfigurationRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayIdentifier")
            .getter(getter(CreateResourceConfigurationRequest::resourceGatewayIdentifier))
            .setter(setter(Builder::resourceGatewayIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupIdentifier")
            .getter(getter(CreateResourceConfigurationRequest::resourceConfigurationGroupIdentifier))
            .setter(setter(Builder::resourceConfigurationGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("resourceConfigurationGroupIdentifier").build()).build();

    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<ResourceConfigurationDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("resourceConfigurationDefinition")
            .getter(getter(CreateResourceConfigurationRequest::resourceConfigurationDefinition))
            .setter(setter(Builder::resourceConfigurationDefinition))
            .constructor(ResourceConfigurationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition")
                    .build()).build();

    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAssociationToShareableServiceNetwork")
            .getter(getter(CreateResourceConfigurationRequest::allowAssociationToShareableServiceNetwork))
            .setter(setter(Builder::allowAssociationToShareableServiceNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowAssociationToShareableServiceNetwork").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(CreateResourceConfigurationRequest::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> GROUP_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupDomain").getter(getter(CreateResourceConfigurationRequest::groupDomain))
            .setter(setter(Builder::groupDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDomain").build()).build();

    private static final SdkField<String> DOMAIN_VERIFICATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("domainVerificationIdentifier")
            .getter(getter(CreateResourceConfigurationRequest::domainVerificationIdentifier))
            .setter(setter(Builder::domainVerificationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationIdentifier")
                    .build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateResourceConfigurationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateResourceConfigurationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            PORT_RANGES_FIELD, PROTOCOL_FIELD, RESOURCE_GATEWAY_IDENTIFIER_FIELD, RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD,
            RESOURCE_CONFIGURATION_DEFINITION_FIELD, ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD,
            CUSTOM_DOMAIN_NAME_FIELD, GROUP_DOMAIN_FIELD, DOMAIN_VERIFICATION_IDENTIFIER_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String type;

    private final List<String> portRanges;

    private final String protocol;

    private final String resourceGatewayIdentifier;

    private final String resourceConfigurationGroupIdentifier;

    private final ResourceConfigurationDefinition resourceConfigurationDefinition;

    private final Boolean allowAssociationToShareableServiceNetwork;

    private final String customDomainName;

    private final String groupDomain;

    private final String domainVerificationIdentifier;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateResourceConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.portRanges = builder.portRanges;
        this.protocol = builder.protocol;
        this.resourceGatewayIdentifier = builder.resourceGatewayIdentifier;
        this.resourceConfigurationGroupIdentifier = builder.resourceConfigurationGroupIdentifier;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.customDomainName = builder.customDomainName;
        this.groupDomain = builder.groupDomain;
        this.domainVerificationIdentifier = builder.domainVerificationIdentifier;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the resource configuration. The name must be unique within the account. The valid characters are a-z,
     * 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after another hyphen.
     * </p>
     * 
     * @return The name of the resource configuration. The name must be unique within the account. The valid characters
     *         are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately
     *         after another hyphen.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of resource configuration. A resource configuration can be one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SINGLE</b> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a child
     * resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CHILD</b> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ARN</b> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration. A resource configuration can be one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SINGLE</b> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a
     *         child resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CHILD</b> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ARN</b> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource configuration. A resource configuration can be one of the following types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>SINGLE</b> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a child
     * resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CHILD</b> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>ARN</b> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration. A resource configuration can be one of the following types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>SINGLE</b> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a
     *         child resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CHILD</b> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>ARN</b> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for
     * example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration
     *         (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
     */
    public final List<String> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return (SINGLE, GROUP) The protocol accepted by the resource configuration.
     * @see ProtocolType
     */
    public final ProtocolType protocol() {
        return ProtocolType.fromValue(protocol);
    }

    /**
     * <p>
     * (SINGLE, GROUP) The protocol accepted by the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return (SINGLE, GROUP) The protocol accepted by the resource configuration.
     * @see ProtocolType
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource configuration. For a
     * child resource configuration, this value is inherited from the parent resource configuration.
     * </p>
     * 
     * @return (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource configuration.
     *         For a child resource configuration, this value is inherited from the parent resource configuration.
     */
    public final String resourceGatewayIdentifier() {
        return resourceGatewayIdentifier;
    }

    /**
     * <p>
     * (CHILD) The ID or ARN of the parent resource configuration of type <code>GROUP</code>. This is used to associate
     * a child resource configuration with a group resource configuration.
     * </p>
     * 
     * @return (CHILD) The ID or ARN of the parent resource configuration of type <code>GROUP</code>. This is used to
     *         associate a child resource configuration with a group resource configuration.
     */
    public final String resourceConfigurationGroupIdentifier() {
        return resourceConfigurationGroupIdentifier;
    }

    /**
     * <p>
     * Identifies the resource configuration in one of the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Amazon Resource Name (ARN)</b> - Supported resource-types that are provisioned by Amazon Web Services
     * services, such as RDS databases, can be identified by their ARN.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Domain name</b> - Any domain name that is publicly resolvable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IP address</b> - For IPv4 and IPv6, only IP addresses in the VPC are supported.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Identifies the resource configuration in one of the following ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Amazon Resource Name (ARN)</b> - Supported resource-types that are provisioned by Amazon Web Services
     *         services, such as RDS databases, can be identified by their ARN.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Domain name</b> - Any domain name that is publicly resolvable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IP address</b> - For IPv4 and IPv6, only IP addresses in the VPC are supported.
     *         </p>
     *         </li>
     */
    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return resourceConfigurationDefinition;
    }

    /**
     * <p>
     * (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable service
     * network. The default is false.
     * </p>
     * 
     * @return (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable
     *         service network. The default is false.
     */
    public final Boolean allowAssociationToShareableServiceNetwork() {
        return allowAssociationToShareableServiceNetwork;
    }

    /**
     * <p>
     * A custom domain name for your resource configuration. Additionally, provide a DomainVerificationID to prove your
     * ownership of a domain.
     * </p>
     * 
     * @return A custom domain name for your resource configuration. Additionally, provide a DomainVerificationID to
     *         prove your ownership of a domain.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child resource
     * are subdomains of the group domain. Child resources inherit the verification status of the domain.
     * </p>
     * 
     * @return (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
     *         resource are subdomains of the group domain. Child resources inherit the verification status of the
     *         domain.
     */
    public final String groupDomain() {
        return groupDomain;
    }

    /**
     * <p>
     * The domain verification ID of your verified custom domain name. If you don't provide an ID, you must configure
     * the DNS settings yourself.
     * </p>
     * 
     * @return The domain verification ID of your verified custom domain name. If you don't provide an ID, you must
     *         configure the DNS settings yourself.
     */
    public final String domainVerificationIdentifier() {
        return domainVerificationIdentifier;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
     * request that completed successfully using the same client token and parameters, the retry succeeds without
     * performing any actions. If the parameters aren't identical, the retry fails.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
     *         retry a request that completed successfully using the same client token and parameters, the retry
     *         succeeds without performing any actions. If the parameters aren't identical, the retry fails.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags for the resource configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags for the resource configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(groupDomain());
        hashCode = 31 * hashCode + Objects.hashCode(domainVerificationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceConfigurationRequest)) {
            return false;
        }
        CreateResourceConfigurationRequest other = (CreateResourceConfigurationRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && hasPortRanges() == other.hasPortRanges() && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(resourceGatewayIdentifier(), other.resourceGatewayIdentifier())
                && Objects.equals(resourceConfigurationGroupIdentifier(), other.resourceConfigurationGroupIdentifier())
                && Objects.equals(resourceConfigurationDefinition(), other.resourceConfigurationDefinition())
                && Objects.equals(allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(groupDomain(), other.groupDomain())
                && Objects.equals(domainVerificationIdentifier(), other.domainVerificationIdentifier())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateResourceConfigurationRequest").add("Name", name()).add("Type", typeAsString())
                .add("PortRanges", hasPortRanges() ? portRanges() : null).add("Protocol", protocolAsString())
                .add("ResourceGatewayIdentifier", resourceGatewayIdentifier())
                .add("ResourceConfigurationGroupIdentifier", resourceConfigurationGroupIdentifier())
                .add("ResourceConfigurationDefinition", resourceConfigurationDefinition())
                .add("AllowAssociationToShareableServiceNetwork", allowAssociationToShareableServiceNetwork())
                .add("CustomDomainName", customDomainName()).add("GroupDomain", groupDomain())
                .add("DomainVerificationIdentifier", domainVerificationIdentifier()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "portRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "resourceGatewayIdentifier":
            return Optional.ofNullable(clazz.cast(resourceGatewayIdentifier()));
        case "resourceConfigurationGroupIdentifier":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupIdentifier()));
        case "resourceConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(resourceConfigurationDefinition()));
        case "allowAssociationToShareableServiceNetwork":
            return Optional.ofNullable(clazz.cast(allowAssociationToShareableServiceNetwork()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "groupDomain":
            return Optional.ofNullable(clazz.cast(groupDomain()));
        case "domainVerificationIdentifier":
            return Optional.ofNullable(clazz.cast(domainVerificationIdentifier()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("resourceGatewayIdentifier", RESOURCE_GATEWAY_IDENTIFIER_FIELD);
        map.put("resourceConfigurationGroupIdentifier", RESOURCE_CONFIGURATION_GROUP_IDENTIFIER_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("groupDomain", GROUP_DOMAIN_FIELD);
        map.put("domainVerificationIdentifier", DOMAIN_VERIFICATION_IDENTIFIER_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceConfigurationRequest, T> g) {
        return obj -> g.apply((CreateResourceConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateResourceConfigurationRequest> {
        /**
         * <p>
         * The name of the resource configuration. The name must be unique within the account. The valid characters are
         * a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or immediately after
         * another hyphen.
         * </p>
         * 
         * @param name
         *        The name of the resource configuration. The name must be unique within the account. The valid
         *        characters are a-z, 0-9, and hyphens (-). You can't use a hyphen as the first or last character, or
         *        immediately after another hyphen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of resource configuration. A resource configuration can be one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SINGLE</b> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a child
         * resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CHILD</b> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ARN</b> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration. A resource configuration can be one of the following types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SINGLE</b> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create
         *        a child resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CHILD</b> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ARN</b> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource configuration. A resource configuration can be one of the following types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>SINGLE</b> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create a child
         * resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CHILD</b> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>ARN</b> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration. A resource configuration can be one of the following types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>SINGLE</b> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>GROUP</b> - A group of resources. You must create a group resource configuration before you create
         *        a child resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CHILD</b> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>ARN</b> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(ResourceConfigurationType type);

        /**
         * <p>
         * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for
         * example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
         * </p>
         * 
         * @param portRanges
         *        (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration
         *        (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<String> portRanges);

        /**
         * <p>
         * (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for
         * example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
         * </p>
         * 
         * @param portRanges
         *        (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration
         *        (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(String... portRanges);

        /**
         * <p>
         * (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * </p>
         * 
         * @param protocol
         *        (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * </p>
         * 
         * @param protocol
         *        (SINGLE, GROUP) The protocol accepted by the resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(ProtocolType protocol);

        /**
         * <p>
         * (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource configuration. For
         * a child resource configuration, this value is inherited from the parent resource configuration.
         * </p>
         * 
         * @param resourceGatewayIdentifier
         *        (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to the resource
         *        configuration. For a child resource configuration, this value is inherited from the parent resource
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayIdentifier(String resourceGatewayIdentifier);

        /**
         * <p>
         * (CHILD) The ID or ARN of the parent resource configuration of type <code>GROUP</code>. This is used to
         * associate a child resource configuration with a group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupIdentifier
         *        (CHILD) The ID or ARN of the parent resource configuration of type <code>GROUP</code>. This is used to
         *        associate a child resource configuration with a group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier);

        /**
         * <p>
         * Identifies the resource configuration in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Resource Name (ARN)</b> - Supported resource-types that are provisioned by Amazon Web Services
         * services, such as RDS databases, can be identified by their ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Domain name</b> - Any domain name that is publicly resolvable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IP address</b> - For IPv4 and IPv6, only IP addresses in the VPC are supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceConfigurationDefinition
         *        Identifies the resource configuration in one of the following ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Amazon Resource Name (ARN)</b> - Supported resource-types that are provisioned by Amazon Web
         *        Services services, such as RDS databases, can be identified by their ARN.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Domain name</b> - Any domain name that is publicly resolvable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IP address</b> - For IPv4 and IPv6, only IP addresses in the VPC are supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition);

        /**
         * <p>
         * Identifies the resource configuration in one of the following ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Amazon Resource Name (ARN)</b> - Supported resource-types that are provisioned by Amazon Web Services
         * services, such as RDS databases, can be identified by their ARN.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Domain name</b> - Any domain name that is publicly resolvable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IP address</b> - For IPv4 and IPv6, only IP addresses in the VPC are supported.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link ResourceConfigurationDefinition.Builder}
         * avoiding the need to create one manually via {@link ResourceConfigurationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfigurationDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourceConfigurationDefinition(ResourceConfigurationDefinition)}.
         * 
         * @param resourceConfigurationDefinition
         *        a consumer that will call methods on {@link ResourceConfigurationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfigurationDefinition(ResourceConfigurationDefinition)
         */
        default Builder resourceConfigurationDefinition(
                Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return resourceConfigurationDefinition(ResourceConfigurationDefinition.builder()
                    .applyMutation(resourceConfigurationDefinition).build());
        }

        /**
         * <p>
         * (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable service
         * network. The default is false.
         * </p>
         * 
         * @param allowAssociationToShareableServiceNetwork
         *        (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be associated with a sharable
         *        service network. The default is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork);

        /**
         * <p>
         * A custom domain name for your resource configuration. Additionally, provide a DomainVerificationID to prove
         * your ownership of a domain.
         * </p>
         * 
         * @param customDomainName
         *        A custom domain name for your resource configuration. Additionally, provide a DomainVerificationID to
         *        prove your ownership of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         * resource are subdomains of the group domain. Child resources inherit the verification status of the domain.
         * </p>
         * 
         * @param groupDomain
         *        (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         *        resource are subdomains of the group domain. Child resources inherit the verification status of the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDomain(String groupDomain);

        /**
         * <p>
         * The domain verification ID of your verified custom domain name. If you don't provide an ID, you must
         * configure the DNS settings yourself.
         * </p>
         * 
         * @param domainVerificationIdentifier
         *        The domain verification ID of your verified custom domain name. If you don't provide an ID, you must
         *        configure the DNS settings yourself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainVerificationIdentifier(String domainVerificationIdentifier);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you retry a
         * request that completed successfully using the same client token and parameters, the retry succeeds without
         * performing any actions. If the parameters aren't identical, the retry fails.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If you
         *        retry a request that completed successfully using the same client token and parameters, the retry
         *        succeeds without performing any actions. If the parameters aren't identical, the retry fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The tags for the resource configuration.
         * </p>
         * 
         * @param tags
         *        The tags for the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String name;

        private String type;

        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();

        private String protocol;

        private String resourceGatewayIdentifier;

        private String resourceConfigurationGroupIdentifier;

        private ResourceConfigurationDefinition resourceConfigurationDefinition;

        private Boolean allowAssociationToShareableServiceNetwork;

        private String customDomainName;

        private String groupDomain;

        private String domainVerificationIdentifier;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceConfigurationRequest model) {
            super(model);
            name(model.name);
            type(model.type);
            portRanges(model.portRanges);
            protocol(model.protocol);
            resourceGatewayIdentifier(model.resourceGatewayIdentifier);
            resourceConfigurationGroupIdentifier(model.resourceConfigurationGroupIdentifier);
            resourceConfigurationDefinition(model.resourceConfigurationDefinition);
            allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            customDomainName(model.customDomainName);
            groupDomain(model.groupDomain);
            domainVerificationIdentifier(model.domainVerificationIdentifier);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getResourceGatewayIdentifier() {
            return resourceGatewayIdentifier;
        }

        public final void setResourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
        }

        @Override
        public final Builder resourceGatewayIdentifier(String resourceGatewayIdentifier) {
            this.resourceGatewayIdentifier = resourceGatewayIdentifier;
            return this;
        }

        public final String getResourceConfigurationGroupIdentifier() {
            return resourceConfigurationGroupIdentifier;
        }

        public final void setResourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
        }

        @Override
        public final Builder resourceConfigurationGroupIdentifier(String resourceConfigurationGroupIdentifier) {
            this.resourceConfigurationGroupIdentifier = resourceConfigurationGroupIdentifier;
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return resourceConfigurationDefinition != null ? resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(
                ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition
                    .build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getGroupDomain() {
            return groupDomain;
        }

        public final void setGroupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
        }

        @Override
        public final Builder groupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
            return this;
        }

        public final String getDomainVerificationIdentifier() {
            return domainVerificationIdentifier;
        }

        public final void setDomainVerificationIdentifier(String domainVerificationIdentifier) {
            this.domainVerificationIdentifier = domainVerificationIdentifier;
        }

        @Override
        public final Builder domainVerificationIdentifier(String domainVerificationIdentifier) {
            this.domainVerificationIdentifier = domainVerificationIdentifier;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceConfigurationRequest build() {
            return new CreateResourceConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
