/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceNetworkResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<CreateServiceNetworkResponse.Builder, CreateServiceNetworkResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateServiceNetworkResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateServiceNetworkResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateServiceNetworkResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<SharingConfig> SHARING_CONFIG_FIELD = SdkField
            .<SharingConfig> builder(MarshallingType.SDK_POJO).memberName("sharingConfig")
            .getter(getter(CreateServiceNetworkResponse::sharingConfig)).setter(setter(Builder::sharingConfig))
            .constructor(SharingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfig").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(CreateServiceNetworkResponse::authTypeAsString))
            .setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, SHARING_CONFIG_FIELD, AUTH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final SharingConfig sharingConfig;

    private final String authType;

    private CreateServiceNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.sharingConfig = builder.sharingConfig;
        this.authType = builder.authType;
    }

    /**
     * <p>
     * The ID of the service network.
     * </p>
     * 
     * @return The ID of the service network.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the service network.
     * </p>
     * 
     * @return The name of the service network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies if the service network is enabled for sharing.
     * </p>
     * 
     * @return Specifies if the service network is enabled for sharing.
     */
    public final SharingConfig sharingConfig() {
        return sharingConfig;
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sharingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkResponse)) {
            return false;
        }
        CreateServiceNetworkResponse other = (CreateServiceNetworkResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(sharingConfig(), other.sharingConfig())
                && Objects.equals(authTypeAsString(), other.authTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceNetworkResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("SharingConfig", sharingConfig()).add("AuthType", authTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "sharingConfig":
            return Optional.ofNullable(clazz.cast(sharingConfig()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("sharingConfig", SHARING_CONFIG_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkResponse, T> g) {
        return obj -> g.apply((CreateServiceNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceNetworkResponse> {
        /**
         * <p>
         * The ID of the service network.
         * </p>
         * 
         * @param id
         *        The ID of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the service network.
         * </p>
         * 
         * @param name
         *        The name of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies if the service network is enabled for sharing.
         * </p>
         * 
         * @param sharingConfig
         *        Specifies if the service network is enabled for sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharingConfig(SharingConfig sharingConfig);

        /**
         * <p>
         * Specifies if the service network is enabled for sharing.
         * </p>
         * This is a convenience method that creates an instance of the {@link SharingConfig.Builder} avoiding the need
         * to create one manually via {@link SharingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SharingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sharingConfig(SharingConfig)}.
         * 
         * @param sharingConfig
         *        a consumer that will call methods on {@link SharingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharingConfig(SharingConfig)
         */
        default Builder sharingConfig(Consumer<SharingConfig.Builder> sharingConfig) {
            return sharingConfig(SharingConfig.builder().applyMutation(sharingConfig).build());
        }

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * 
         * @param authType
         *        The type of IAM policy.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * 
         * @param authType
         *        The type of IAM policy.
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private SharingConfig sharingConfig;

        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            sharingConfig(model.sharingConfig);
            authType(model.authType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final SharingConfig.Builder getSharingConfig() {
            return sharingConfig != null ? sharingConfig.toBuilder() : null;
        }

        public final void setSharingConfig(SharingConfig.BuilderImpl sharingConfig) {
            this.sharingConfig = sharingConfig != null ? sharingConfig.build() : null;
        }

        @Override
        public final Builder sharingConfig(SharingConfig sharingConfig) {
            this.sharingConfig = sharingConfig;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        @Override
        public CreateServiceNetworkResponse build() {
            return new CreateServiceNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
