/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceNetworkServiceAssociationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<CreateServiceNetworkServiceAssociationResponse.Builder, CreateServiceNetworkServiceAssociationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateServiceNetworkServiceAssociationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateServiceNetworkServiceAssociationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateServiceNetworkServiceAssociationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(CreateServiceNetworkServiceAssociationResponse::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(CreateServiceNetworkServiceAssociationResponse::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("dnsEntry").getter(getter(CreateServiceNetworkServiceAssociationResponse::dnsEntry))
            .setter(setter(Builder::dnsEntry)).constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            ARN_FIELD, CREATED_BY_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DNS_ENTRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String status;

    private final String arn;

    private final String createdBy;

    private final String customDomainName;

    private final DnsEntry dnsEntry;

    private CreateServiceNetworkServiceAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.customDomainName = builder.customDomainName;
        this.dnsEntry = builder.dnsEntry;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The association status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkServiceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The association status.
     * @see ServiceNetworkServiceAssociationStatus
     */
    public final ServiceNetworkServiceAssociationStatus status() {
        return ServiceNetworkServiceAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The association status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkServiceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The association status.
     * @see ServiceNetworkServiceAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The account that created the association.
     * </p>
     * 
     * @return The account that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The custom domain name of the service.
     * </p>
     * 
     * @return The custom domain name of the service.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The DNS name of the service.
     * </p>
     * 
     * @return The DNS name of the service.
     */
    public final DnsEntry dnsEntry() {
        return dnsEntry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(dnsEntry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceNetworkServiceAssociationResponse)) {
            return false;
        }
        CreateServiceNetworkServiceAssociationResponse other = (CreateServiceNetworkServiceAssociationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(customDomainName(), other.customDomainName()) && Objects.equals(dnsEntry(), other.dnsEntry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceNetworkServiceAssociationResponse").add("Id", id()).add("Status", statusAsString())
                .add("Arn", arn()).add("CreatedBy", createdBy()).add("CustomDomainName", customDomainName())
                .add("DnsEntry", dnsEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "dnsEntry":
            return Optional.ofNullable(clazz.cast(dnsEntry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceNetworkServiceAssociationResponse, T> g) {
        return obj -> g.apply((CreateServiceNetworkServiceAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateServiceNetworkServiceAssociationResponse> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The association status.
         * </p>
         * 
         * @param status
         *        The association status.
         * @see ServiceNetworkServiceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkServiceAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The association status.
         * </p>
         * 
         * @param status
         *        The association status.
         * @see ServiceNetworkServiceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkServiceAssociationStatus
         */
        Builder status(ServiceNetworkServiceAssociationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The account that created the association.
         * </p>
         * 
         * @param createdBy
         *        The account that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The custom domain name of the service.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The DNS name of the service.
         * </p>
         * 
         * @param dnsEntry
         *        The DNS name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntry(DnsEntry dnsEntry);

        /**
         * <p>
         * The DNS name of the service.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #dnsEntry(DnsEntry)}.
         * 
         * @param dnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsEntry(DnsEntry)
         */
        default Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return dnsEntry(DnsEntry.builder().applyMutation(dnsEntry).build());
        }
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String status;

        private String arn;

        private String createdBy;

        private String customDomainName;

        private DnsEntry dnsEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceNetworkServiceAssociationResponse model) {
            super(model);
            id(model.id);
            status(model.status);
            arn(model.arn);
            createdBy(model.createdBy);
            customDomainName(model.customDomainName);
            dnsEntry(model.dnsEntry);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkServiceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return dnsEntry != null ? dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        @Override
        public CreateServiceNetworkServiceAssociationResponse build() {
            return new CreateServiceNetworkServiceAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
