/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The DNS configuration options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DnsOptions implements SdkPojo, Serializable, ToCopyableBuilder<DnsOptions.Builder, DnsOptions> {
    private static final SdkField<String> PRIVATE_DNS_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateDnsPreference").getter(getter(DnsOptions::privateDnsPreferenceAsString))
            .setter(setter(Builder::privateDnsPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsPreference").build())
            .build();

    private static final SdkField<List<String>> PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("privateDnsSpecifiedDomains")
            .getter(getter(DnsOptions::privateDnsSpecifiedDomains))
            .setter(setter(Builder::privateDnsSpecifiedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateDnsSpecifiedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_DNS_PREFERENCE_FIELD,
            PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String privateDnsPreference;

    private final List<String> privateDnsSpecifiedDomains;

    private DnsOptions(BuilderImpl builder) {
        this.privateDnsPreference = builder.privateDnsPreference;
        this.privateDnsSpecifiedDomains = builder.privateDnsSpecifiedDomains;
    }

    /**
     * <p>
     * The preference for which private domains have a private hosted zone created for and associated with the specified
     * VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or Resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name has
     * been verified by the provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     * verified custom domain names and other domain names that the resource consumer specifies. The resource consumer
     * specifies the domain names in the privateDnsSpecifiedDomains parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified by
     * the resource consumer. The resource consumer specifies the domain names in the privateDnsSpecifiedDomains
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsPreference} will return {@link PrivateDnsPreference#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsPreferenceAsString}.
     * </p>
     * 
     * @return The preference for which private domains have a private hosted zone created for and associated with the
     *         specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
     *         ServiceNetwork or Resource. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain
     *         name has been verified by the provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     *         verified custom domain names and other domain names that the resource consumer specifies. The resource
     *         consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
     *         specified by the resource consumer. The resource consumer specifies the domain names in the
     *         privateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     * @see PrivateDnsPreference
     */
    public final PrivateDnsPreference privateDnsPreference() {
        return PrivateDnsPreference.fromValue(privateDnsPreference);
    }

    /**
     * <p>
     * The preference for which private domains have a private hosted zone created for and associated with the specified
     * VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or Resource.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name has
     * been verified by the provider.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     * verified custom domain names and other domain names that the resource consumer specifies. The resource consumer
     * specifies the domain names in the privateDnsSpecifiedDomains parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified by
     * the resource consumer. The resource consumer specifies the domain names in the privateDnsSpecifiedDomains
     * parameter.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #privateDnsPreference} will return {@link PrivateDnsPreference#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #privateDnsPreferenceAsString}.
     * </p>
     * 
     * @return The preference for which private domains have a private hosted zone created for and associated with the
     *         specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
     *         ServiceNetwork or Resource. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain
     *         name has been verified by the provider.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
     *         verified custom domain names and other domain names that the resource consumer specifies. The resource
     *         consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
     *         specified by the resource consumer. The resource consumer specifies the domain names in the
     *         privateDnsSpecifiedDomains parameter.
     *         </p>
     *         </li>
     * @see PrivateDnsPreference
     */
    public final String privateDnsPreferenceAsString() {
        return privateDnsPreference;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateDnsSpecifiedDomains property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrivateDnsSpecifiedDomains() {
        return privateDnsSpecifiedDomains != null && !(privateDnsSpecifiedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates which of the private domains to create private hosted zones for and associate with the specified VPC.
     * Only supported when private DNS is enabled and the private DNS preference is
     * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateDnsSpecifiedDomains} method.
     * </p>
     * 
     * @return Indicates which of the private domains to create private hosted zones for and associate with the
     *         specified VPC. Only supported when private DNS is enabled and the private DNS preference is
     *         <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
     */
    public final List<String> privateDnsSpecifiedDomains() {
        return privateDnsSpecifiedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateDnsSpecifiedDomains() ? privateDnsSpecifiedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsOptions)) {
            return false;
        }
        DnsOptions other = (DnsOptions) obj;
        return Objects.equals(privateDnsPreferenceAsString(), other.privateDnsPreferenceAsString())
                && hasPrivateDnsSpecifiedDomains() == other.hasPrivateDnsSpecifiedDomains()
                && Objects.equals(privateDnsSpecifiedDomains(), other.privateDnsSpecifiedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DnsOptions").add("PrivateDnsPreference", privateDnsPreferenceAsString())
                .add("PrivateDnsSpecifiedDomains", hasPrivateDnsSpecifiedDomains() ? privateDnsSpecifiedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "privateDnsPreference":
            return Optional.ofNullable(clazz.cast(privateDnsPreferenceAsString()));
        case "privateDnsSpecifiedDomains":
            return Optional.ofNullable(clazz.cast(privateDnsSpecifiedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("privateDnsPreference", PRIVATE_DNS_PREFERENCE_FIELD);
        map.put("privateDnsSpecifiedDomains", PRIVATE_DNS_SPECIFIED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsOptions, T> g) {
        return obj -> g.apply((DnsOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DnsOptions> {
        /**
         * <p>
         * The preference for which private domains have a private hosted zone created for and associated with the
         * specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or
         * Resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name
         * has been verified by the provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
         * verified custom domain names and other domain names that the resource consumer specifies. The resource
         * consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified
         * by the resource consumer. The resource consumer specifies the domain names in the privateDnsSpecifiedDomains
         * parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param privateDnsPreference
         *        The preference for which private domains have a private hosted zone created for and associated with
         *        the specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
         *        ServiceNetwork or Resource. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom
         *        domain name has been verified by the provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for
         *        all verified custom domain names and other domain names that the resource consumer specifies. The
         *        resource consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
         *        specified by the resource consumer. The resource consumer specifies the domain names in the
         *        privateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         * @see PrivateDnsPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateDnsPreference
         */
        Builder privateDnsPreference(String privateDnsPreference);

        /**
         * <p>
         * The preference for which private domains have a private hosted zone created for and associated with the
         * specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is ServiceNetwork or
         * Resource.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom domain name
         * has been verified by the provider.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for all
         * verified custom domain names and other domain names that the resource consumer specifies. The resource
         * consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names specified
         * by the resource consumer. The resource consumer specifies the domain names in the privateDnsSpecifiedDomains
         * parameter.
         * </p>
         * </li>
         * </ul>
         * 
         * @param privateDnsPreference
         *        The preference for which private domains have a private hosted zone created for and associated with
         *        the specified VPC. Only supported when private DNS is enabled and when the VPC endpoint type is
         *        ServiceNetwork or Resource. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_DOMAINS</code> - VPC Lattice provisions private hosted zones for all custom domain names.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone only if custom
         *        domain name has been verified by the provider.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> - VPC Lattice provisions private hosted zones for
         *        all verified custom domain names and other domain names that the resource consumer specifies. The
         *        resource consumer specifies the domain names in the privateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SPECIFIED_DOMAINS_ONLY</code> - VPC Lattice provisions a private hosted zone for domain names
         *        specified by the resource consumer. The resource consumer specifies the domain names in the
         *        privateDnsSpecifiedDomains parameter.
         *        </p>
         *        </li>
         * @see PrivateDnsPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrivateDnsPreference
         */
        Builder privateDnsPreference(PrivateDnsPreference privateDnsPreference);

        /**
         * <p>
         * Indicates which of the private domains to create private hosted zones for and associate with the specified
         * VPC. Only supported when private DNS is enabled and the private DNS preference is
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * </p>
         * 
         * @param privateDnsSpecifiedDomains
         *        Indicates which of the private domains to create private hosted zones for and associate with the
         *        specified VPC. Only supported when private DNS is enabled and the private DNS preference is
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains);

        /**
         * <p>
         * Indicates which of the private domains to create private hosted zones for and associate with the specified
         * VPC. Only supported when private DNS is enabled and the private DNS preference is
         * <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * </p>
         * 
         * @param privateDnsSpecifiedDomains
         *        Indicates which of the private domains to create private hosted zones for and associate with the
         *        specified VPC. Only supported when private DNS is enabled and the private DNS preference is
         *        <code>VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS</code> or <code>SPECIFIED_DOMAINS_ONLY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsSpecifiedDomains(String... privateDnsSpecifiedDomains);
    }

    static final class BuilderImpl implements Builder {
        private String privateDnsPreference;

        private List<String> privateDnsSpecifiedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DnsOptions model) {
            privateDnsPreference(model.privateDnsPreference);
            privateDnsSpecifiedDomains(model.privateDnsSpecifiedDomains);
        }

        public final String getPrivateDnsPreference() {
            return privateDnsPreference;
        }

        public final void setPrivateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
        }

        @Override
        public final Builder privateDnsPreference(String privateDnsPreference) {
            this.privateDnsPreference = privateDnsPreference;
            return this;
        }

        @Override
        public final Builder privateDnsPreference(PrivateDnsPreference privateDnsPreference) {
            this.privateDnsPreference(privateDnsPreference == null ? null : privateDnsPreference.toString());
            return this;
        }

        public final Collection<String> getPrivateDnsSpecifiedDomains() {
            if (privateDnsSpecifiedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return privateDnsSpecifiedDomains;
        }

        public final void setPrivateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainsListCopier.copy(privateDnsSpecifiedDomains);
        }

        @Override
        public final Builder privateDnsSpecifiedDomains(Collection<String> privateDnsSpecifiedDomains) {
            this.privateDnsSpecifiedDomains = PrivateDnsSpecifiedDomainsListCopier.copy(privateDnsSpecifiedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateDnsSpecifiedDomains(String... privateDnsSpecifiedDomains) {
            privateDnsSpecifiedDomains(Arrays.asList(privateDnsSpecifiedDomains));
            return this;
        }

        @Override
        public DnsOptions build() {
            return new DnsOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
