/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a domain verification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainVerificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainVerificationSummary.Builder, DomainVerificationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DomainVerificationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DomainVerificationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DomainVerificationSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DomainVerificationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TxtMethodConfig> TXT_METHOD_CONFIG_FIELD = SdkField
            .<TxtMethodConfig> builder(MarshallingType.SDK_POJO).memberName("txtMethodConfig")
            .getter(getter(DomainVerificationSummary::txtMethodConfig)).setter(setter(Builder::txtMethodConfig))
            .constructor(TxtMethodConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("txtMethodConfig").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(DomainVerificationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_VERIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastVerifiedTime")
            .getter(getter(DomainVerificationSummary::lastVerifiedTime))
            .setter(setter(Builder::lastVerifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastVerifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(DomainVerificationSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DOMAIN_NAME_FIELD, STATUS_FIELD, TXT_METHOD_CONFIG_FIELD, CREATED_AT_FIELD, LAST_VERIFIED_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String domainName;

    private final String status;

    private final TxtMethodConfig txtMethodConfig;

    private final Instant createdAt;

    private final Instant lastVerifiedTime;

    private final Map<String, String> tags;

    private DomainVerificationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.domainName = builder.domainName;
        this.status = builder.status;
        this.txtMethodConfig = builder.txtMethodConfig;
        this.createdAt = builder.createdAt;
        this.lastVerifiedTime = builder.lastVerifiedTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the domain verification.
     * </p>
     * 
     * @return The ID of the domain verification.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the domain verification.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the domain verification.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The domain name being verified.
     * </p>
     * 
     * @return The domain name being verified.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The current status of the domain verification process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the domain verification process.
     * @see VerificationStatus
     */
    public final VerificationStatus status() {
        return VerificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the domain verification process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the domain verification process.
     * @see VerificationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The TXT record configuration used for domain verification.
     * </p>
     * 
     * @return The TXT record configuration used for domain verification.
     */
    public final TxtMethodConfig txtMethodConfig() {
        return txtMethodConfig;
    }

    /**
     * <p>
     * The date and time that the domain verification was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the domain verification was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the domain was last successfully verified, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the domain was last successfully verified, in ISO-8601 format.
     */
    public final Instant lastVerifiedTime() {
        return lastVerifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the domain verification.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the domain verification.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(txtMethodConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastVerifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainVerificationSummary)) {
            return false;
        }
        DomainVerificationSummary other = (DomainVerificationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(txtMethodConfig(), other.txtMethodConfig()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastVerifiedTime(), other.lastVerifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainVerificationSummary").add("Id", id()).add("Arn", arn()).add("DomainName", domainName())
                .add("Status", statusAsString()).add("TxtMethodConfig", txtMethodConfig()).add("CreatedAt", createdAt())
                .add("LastVerifiedTime", lastVerifiedTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "txtMethodConfig":
            return Optional.ofNullable(clazz.cast(txtMethodConfig()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastVerifiedTime":
            return Optional.ofNullable(clazz.cast(lastVerifiedTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("txtMethodConfig", TXT_METHOD_CONFIG_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastVerifiedTime", LAST_VERIFIED_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainVerificationSummary, T> g) {
        return obj -> g.apply((DomainVerificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainVerificationSummary> {
        /**
         * <p>
         * The ID of the domain verification.
         * </p>
         * 
         * @param id
         *        The ID of the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the domain verification.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The domain name being verified.
         * </p>
         * 
         * @param domainName
         *        The domain name being verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The current status of the domain verification process.
         * </p>
         * 
         * @param status
         *        The current status of the domain verification process.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the domain verification process.
         * </p>
         * 
         * @param status
         *        The current status of the domain verification process.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(VerificationStatus status);

        /**
         * <p>
         * The TXT record configuration used for domain verification.
         * </p>
         * 
         * @param txtMethodConfig
         *        The TXT record configuration used for domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder txtMethodConfig(TxtMethodConfig txtMethodConfig);

        /**
         * <p>
         * The TXT record configuration used for domain verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link TxtMethodConfig.Builder} avoiding the
         * need to create one manually via {@link TxtMethodConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TxtMethodConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #txtMethodConfig(TxtMethodConfig)}.
         * 
         * @param txtMethodConfig
         *        a consumer that will call methods on {@link TxtMethodConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #txtMethodConfig(TxtMethodConfig)
         */
        default Builder txtMethodConfig(Consumer<TxtMethodConfig.Builder> txtMethodConfig) {
            return txtMethodConfig(TxtMethodConfig.builder().applyMutation(txtMethodConfig).build());
        }

        /**
         * <p>
         * The date and time that the domain verification was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the domain verification was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the domain was last successfully verified, in ISO-8601 format.
         * </p>
         * 
         * @param lastVerifiedTime
         *        The date and time that the domain was last successfully verified, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastVerifiedTime(Instant lastVerifiedTime);

        /**
         * <p>
         * The tags associated with the domain verification.
         * </p>
         * 
         * @param tags
         *        The tags associated with the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String domainName;

        private String status;

        private TxtMethodConfig txtMethodConfig;

        private Instant createdAt;

        private Instant lastVerifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DomainVerificationSummary model) {
            id(model.id);
            arn(model.arn);
            domainName(model.domainName);
            status(model.status);
            txtMethodConfig(model.txtMethodConfig);
            createdAt(model.createdAt);
            lastVerifiedTime(model.lastVerifiedTime);
            tags(model.tags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TxtMethodConfig.Builder getTxtMethodConfig() {
            return txtMethodConfig != null ? txtMethodConfig.toBuilder() : null;
        }

        public final void setTxtMethodConfig(TxtMethodConfig.BuilderImpl txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig != null ? txtMethodConfig.build() : null;
        }

        @Override
        public final Builder txtMethodConfig(TxtMethodConfig txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastVerifiedTime() {
            return lastVerifiedTime;
        }

        public final void setLastVerifiedTime(Instant lastVerifiedTime) {
            this.lastVerifiedTime = lastVerifiedTime;
        }

        @Override
        public final Builder lastVerifiedTime(Instant lastVerifiedTime) {
            this.lastVerifiedTime = lastVerifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public DomainVerificationSummary build() {
            return new DomainVerificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
