/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthPolicyResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<GetAuthPolicyResponse.Builder, GetAuthPolicyResponse> {
    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("policy")
            .getter(getter(GetAuthPolicyResponse::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(GetAuthPolicyResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAuthPolicyResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(GetAuthPolicyResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD, STATE_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policy;

    private final String state;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private GetAuthPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
        this.state = builder.state;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The auth policy.
     * </p>
     * 
     * @return The auth policy.
     */
    public final String policy() {
        return policy;
    }

    /**
     * <p>
     * The state of the auth policy. The auth policy is only active when the auth type is set to <code>AWS_IAM</code>.
     * If you provide a policy, then authentication and authorization decisions are made based on this policy and the
     * client's IAM policy. If the auth type is <code>NONE</code>, then any auth policy that you provide remains
     * inactive. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AuthPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the auth policy. The auth policy is only active when the auth type is set to
     *         <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made
     *         based on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any auth
     *         policy that you provide remains inactive. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network"
     *         >Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * @see AuthPolicyState
     */
    public final AuthPolicyState state() {
        return AuthPolicyState.fromValue(state);
    }

    /**
     * <p>
     * The state of the auth policy. The auth policy is only active when the auth type is set to <code>AWS_IAM</code>.
     * If you provide a policy, then authentication and authorization decisions are made based on this policy and the
     * client's IAM policy. If the auth type is <code>NONE</code>, then any auth policy that you provide remains
     * inactive. For more information, see <a
     * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create a
     * service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link AuthPolicyState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the auth policy. The auth policy is only active when the auth type is set to
     *         <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made
     *         based on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any auth
     *         policy that you provide remains inactive. For more information, see <a
     *         href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network"
     *         >Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
     * @see AuthPolicyState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time that the auth policy was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the auth policy was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the auth policy was last updated, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the auth policy was last updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthPolicyResponse)) {
            return false;
        }
        GetAuthPolicyResponse other = (GetAuthPolicyResponse) obj;
        return Objects.equals(policy(), other.policy()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthPolicyResponse").add("Policy", policy()).add("State", stateAsString())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policy", POLICY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthPolicyResponse, T> g) {
        return obj -> g.apply((GetAuthPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAuthPolicyResponse> {
        /**
         * <p>
         * The auth policy.
         * </p>
         * 
         * @param policy
         *        The auth policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The state of the auth policy. The auth policy is only active when the auth type is set to
         * <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made based
         * on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any auth policy that
         * you provide remains inactive. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create
         * a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
         * </p>
         * 
         * @param state
         *        The state of the auth policy. The auth policy is only active when the auth type is set to
         *        <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are
         *        made based on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any
         *        auth policy that you provide remains inactive. For more information, see <a href=
         *        "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network"
         *        >Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
         * @see AuthPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthPolicyState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the auth policy. The auth policy is only active when the auth type is set to
         * <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are made based
         * on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any auth policy that
         * you provide remains inactive. For more information, see <a
         * href="https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network">Create
         * a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
         * </p>
         * 
         * @param state
         *        The state of the auth policy. The auth policy is only active when the auth type is set to
         *        <code>AWS_IAM</code>. If you provide a policy, then authentication and authorization decisions are
         *        made based on this policy and the client's IAM policy. If the auth type is <code>NONE</code>, then any
         *        auth policy that you provide remains inactive. For more information, see <a href=
         *        "https://docs.aws.amazon.com/vpc-lattice/latest/ug/service-networks.html#create-service-network"
         *        >Create a service network</a> in the <i>Amazon VPC Lattice User Guide</i>.
         * @see AuthPolicyState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthPolicyState
         */
        Builder state(AuthPolicyState state);

        /**
         * <p>
         * The date and time that the auth policy was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the auth policy was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the auth policy was last updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time that the auth policy was last updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String policy;

        private String state;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthPolicyResponse model) {
            super(model);
            policy(model.policy);
            state(model.state);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getPolicy() {
            return policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AuthPolicyState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        @Override
        public GetAuthPolicyResponse build() {
            return new GetAuthPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
