/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetListenerRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<GetListenerRequest.Builder, GetListenerRequest> {
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(GetListenerRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final SdkField<String> LISTENER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerIdentifier").getter(getter(GetListenerRequest::listenerIdentifier))
            .setter(setter(Builder::listenerIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("listenerIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IDENTIFIER_FIELD,
            LISTENER_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceIdentifier;

    private final String listenerIdentifier;

    private GetListenerRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIdentifier = builder.serviceIdentifier;
        this.listenerIdentifier = builder.listenerIdentifier;
    }

    /**
     * <p>
     * The ID or ARN of the service.
     * </p>
     * 
     * @return The ID or ARN of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    /**
     * <p>
     * The ID or ARN of the listener.
     * </p>
     * 
     * @return The ID or ARN of the listener.
     */
    public final String listenerIdentifier() {
        return listenerIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(listenerIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetListenerRequest)) {
            return false;
        }
        GetListenerRequest other = (GetListenerRequest) obj;
        return Objects.equals(serviceIdentifier(), other.serviceIdentifier())
                && Objects.equals(listenerIdentifier(), other.listenerIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetListenerRequest").add("ServiceIdentifier", serviceIdentifier())
                .add("ListenerIdentifier", listenerIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        case "listenerIdentifier":
            return Optional.ofNullable(clazz.cast(listenerIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
        map.put("listenerIdentifier", LISTENER_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetListenerRequest, T> g) {
        return obj -> g.apply((GetListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetListenerRequest> {
        /**
         * <p>
         * The ID or ARN of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or ARN of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        /**
         * <p>
         * The ID or ARN of the listener.
         * </p>
         * 
         * @param listenerIdentifier
         *        The ID or ARN of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerIdentifier(String listenerIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String serviceIdentifier;

        private String listenerIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetListenerRequest model) {
            super(model);
            serviceIdentifier(model.serviceIdentifier);
            listenerIdentifier(model.listenerIdentifier);
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final String getListenerIdentifier() {
            return listenerIdentifier;
        }

        public final void setListenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
        }

        @Override
        public final Builder listenerIdentifier(String listenerIdentifier) {
            this.listenerIdentifier = listenerIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetListenerRequest build() {
            return new GetListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
