/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceNetworkResourceAssociationsRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<ListServiceNetworkResourceAssociationsRequest.Builder, ListServiceNetworkResourceAssociationsRequest> {
    private static final SdkField<String> SERVICE_NETWORK_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkIdentifier")
            .getter(getter(ListServiceNetworkResourceAssociationsRequest::serviceNetworkIdentifier))
            .setter(setter(Builder::serviceNetworkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceNetworkIdentifier")
                    .build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationIdentifier")
            .getter(getter(ListServiceNetworkResourceAssociationsRequest::resourceConfigurationIdentifier))
            .setter(setter(Builder::resourceConfigurationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM)
                    .locationName("resourceConfigurationIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListServiceNetworkResourceAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListServiceNetworkResourceAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> INCLUDE_CHILDREN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeChildren").getter(getter(ListServiceNetworkResourceAssociationsRequest::includeChildren))
            .setter(setter(Builder::includeChildren))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeChildren").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_NETWORK_IDENTIFIER_FIELD, RESOURCE_CONFIGURATION_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            INCLUDE_CHILDREN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceNetworkIdentifier;

    private final String resourceConfigurationIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean includeChildren;

    private ListServiceNetworkResourceAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceNetworkIdentifier = builder.serviceNetworkIdentifier;
        this.resourceConfigurationIdentifier = builder.resourceConfigurationIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeChildren = builder.includeChildren;
    }

    /**
     * <p>
     * The ID of the service network.
     * </p>
     * 
     * @return The ID of the service network.
     */
    public final String serviceNetworkIdentifier() {
        return serviceNetworkIdentifier;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String resourceConfigurationIdentifier() {
        return resourceConfigurationIdentifier;
    }

    /**
     * <p>
     * The maximum page size.
     * </p>
     * 
     * @return The maximum page size.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If there are additional results, a pagination token for the next page of results.
     * </p>
     * 
     * @return If there are additional results, a pagination token for the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Include service network resource associations of the child resource configuration with the grouped resource
     * configuration.
     * </p>
     * <p>
     * The type is boolean and the default value is false.
     * </p>
     * 
     * @return Include service network resource associations of the child resource configuration with the grouped
     *         resource configuration.</p>
     *         <p>
     *         The type is boolean and the default value is false.
     */
    public final Boolean includeChildren() {
        return includeChildren;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(includeChildren());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceNetworkResourceAssociationsRequest)) {
            return false;
        }
        ListServiceNetworkResourceAssociationsRequest other = (ListServiceNetworkResourceAssociationsRequest) obj;
        return Objects.equals(serviceNetworkIdentifier(), other.serviceNetworkIdentifier())
                && Objects.equals(resourceConfigurationIdentifier(), other.resourceConfigurationIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(includeChildren(), other.includeChildren());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListServiceNetworkResourceAssociationsRequest")
                .add("ServiceNetworkIdentifier", serviceNetworkIdentifier())
                .add("ResourceConfigurationIdentifier", resourceConfigurationIdentifier()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("IncludeChildren", includeChildren()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceNetworkIdentifier":
            return Optional.ofNullable(clazz.cast(serviceNetworkIdentifier()));
        case "resourceConfigurationIdentifier":
            return Optional.ofNullable(clazz.cast(resourceConfigurationIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "includeChildren":
            return Optional.ofNullable(clazz.cast(includeChildren()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceNetworkIdentifier", SERVICE_NETWORK_IDENTIFIER_FIELD);
        map.put("resourceConfigurationIdentifier", RESOURCE_CONFIGURATION_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("includeChildren", INCLUDE_CHILDREN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListServiceNetworkResourceAssociationsRequest, T> g) {
        return obj -> g.apply((ListServiceNetworkResourceAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceNetworkResourceAssociationsRequest> {
        /**
         * <p>
         * The ID of the service network.
         * </p>
         * 
         * @param serviceNetworkIdentifier
         *        The ID of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkIdentifier(String serviceNetworkIdentifier);

        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param resourceConfigurationIdentifier
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier);

        /**
         * <p>
         * The maximum page size.
         * </p>
         * 
         * @param maxResults
         *        The maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If there are additional results, a pagination token for the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, a pagination token for the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Include service network resource associations of the child resource configuration with the grouped resource
         * configuration.
         * </p>
         * <p>
         * The type is boolean and the default value is false.
         * </p>
         * 
         * @param includeChildren
         *        Include service network resource associations of the child resource configuration with the grouped
         *        resource configuration.</p>
         *        <p>
         *        The type is boolean and the default value is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeChildren(Boolean includeChildren);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String serviceNetworkIdentifier;

        private String resourceConfigurationIdentifier;

        private Integer maxResults;

        private String nextToken;

        private Boolean includeChildren;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceNetworkResourceAssociationsRequest model) {
            super(model);
            serviceNetworkIdentifier(model.serviceNetworkIdentifier);
            resourceConfigurationIdentifier(model.resourceConfigurationIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            includeChildren(model.includeChildren);
        }

        public final String getServiceNetworkIdentifier() {
            return serviceNetworkIdentifier;
        }

        public final void setServiceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
        }

        @Override
        public final Builder serviceNetworkIdentifier(String serviceNetworkIdentifier) {
            this.serviceNetworkIdentifier = serviceNetworkIdentifier;
            return this;
        }

        public final String getResourceConfigurationIdentifier() {
            return resourceConfigurationIdentifier;
        }

        public final void setResourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
        }

        @Override
        public final Builder resourceConfigurationIdentifier(String resourceConfigurationIdentifier) {
            this.resourceConfigurationIdentifier = resourceConfigurationIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getIncludeChildren() {
            return includeChildren;
        }

        public final void setIncludeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
        }

        @Override
        public final Builder includeChildren(Boolean includeChildren) {
            this.includeChildren = includeChildren;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListServiceNetworkResourceAssociationsRequest build() {
            return new ListServiceNetworkResourceAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
