/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resource configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfigurationDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceConfigurationDefinition.Builder, ResourceConfigurationDefinition> {
    private static final SdkField<DnsResource> DNS_RESOURCE_FIELD = SdkField.<DnsResource> builder(MarshallingType.SDK_POJO)
            .memberName("dnsResource").getter(getter(ResourceConfigurationDefinition::dnsResource))
            .setter(setter(Builder::dnsResource)).constructor(DnsResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsResource").build()).build();

    private static final SdkField<IpResource> IP_RESOURCE_FIELD = SdkField.<IpResource> builder(MarshallingType.SDK_POJO)
            .memberName("ipResource").getter(getter(ResourceConfigurationDefinition::ipResource))
            .setter(setter(Builder::ipResource)).constructor(IpResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipResource").build()).build();

    private static final SdkField<ArnResource> ARN_RESOURCE_FIELD = SdkField.<ArnResource> builder(MarshallingType.SDK_POJO)
            .memberName("arnResource").getter(getter(ResourceConfigurationDefinition::arnResource))
            .setter(setter(Builder::arnResource)).constructor(ArnResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arnResource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_RESOURCE_FIELD,
            IP_RESOURCE_FIELD, ARN_RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DnsResource dnsResource;

    private final IpResource ipResource;

    private final ArnResource arnResource;

    private final Type type;

    private ResourceConfigurationDefinition(BuilderImpl builder) {
        this.dnsResource = builder.dnsResource;
        this.ipResource = builder.ipResource;
        this.arnResource = builder.arnResource;
        this.type = builder.type;
    }

    /**
     * <p>
     * The DNS name of the resource.
     * </p>
     * 
     * @return The DNS name of the resource.
     */
    public final DnsResource dnsResource() {
        return dnsResource;
    }

    /**
     * <p>
     * The IP resource.
     * </p>
     * 
     * @return The IP resource.
     */
    public final IpResource ipResource() {
        return ipResource;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final ArnResource arnResource() {
        return arnResource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsResource());
        hashCode = 31 * hashCode + Objects.hashCode(ipResource());
        hashCode = 31 * hashCode + Objects.hashCode(arnResource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigurationDefinition)) {
            return false;
        }
        ResourceConfigurationDefinition other = (ResourceConfigurationDefinition) obj;
        return Objects.equals(dnsResource(), other.dnsResource()) && Objects.equals(ipResource(), other.ipResource())
                && Objects.equals(arnResource(), other.arnResource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceConfigurationDefinition").add("DnsResource", dnsResource())
                .add("IpResource", ipResource()).add("ArnResource", arnResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dnsResource":
            return Optional.ofNullable(clazz.cast(dnsResource()));
        case "ipResource":
            return Optional.ofNullable(clazz.cast(ipResource()));
        case "arnResource":
            return Optional.ofNullable(clazz.cast(arnResource()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dnsResource()} initialized to the given value.
     *
     * <p>
     * The DNS name of the resource.
     * </p>
     * 
     * @param dnsResource
     *        The DNS name of the resource.
     */
    public static ResourceConfigurationDefinition fromDnsResource(DnsResource dnsResource) {
        return builder().dnsResource(dnsResource).build();
    }

    /**
     * Create an instance of this class with {@link #dnsResource()} initialized to the given value.
     *
     * <p>
     * The DNS name of the resource.
     * </p>
     * 
     * @param dnsResource
     *        The DNS name of the resource.
     */
    public static ResourceConfigurationDefinition fromDnsResource(Consumer<DnsResource.Builder> dnsResource) {
        DnsResource.Builder builder = DnsResource.builder();
        dnsResource.accept(builder);
        return fromDnsResource(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ipResource()} initialized to the given value.
     *
     * <p>
     * The IP resource.
     * </p>
     * 
     * @param ipResource
     *        The IP resource.
     */
    public static ResourceConfigurationDefinition fromIpResource(IpResource ipResource) {
        return builder().ipResource(ipResource).build();
    }

    /**
     * Create an instance of this class with {@link #ipResource()} initialized to the given value.
     *
     * <p>
     * The IP resource.
     * </p>
     * 
     * @param ipResource
     *        The IP resource.
     */
    public static ResourceConfigurationDefinition fromIpResource(Consumer<IpResource.Builder> ipResource) {
        IpResource.Builder builder = IpResource.builder();
        ipResource.accept(builder);
        return fromIpResource(builder.build());
    }

    /**
     * Create an instance of this class with {@link #arnResource()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @param arnResource
     *        The Amazon Resource Name (ARN) of the resource.
     */
    public static ResourceConfigurationDefinition fromArnResource(ArnResource arnResource) {
        return builder().arnResource(arnResource).build();
    }

    /**
     * Create an instance of this class with {@link #arnResource()} initialized to the given value.
     *
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @param arnResource
     *        The Amazon Resource Name (ARN) of the resource.
     */
    public static ResourceConfigurationDefinition fromArnResource(Consumer<ArnResource.Builder> arnResource) {
        ArnResource.Builder builder = ArnResource.builder();
        arnResource.accept(builder);
        return fromArnResource(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dnsResource", DNS_RESOURCE_FIELD);
        map.put("ipResource", IP_RESOURCE_FIELD);
        map.put("arnResource", ARN_RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigurationDefinition, T> g) {
        return obj -> g.apply((ResourceConfigurationDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfigurationDefinition> {
        /**
         * <p>
         * The DNS name of the resource.
         * </p>
         * 
         * @param dnsResource
         *        The DNS name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsResource(DnsResource dnsResource);

        /**
         * <p>
         * The DNS name of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsResource.Builder} avoiding the need to
         * create one manually via {@link DnsResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsResource.Builder#build()} is called immediately and its result
         * is passed to {@link #dnsResource(DnsResource)}.
         * 
         * @param dnsResource
         *        a consumer that will call methods on {@link DnsResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsResource(DnsResource)
         */
        default Builder dnsResource(Consumer<DnsResource.Builder> dnsResource) {
            return dnsResource(DnsResource.builder().applyMutation(dnsResource).build());
        }

        /**
         * <p>
         * The IP resource.
         * </p>
         * 
         * @param ipResource
         *        The IP resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipResource(IpResource ipResource);

        /**
         * <p>
         * The IP resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpResource.Builder} avoiding the need to
         * create one manually via {@link IpResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpResource.Builder#build()} is called immediately and its result
         * is passed to {@link #ipResource(IpResource)}.
         * 
         * @param ipResource
         *        a consumer that will call methods on {@link IpResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipResource(IpResource)
         */
        default Builder ipResource(Consumer<IpResource.Builder> ipResource) {
            return ipResource(IpResource.builder().applyMutation(ipResource).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arnResource
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arnResource(ArnResource arnResource);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArnResource.Builder} avoiding the need to
         * create one manually via {@link ArnResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArnResource.Builder#build()} is called immediately and its result
         * is passed to {@link #arnResource(ArnResource)}.
         * 
         * @param arnResource
         *        a consumer that will call methods on {@link ArnResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arnResource(ArnResource)
         */
        default Builder arnResource(Consumer<ArnResource.Builder> arnResource) {
            return arnResource(ArnResource.builder().applyMutation(arnResource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DnsResource dnsResource;

        private IpResource ipResource;

        private ArnResource arnResource;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigurationDefinition model) {
            dnsResource(model.dnsResource);
            ipResource(model.ipResource);
            arnResource(model.arnResource);
        }

        public final DnsResource.Builder getDnsResource() {
            return dnsResource != null ? dnsResource.toBuilder() : null;
        }

        public final void setDnsResource(DnsResource.BuilderImpl dnsResource) {
            Object oldValue = this.dnsResource;
            this.dnsResource = dnsResource != null ? dnsResource.build() : null;
            handleUnionValueChange(Type.DNS_RESOURCE, oldValue, this.dnsResource);
        }

        @Override
        public final Builder dnsResource(DnsResource dnsResource) {
            Object oldValue = this.dnsResource;
            this.dnsResource = dnsResource;
            handleUnionValueChange(Type.DNS_RESOURCE, oldValue, this.dnsResource);
            return this;
        }

        public final IpResource.Builder getIpResource() {
            return ipResource != null ? ipResource.toBuilder() : null;
        }

        public final void setIpResource(IpResource.BuilderImpl ipResource) {
            Object oldValue = this.ipResource;
            this.ipResource = ipResource != null ? ipResource.build() : null;
            handleUnionValueChange(Type.IP_RESOURCE, oldValue, this.ipResource);
        }

        @Override
        public final Builder ipResource(IpResource ipResource) {
            Object oldValue = this.ipResource;
            this.ipResource = ipResource;
            handleUnionValueChange(Type.IP_RESOURCE, oldValue, this.ipResource);
            return this;
        }

        public final ArnResource.Builder getArnResource() {
            return arnResource != null ? arnResource.toBuilder() : null;
        }

        public final void setArnResource(ArnResource.BuilderImpl arnResource) {
            Object oldValue = this.arnResource;
            this.arnResource = arnResource != null ? arnResource.build() : null;
            handleUnionValueChange(Type.ARN_RESOURCE, oldValue, this.arnResource);
        }

        @Override
        public final Builder arnResource(ArnResource arnResource) {
            Object oldValue = this.arnResource;
            this.arnResource = arnResource;
            handleUnionValueChange(Type.ARN_RESOURCE, oldValue, this.arnResource);
            return this;
        }

        @Override
        public ResourceConfigurationDefinition build() {
            return new ResourceConfigurationDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceConfigurationDefinition#type()
     */
    public enum Type {
        DNS_RESOURCE,

        IP_RESOURCE,

        ARN_RESOURCE,

        UNKNOWN_TO_SDK_VERSION
    }
}
