/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a resource configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfigurationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceConfigurationSummary.Builder, ResourceConfigurationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ResourceConfigurationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ResourceConfigurationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceConfigurationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayId").getter(getter(ResourceConfigurationSummary::resourceGatewayId))
            .setter(setter(Builder::resourceGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupId")
            .getter(getter(ResourceConfigurationSummary::resourceConfigurationGroupId))
            .setter(setter(Builder::resourceConfigurationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ResourceConfigurationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ResourceConfigurationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Boolean> AMAZON_MANAGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("amazonManaged").getter(getter(ResourceConfigurationSummary::amazonManaged))
            .setter(setter(Builder::amazonManaged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amazonManaged").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ResourceConfigurationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(ResourceConfigurationSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(ResourceConfigurationSummary::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final SdkField<String> DOMAIN_VERIFICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainVerificationId").getter(getter(ResourceConfigurationSummary::domainVerificationId))
            .setter(setter(Builder::domainVerificationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainVerificationId").build())
            .build();

    private static final SdkField<String> GROUP_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupDomain").getter(getter(ResourceConfigurationSummary::groupDomain))
            .setter(setter(Builder::groupDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupDomain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, RESOURCE_GATEWAY_ID_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, TYPE_FIELD, STATUS_FIELD,
            AMAZON_MANAGED_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, CUSTOM_DOMAIN_NAME_FIELD,
            DOMAIN_VERIFICATION_ID_FIELD, GROUP_DOMAIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final String resourceGatewayId;

    private final String resourceConfigurationGroupId;

    private final String type;

    private final String status;

    private final Boolean amazonManaged;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String customDomainName;

    private final String domainVerificationId;

    private final String groupDomain;

    private ResourceConfigurationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.type = builder.type;
        this.status = builder.status;
        this.amazonManaged = builder.amazonManaged;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.customDomainName = builder.customDomainName;
        this.domainVerificationId = builder.domainVerificationId;
        this.groupDomain = builder.groupDomain;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the resource configuration.
     * </p>
     * 
     * @return The name of the resource configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the resource gateway.
     * </p>
     * 
     * @return The ID of the resource gateway.
     */
    public final String resourceGatewayId() {
        return resourceGatewayId;
    }

    /**
     * <p>
     * The ID of the group resource configuration.
     * </p>
     * 
     * @return The ID of the group resource configuration.
     */
    public final String resourceConfigurationGroupId() {
        return resourceConfigurationGroupId;
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources. You must create a group resource configuration before you create a
     * child resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources. You must create a group resource configuration before you
     *         create a child resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources. You must create a group resource configuration before you create a
     * child resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources. You must create a group resource configuration before you
     *         create a child resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates whether the resource configuration was created and is managed by Amazon.
     * </p>
     * 
     * @return Indicates whether the resource configuration was created and is managed by Amazon.
     */
    public final Boolean amazonManaged() {
        return amazonManaged;
    }

    /**
     * <p>
     * The date and time that the resource configuration was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the resource configuration was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     * </p>
     * 
     * @return The most recent date and time that the resource configuration was updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The custom domain name.
     * </p>
     * 
     * @return The custom domain name.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    /**
     * <p>
     * The domain verification ID.
     * </p>
     * 
     * @return The domain verification ID.
     */
    public final String domainVerificationId() {
        return domainVerificationId;
    }

    /**
     * <p>
     * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child resource
     * are subdomains of the group domain. Child resources inherit the verification status of the domain.
     * </p>
     * 
     * @return (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
     *         resource are subdomains of the group domain. Child resources inherit the verification status of the
     *         domain.
     */
    public final String groupDomain() {
        return groupDomain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(amazonManaged());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainVerificationId());
        hashCode = 31 * hashCode + Objects.hashCode(groupDomain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfigurationSummary)) {
            return false;
        }
        ResourceConfigurationSummary other = (ResourceConfigurationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(resourceGatewayId(), other.resourceGatewayId())
                && Objects.equals(resourceConfigurationGroupId(), other.resourceConfigurationGroupId())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(amazonManaged(), other.amazonManaged()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(customDomainName(), other.customDomainName())
                && Objects.equals(domainVerificationId(), other.domainVerificationId())
                && Objects.equals(groupDomain(), other.groupDomain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceConfigurationSummary").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("ResourceGatewayId", resourceGatewayId())
                .add("ResourceConfigurationGroupId", resourceConfigurationGroupId()).add("Type", typeAsString())
                .add("Status", statusAsString()).add("AmazonManaged", amazonManaged()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("CustomDomainName", customDomainName())
                .add("DomainVerificationId", domainVerificationId()).add("GroupDomain", groupDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "resourceGatewayId":
            return Optional.ofNullable(clazz.cast(resourceGatewayId()));
        case "resourceConfigurationGroupId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "amazonManaged":
            return Optional.ofNullable(clazz.cast(amazonManaged()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        case "domainVerificationId":
            return Optional.ofNullable(clazz.cast(domainVerificationId()));
        case "groupDomain":
            return Optional.ofNullable(clazz.cast(groupDomain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("amazonManaged", AMAZON_MANAGED_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("domainVerificationId", DOMAIN_VERIFICATION_ID_FIELD);
        map.put("groupDomain", GROUP_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfigurationSummary, T> g) {
        return obj -> g.apply((ResourceConfigurationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfigurationSummary> {
        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param id
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the resource configuration.
         * </p>
         * 
         * @param name
         *        The name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the resource gateway.
         * </p>
         * 
         * @param resourceGatewayId
         *        The ID of the resource gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayId(String resourceGatewayId);

        /**
         * <p>
         * The ID of the group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupId
         *        The ID of the group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupId(String resourceConfigurationGroupId);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources. You must create a group resource configuration before you create a
         * child resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources. You must create a group resource configuration before you
         *        create a child resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources. You must create a group resource configuration before you create a
         * child resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources. You must create a group resource configuration before you
         *        create a child resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(ResourceConfigurationType type);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(ResourceConfigurationStatus status);

        /**
         * <p>
         * Indicates whether the resource configuration was created and is managed by Amazon.
         * </p>
         * 
         * @param amazonManaged
         *        Indicates whether the resource configuration was created and is managed by Amazon.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonManaged(Boolean amazonManaged);

        /**
         * <p>
         * The date and time that the resource configuration was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the resource configuration was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The most recent date and time that the resource configuration was updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The custom domain name.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);

        /**
         * <p>
         * The domain verification ID.
         * </p>
         * 
         * @param domainVerificationId
         *        The domain verification ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainVerificationId(String domainVerificationId);

        /**
         * <p>
         * (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         * resource are subdomains of the group domain. Child resources inherit the verification status of the domain.
         * </p>
         * 
         * @param groupDomain
         *        (GROUP) The group domain for a group resource configuration. Any domains that you create for the child
         *        resource are subdomains of the group domain. Child resources inherit the verification status of the
         *        domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDomain(String groupDomain);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String resourceGatewayId;

        private String resourceConfigurationGroupId;

        private String type;

        private String status;

        private Boolean amazonManaged;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String customDomainName;

        private String domainVerificationId;

        private String groupDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfigurationSummary model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            resourceGatewayId(model.resourceGatewayId);
            resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            type(model.type);
            status(model.status);
            amazonManaged(model.amazonManaged);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            customDomainName(model.customDomainName);
            domainVerificationId(model.domainVerificationId);
            groupDomain(model.groupDomain);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceGatewayId() {
            return resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getAmazonManaged() {
            return amazonManaged;
        }

        public final void setAmazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
        }

        @Override
        public final Builder amazonManaged(Boolean amazonManaged) {
            this.amazonManaged = amazonManaged;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDomainVerificationId() {
            return domainVerificationId;
        }

        public final void setDomainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
        }

        @Override
        public final Builder domainVerificationId(String domainVerificationId) {
            this.domainVerificationId = domainVerificationId;
            return this;
        }

        public final String getGroupDomain() {
            return groupDomain;
        }

        public final void setGroupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
        }

        @Override
        public final Builder groupDomain(String groupDomain) {
            this.groupDomain = groupDomain;
            return this;
        }

        @Override
        public ResourceConfigurationSummary build() {
            return new ResourceConfigurationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
