/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an association between a service network and a service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNetworkServiceAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNetworkServiceAssociationSummary.Builder, ServiceNetworkServiceAssociationSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceNetworkServiceAssociationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ServiceNetworkServiceAssociationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServiceNetworkServiceAssociationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(ServiceNetworkServiceAssociationSummary::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ServiceNetworkServiceAssociationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceId").getter(getter(ServiceNetworkServiceAssociationSummary::serviceId))
            .setter(setter(Builder::serviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceId").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceName").getter(getter(ServiceNetworkServiceAssociationSummary::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(ServiceNetworkServiceAssociationSummary::serviceArn))
            .setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkId").getter(getter(ServiceNetworkServiceAssociationSummary::serviceNetworkId))
            .setter(setter(Builder::serviceNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkId").build()).build();

    private static final SdkField<String> SERVICE_NETWORK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkName").getter(getter(ServiceNetworkServiceAssociationSummary::serviceNetworkName))
            .setter(setter(Builder::serviceNetworkName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkName").build())
            .build();

    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkArn").getter(getter(ServiceNetworkServiceAssociationSummary::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()).build();

    private static final SdkField<DnsEntry> DNS_ENTRY_FIELD = SdkField.<DnsEntry> builder(MarshallingType.SDK_POJO)
            .memberName("dnsEntry").getter(getter(ServiceNetworkServiceAssociationSummary::dnsEntry))
            .setter(setter(Builder::dnsEntry)).constructor(DnsEntry::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsEntry").build()).build();

    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customDomainName").getter(getter(ServiceNetworkServiceAssociationSummary::customDomainName))
            .setter(setter(Builder::customDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATUS_FIELD,
            ARN_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, SERVICE_ID_FIELD, SERVICE_NAME_FIELD, SERVICE_ARN_FIELD,
            SERVICE_NETWORK_ID_FIELD, SERVICE_NETWORK_NAME_FIELD, SERVICE_NETWORK_ARN_FIELD, DNS_ENTRY_FIELD,
            CUSTOM_DOMAIN_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String status;

    private final String arn;

    private final String createdBy;

    private final Instant createdAt;

    private final String serviceId;

    private final String serviceName;

    private final String serviceArn;

    private final String serviceNetworkId;

    private final String serviceNetworkName;

    private final String serviceNetworkArn;

    private final DnsEntry dnsEntry;

    private final String customDomainName;

    private ServiceNetworkServiceAssociationSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.serviceId = builder.serviceId;
        this.serviceName = builder.serviceName;
        this.serviceArn = builder.serviceArn;
        this.serviceNetworkId = builder.serviceNetworkId;
        this.serviceNetworkName = builder.serviceNetworkName;
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.dnsEntry = builder.dnsEntry;
        this.customDomainName = builder.customDomainName;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of the service network’s association with the service. If the deletion fails, try to delete again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkServiceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service network’s association with the service. If the deletion fails, try to delete
     *         again.
     * @see ServiceNetworkServiceAssociationStatus
     */
    public final ServiceNetworkServiceAssociationStatus status() {
        return ServiceNetworkServiceAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the service network’s association with the service. If the deletion fails, try to delete again.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ServiceNetworkServiceAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the service network’s association with the service. If the deletion fails, try to delete
     *         again.
     * @see ServiceNetworkServiceAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the association.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The account that created the association.
     * </p>
     * 
     * @return The account that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time that the association was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the association was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID of the service.
     * </p>
     * 
     * @return The ID of the service.
     */
    public final String serviceId() {
        return serviceId;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The ID of the service network.
     * </p>
     * 
     * @return The ID of the service network.
     */
    public final String serviceNetworkId() {
        return serviceNetworkId;
    }

    /**
     * <p>
     * The name of the service network.
     * </p>
     * 
     * @return The name of the service network.
     */
    public final String serviceNetworkName() {
        return serviceNetworkName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The DNS information.
     * </p>
     * 
     * @return The DNS information.
     */
    public final DnsEntry dnsEntry() {
        return dnsEntry;
    }

    /**
     * <p>
     * The custom domain name of the service.
     * </p>
     * 
     * @return The custom domain name of the service.
     */
    public final String customDomainName() {
        return customDomainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(dnsEntry());
        hashCode = 31 * hashCode + Objects.hashCode(customDomainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkServiceAssociationSummary)) {
            return false;
        }
        ServiceNetworkServiceAssociationSummary other = (ServiceNetworkServiceAssociationSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(arn(), other.arn()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(serviceId(), other.serviceId())
                && Objects.equals(serviceName(), other.serviceName()) && Objects.equals(serviceArn(), other.serviceArn())
                && Objects.equals(serviceNetworkId(), other.serviceNetworkId())
                && Objects.equals(serviceNetworkName(), other.serviceNetworkName())
                && Objects.equals(serviceNetworkArn(), other.serviceNetworkArn()) && Objects.equals(dnsEntry(), other.dnsEntry())
                && Objects.equals(customDomainName(), other.customDomainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNetworkServiceAssociationSummary").add("Id", id()).add("Status", statusAsString())
                .add("Arn", arn()).add("CreatedBy", createdBy()).add("CreatedAt", createdAt()).add("ServiceId", serviceId())
                .add("ServiceName", serviceName()).add("ServiceArn", serviceArn()).add("ServiceNetworkId", serviceNetworkId())
                .add("ServiceNetworkName", serviceNetworkName()).add("ServiceNetworkArn", serviceNetworkArn())
                .add("DnsEntry", dnsEntry()).add("CustomDomainName", customDomainName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "serviceId":
            return Optional.ofNullable(clazz.cast(serviceId()));
        case "serviceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "serviceNetworkId":
            return Optional.ofNullable(clazz.cast(serviceNetworkId()));
        case "serviceNetworkName":
            return Optional.ofNullable(clazz.cast(serviceNetworkName()));
        case "serviceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "dnsEntry":
            return Optional.ofNullable(clazz.cast(dnsEntry()));
        case "customDomainName":
            return Optional.ofNullable(clazz.cast(customDomainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("serviceId", SERVICE_ID_FIELD);
        map.put("serviceName", SERVICE_NAME_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        map.put("serviceNetworkId", SERVICE_NETWORK_ID_FIELD);
        map.put("serviceNetworkName", SERVICE_NETWORK_NAME_FIELD);
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("dnsEntry", DNS_ENTRY_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkServiceAssociationSummary, T> g) {
        return obj -> g.apply((ServiceNetworkServiceAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNetworkServiceAssociationSummary> {
        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param id
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of the service network’s association with the service. If the deletion fails, try to delete again.
         * </p>
         * 
         * @param status
         *        The status of the service network’s association with the service. If the deletion fails, try to delete
         *        again.
         * @see ServiceNetworkServiceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkServiceAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the service network’s association with the service. If the deletion fails, try to delete again.
         * </p>
         * 
         * @param status
         *        The status of the service network’s association with the service. If the deletion fails, try to delete
         *        again.
         * @see ServiceNetworkServiceAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceNetworkServiceAssociationStatus
         */
        Builder status(ServiceNetworkServiceAssociationStatus status);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the association.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The account that created the association.
         * </p>
         * 
         * @param createdBy
         *        The account that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time that the association was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the association was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID of the service.
         * </p>
         * 
         * @param serviceId
         *        The ID of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceId(String serviceId);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param serviceName
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The ID of the service network.
         * </p>
         * 
         * @param serviceNetworkId
         *        The ID of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkId(String serviceNetworkId);

        /**
         * <p>
         * The name of the service network.
         * </p>
         * 
         * @param serviceNetworkName
         *        The name of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkName(String serviceNetworkName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The DNS information.
         * </p>
         * 
         * @param dnsEntry
         *        The DNS information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsEntry(DnsEntry dnsEntry);

        /**
         * <p>
         * The DNS information.
         * </p>
         * This is a convenience method that creates an instance of the {@link DnsEntry.Builder} avoiding the need to
         * create one manually via {@link DnsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DnsEntry.Builder#build()} is called immediately and its result is
         * passed to {@link #dnsEntry(DnsEntry)}.
         * 
         * @param dnsEntry
         *        a consumer that will call methods on {@link DnsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsEntry(DnsEntry)
         */
        default Builder dnsEntry(Consumer<DnsEntry.Builder> dnsEntry) {
            return dnsEntry(DnsEntry.builder().applyMutation(dnsEntry).build());
        }

        /**
         * <p>
         * The custom domain name of the service.
         * </p>
         * 
         * @param customDomainName
         *        The custom domain name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customDomainName(String customDomainName);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String status;

        private String arn;

        private String createdBy;

        private Instant createdAt;

        private String serviceId;

        private String serviceName;

        private String serviceArn;

        private String serviceNetworkId;

        private String serviceNetworkName;

        private String serviceNetworkArn;

        private DnsEntry dnsEntry;

        private String customDomainName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkServiceAssociationSummary model) {
            id(model.id);
            status(model.status);
            arn(model.arn);
            createdBy(model.createdBy);
            createdAt(model.createdAt);
            serviceId(model.serviceId);
            serviceName(model.serviceName);
            serviceArn(model.serviceArn);
            serviceNetworkId(model.serviceNetworkId);
            serviceNetworkName(model.serviceNetworkName);
            serviceNetworkArn(model.serviceNetworkArn);
            dnsEntry(model.dnsEntry);
            customDomainName(model.customDomainName);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServiceNetworkServiceAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServiceId() {
            return serviceId;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceNetworkId() {
            return serviceNetworkId;
        }

        public final void setServiceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
        }

        @Override
        public final Builder serviceNetworkId(String serviceNetworkId) {
            this.serviceNetworkId = serviceNetworkId;
            return this;
        }

        public final String getServiceNetworkName() {
            return serviceNetworkName;
        }

        public final void setServiceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
        }

        @Override
        public final Builder serviceNetworkName(String serviceNetworkName) {
            this.serviceNetworkName = serviceNetworkName;
            return this;
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final DnsEntry.Builder getDnsEntry() {
            return dnsEntry != null ? dnsEntry.toBuilder() : null;
        }

        public final void setDnsEntry(DnsEntry.BuilderImpl dnsEntry) {
            this.dnsEntry = dnsEntry != null ? dnsEntry.build() : null;
        }

        @Override
        public final Builder dnsEntry(DnsEntry dnsEntry) {
            this.dnsEntry = dnsEntry;
            return this;
        }

        public final String getCustomDomainName() {
            return customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        @Override
        public ServiceNetworkServiceAssociationSummary build() {
            return new ServiceNetworkServiceAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
