/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a service network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceNetworkSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceNetworkSummary.Builder, ServiceNetworkSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ServiceNetworkSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(ServiceNetworkSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ServiceNetworkSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(ServiceNetworkSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(ServiceNetworkSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_VP_CS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAssociatedVPCs").getter(getter(ServiceNetworkSummary::numberOfAssociatedVPCs))
            .setter(setter(Builder::numberOfAssociatedVPCs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedVPCs").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_SERVICES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAssociatedServices")
            .getter(getter(ServiceNetworkSummary::numberOfAssociatedServices))
            .setter(setter(Builder::numberOfAssociatedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfAssociatedServices").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_ASSOCIATED_RESOURCE_CONFIGURATIONS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("numberOfAssociatedResourceConfigurations")
            .getter(getter(ServiceNetworkSummary::numberOfAssociatedResourceConfigurations))
            .setter(setter(Builder::numberOfAssociatedResourceConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("numberOfAssociatedResourceConfigurations").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, NUMBER_OF_ASSOCIATED_VP_CS_FIELD,
            NUMBER_OF_ASSOCIATED_SERVICES_FIELD, NUMBER_OF_ASSOCIATED_RESOURCE_CONFIGURATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Long numberOfAssociatedVPCs;

    private final Long numberOfAssociatedServices;

    private final Long numberOfAssociatedResourceConfigurations;

    private ServiceNetworkSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.numberOfAssociatedVPCs = builder.numberOfAssociatedVPCs;
        this.numberOfAssociatedServices = builder.numberOfAssociatedServices;
        this.numberOfAssociatedResourceConfigurations = builder.numberOfAssociatedResourceConfigurations;
    }

    /**
     * <p>
     * The ID of the service network.
     * </p>
     * 
     * @return The ID of the service network.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the service network.
     * </p>
     * 
     * @return The name of the service network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the service network was created, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the service network was created, in ISO-8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time that the service network was last updated, in ISO-8601 format.
     * </p>
     * 
     * @return The date and time that the service network was last updated, in ISO-8601 format.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The number of VPCs associated with the service network.
     * </p>
     * 
     * @return The number of VPCs associated with the service network.
     */
    public final Long numberOfAssociatedVPCs() {
        return numberOfAssociatedVPCs;
    }

    /**
     * <p>
     * The number of services associated with the service network.
     * </p>
     * 
     * @return The number of services associated with the service network.
     */
    public final Long numberOfAssociatedServices() {
        return numberOfAssociatedServices;
    }

    /**
     * <p>
     * The number of resource configurations associated with a service network.
     * </p>
     * 
     * @return The number of resource configurations associated with a service network.
     */
    public final Long numberOfAssociatedResourceConfigurations() {
        return numberOfAssociatedResourceConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedVPCs());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedServices());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfAssociatedResourceConfigurations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceNetworkSummary)) {
            return false;
        }
        ServiceNetworkSummary other = (ServiceNetworkSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(numberOfAssociatedVPCs(), other.numberOfAssociatedVPCs())
                && Objects.equals(numberOfAssociatedServices(), other.numberOfAssociatedServices())
                && Objects.equals(numberOfAssociatedResourceConfigurations(), other.numberOfAssociatedResourceConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceNetworkSummary").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("NumberOfAssociatedVPCs", numberOfAssociatedVPCs())
                .add("NumberOfAssociatedServices", numberOfAssociatedServices())
                .add("NumberOfAssociatedResourceConfigurations", numberOfAssociatedResourceConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "numberOfAssociatedVPCs":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedVPCs()));
        case "numberOfAssociatedServices":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedServices()));
        case "numberOfAssociatedResourceConfigurations":
            return Optional.ofNullable(clazz.cast(numberOfAssociatedResourceConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("numberOfAssociatedVPCs", NUMBER_OF_ASSOCIATED_VP_CS_FIELD);
        map.put("numberOfAssociatedServices", NUMBER_OF_ASSOCIATED_SERVICES_FIELD);
        map.put("numberOfAssociatedResourceConfigurations", NUMBER_OF_ASSOCIATED_RESOURCE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceNetworkSummary, T> g) {
        return obj -> g.apply((ServiceNetworkSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceNetworkSummary> {
        /**
         * <p>
         * The ID of the service network.
         * </p>
         * 
         * @param id
         *        The ID of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the service network.
         * </p>
         * 
         * @param name
         *        The name of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the service network was created, in ISO-8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the service network was created, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time that the service network was last updated, in ISO-8601 format.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The date and time that the service network was last updated, in ISO-8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The number of VPCs associated with the service network.
         * </p>
         * 
         * @param numberOfAssociatedVPCs
         *        The number of VPCs associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedVPCs(Long numberOfAssociatedVPCs);

        /**
         * <p>
         * The number of services associated with the service network.
         * </p>
         * 
         * @param numberOfAssociatedServices
         *        The number of services associated with the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedServices(Long numberOfAssociatedServices);

        /**
         * <p>
         * The number of resource configurations associated with a service network.
         * </p>
         * 
         * @param numberOfAssociatedResourceConfigurations
         *        The number of resource configurations associated with a service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAssociatedResourceConfigurations(Long numberOfAssociatedResourceConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Long numberOfAssociatedVPCs;

        private Long numberOfAssociatedServices;

        private Long numberOfAssociatedResourceConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceNetworkSummary model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            numberOfAssociatedVPCs(model.numberOfAssociatedVPCs);
            numberOfAssociatedServices(model.numberOfAssociatedServices);
            numberOfAssociatedResourceConfigurations(model.numberOfAssociatedResourceConfigurations);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Long getNumberOfAssociatedVPCs() {
            return numberOfAssociatedVPCs;
        }

        public final void setNumberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
        }

        @Override
        public final Builder numberOfAssociatedVPCs(Long numberOfAssociatedVPCs) {
            this.numberOfAssociatedVPCs = numberOfAssociatedVPCs;
            return this;
        }

        public final Long getNumberOfAssociatedServices() {
            return numberOfAssociatedServices;
        }

        public final void setNumberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
        }

        @Override
        public final Builder numberOfAssociatedServices(Long numberOfAssociatedServices) {
            this.numberOfAssociatedServices = numberOfAssociatedServices;
            return this;
        }

        public final Long getNumberOfAssociatedResourceConfigurations() {
            return numberOfAssociatedResourceConfigurations;
        }

        public final void setNumberOfAssociatedResourceConfigurations(Long numberOfAssociatedResourceConfigurations) {
            this.numberOfAssociatedResourceConfigurations = numberOfAssociatedResourceConfigurations;
        }

        @Override
        public final Builder numberOfAssociatedResourceConfigurations(Long numberOfAssociatedResourceConfigurations) {
            this.numberOfAssociatedResourceConfigurations = numberOfAssociatedResourceConfigurations;
            return this;
        }

        @Override
        public ServiceNetworkSummary build() {
            return new ServiceNetworkSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
