/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDomainVerificationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<StartDomainVerificationResponse.Builder, StartDomainVerificationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartDomainVerificationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StartDomainVerificationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(StartDomainVerificationResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartDomainVerificationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<TxtMethodConfig> TXT_METHOD_CONFIG_FIELD = SdkField
            .<TxtMethodConfig> builder(MarshallingType.SDK_POJO).memberName("txtMethodConfig")
            .getter(getter(StartDomainVerificationResponse::txtMethodConfig)).setter(setter(Builder::txtMethodConfig))
            .constructor(TxtMethodConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("txtMethodConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            DOMAIN_NAME_FIELD, STATUS_FIELD, TXT_METHOD_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String domainName;

    private final String status;

    private final TxtMethodConfig txtMethodConfig;

    private StartDomainVerificationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.domainName = builder.domainName;
        this.status = builder.status;
        this.txtMethodConfig = builder.txtMethodConfig;
    }

    /**
     * <p>
     * The ID of the domain verification.
     * </p>
     * 
     * @return The ID of the domain verification.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the domain verification.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the domain verification.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The domain name being verified.
     * </p>
     * 
     * @return The domain name being verified.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The current status of the domain verification process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the domain verification process.
     * @see VerificationStatus
     */
    public final VerificationStatus status() {
        return VerificationStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the domain verification process.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VerificationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the domain verification process.
     * @see VerificationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The TXT record configuration used for domain verification.
     * </p>
     * 
     * @return The TXT record configuration used for domain verification.
     */
    public final TxtMethodConfig txtMethodConfig() {
        return txtMethodConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(txtMethodConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDomainVerificationResponse)) {
            return false;
        }
        StartDomainVerificationResponse other = (StartDomainVerificationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(txtMethodConfig(), other.txtMethodConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDomainVerificationResponse").add("Id", id()).add("Arn", arn())
                .add("DomainName", domainName()).add("Status", statusAsString()).add("TxtMethodConfig", txtMethodConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "txtMethodConfig":
            return Optional.ofNullable(clazz.cast(txtMethodConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("txtMethodConfig", TXT_METHOD_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDomainVerificationResponse, T> g) {
        return obj -> g.apply((StartDomainVerificationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDomainVerificationResponse> {
        /**
         * <p>
         * The ID of the domain verification.
         * </p>
         * 
         * @param id
         *        The ID of the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the domain verification.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The domain name being verified.
         * </p>
         * 
         * @param domainName
         *        The domain name being verified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The current status of the domain verification process.
         * </p>
         * 
         * @param status
         *        The current status of the domain verification process.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the domain verification process.
         * </p>
         * 
         * @param status
         *        The current status of the domain verification process.
         * @see VerificationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationStatus
         */
        Builder status(VerificationStatus status);

        /**
         * <p>
         * The TXT record configuration used for domain verification.
         * </p>
         * 
         * @param txtMethodConfig
         *        The TXT record configuration used for domain verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder txtMethodConfig(TxtMethodConfig txtMethodConfig);

        /**
         * <p>
         * The TXT record configuration used for domain verification.
         * </p>
         * This is a convenience method that creates an instance of the {@link TxtMethodConfig.Builder} avoiding the
         * need to create one manually via {@link TxtMethodConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TxtMethodConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #txtMethodConfig(TxtMethodConfig)}.
         * 
         * @param txtMethodConfig
         *        a consumer that will call methods on {@link TxtMethodConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #txtMethodConfig(TxtMethodConfig)
         */
        default Builder txtMethodConfig(Consumer<TxtMethodConfig.Builder> txtMethodConfig) {
            return txtMethodConfig(TxtMethodConfig.builder().applyMutation(txtMethodConfig).build());
        }
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String domainName;

        private String status;

        private TxtMethodConfig txtMethodConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDomainVerificationResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            domainName(model.domainName);
            status(model.status);
            txtMethodConfig(model.txtMethodConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VerificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final TxtMethodConfig.Builder getTxtMethodConfig() {
            return txtMethodConfig != null ? txtMethodConfig.toBuilder() : null;
        }

        public final void setTxtMethodConfig(TxtMethodConfig.BuilderImpl txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig != null ? txtMethodConfig.build() : null;
        }

        @Override
        public final Builder txtMethodConfig(TxtMethodConfig txtMethodConfig) {
            this.txtMethodConfig = txtMethodConfig;
            return this;
        }

        @Override
        public StartDomainVerificationResponse build() {
            return new StartDomainVerificationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
