/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceConfigurationResponse extends VpcLatticeResponse implements
        ToCopyableBuilder<UpdateResourceConfigurationResponse.Builder, UpdateResourceConfigurationResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateResourceConfigurationResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateResourceConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateResourceConfigurationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayId").getter(getter(UpdateResourceConfigurationResponse::resourceGatewayId))
            .setter(setter(Builder::resourceGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayId").build()).build();

    private static final SdkField<String> RESOURCE_CONFIGURATION_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceConfigurationGroupId")
            .getter(getter(UpdateResourceConfigurationResponse::resourceConfigurationGroupId))
            .setter(setter(Builder::resourceConfigurationGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationGroupId")
                    .build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateResourceConfigurationResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> PORT_RANGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("portRanges")
            .getter(getter(UpdateResourceConfigurationResponse::portRanges))
            .setter(setter(Builder::portRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowAssociationToShareableServiceNetwork")
            .getter(getter(UpdateResourceConfigurationResponse::allowAssociationToShareableServiceNetwork))
            .setter(setter(Builder::allowAssociationToShareableServiceNetwork))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("allowAssociationToShareableServiceNetwork").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(UpdateResourceConfigurationResponse::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateResourceConfigurationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ResourceConfigurationDefinition> RESOURCE_CONFIGURATION_DEFINITION_FIELD = SdkField
            .<ResourceConfigurationDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("resourceConfigurationDefinition")
            .getter(getter(UpdateResourceConfigurationResponse::resourceConfigurationDefinition))
            .setter(setter(Builder::resourceConfigurationDefinition))
            .constructor(ResourceConfigurationDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationDefinition")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, RESOURCE_GATEWAY_ID_FIELD, RESOURCE_CONFIGURATION_GROUP_ID_FIELD, TYPE_FIELD, PORT_RANGES_FIELD,
            ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD, PROTOCOL_FIELD, STATUS_FIELD,
            RESOURCE_CONFIGURATION_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final String resourceGatewayId;

    private final String resourceConfigurationGroupId;

    private final String type;

    private final List<String> portRanges;

    private final Boolean allowAssociationToShareableServiceNetwork;

    private final String protocol;

    private final String status;

    private final ResourceConfigurationDefinition resourceConfigurationDefinition;

    private UpdateResourceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.resourceGatewayId = builder.resourceGatewayId;
        this.resourceConfigurationGroupId = builder.resourceConfigurationGroupId;
        this.type = builder.type;
        this.portRanges = builder.portRanges;
        this.allowAssociationToShareableServiceNetwork = builder.allowAssociationToShareableServiceNetwork;
        this.protocol = builder.protocol;
        this.status = builder.status;
        this.resourceConfigurationDefinition = builder.resourceConfigurationDefinition;
    }

    /**
     * <p>
     * The ID of the resource configuration.
     * </p>
     * 
     * @return The ID of the resource configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the resource configuration.
     * </p>
     * 
     * @return The name of the resource configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the resource gateway associated with the resource configuration.
     * </p>
     * 
     * @return The ID of the resource gateway associated with the resource configuration.
     */
    public final String resourceGatewayId() {
        return resourceGatewayId;
    }

    /**
     * <p>
     * The ID of the group resource configuration.
     * </p>
     * 
     * @return The ID of the group resource configuration.
     */
    public final String resourceConfigurationGroupId() {
        return resourceConfigurationGroupId;
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final ResourceConfigurationType type() {
        return ResourceConfigurationType.fromValue(type);
    }

    /**
     * <p>
     * The type of resource configuration.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SINGLE</code> - A single resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GROUP</code> - A group of resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CHILD</code> - A single resource that is part of a group resource configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ARN</code> - An Amazon Web Services resource.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceConfigurationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of resource configuration.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SINGLE</code> - A single resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GROUP</code> - A group of resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CHILD</code> - A single resource that is part of a group resource configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ARN</code> - An Amazon Web Services resource.
     *         </p>
     *         </li>
     * @see ResourceConfigurationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPortRanges() {
        return portRanges != null && !(portRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges with
     * a comma. Example: 1-65535 or 1,2,22-30
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortRanges} method.
     * </p>
     * 
     * @return The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
     *         ranges with a comma. Example: 1-65535 or 1,2,22-30
     */
    public final List<String> portRanges() {
        return portRanges;
    }

    /**
     * <p>
     * Indicates whether to add the resource configuration to service networks that are shared with other accounts.
     * </p>
     * 
     * @return Indicates whether to add the resource configuration to service networks that are shared with other
     *         accounts.
     */
    public final Boolean allowAssociationToShareableServiceNetwork() {
        return allowAssociationToShareableServiceNetwork;
    }

    /**
     * <p>
     * The TCP protocol accepted by the specified resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The TCP protocol accepted by the specified resource configuration.
     * @see ProtocolType
     */
    public final ProtocolType protocol() {
        return ProtocolType.fromValue(protocol);
    }

    /**
     * <p>
     * The TCP protocol accepted by the specified resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The TCP protocol accepted by the specified resource configuration.
     * @see ProtocolType
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final ResourceConfigurationStatus status() {
        return ResourceConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the resource configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the resource configuration.
     * @see ResourceConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The resource configuration.
     * </p>
     * 
     * @return The resource configuration.
     */
    public final ResourceConfigurationDefinition resourceConfigurationDefinition() {
        return resourceConfigurationDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortRanges() ? portRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowAssociationToShareableServiceNetwork());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceConfigurationDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceConfigurationResponse)) {
            return false;
        }
        UpdateResourceConfigurationResponse other = (UpdateResourceConfigurationResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(resourceGatewayId(), other.resourceGatewayId())
                && Objects.equals(resourceConfigurationGroupId(), other.resourceConfigurationGroupId())
                && Objects.equals(typeAsString(), other.typeAsString()) && hasPortRanges() == other.hasPortRanges()
                && Objects.equals(portRanges(), other.portRanges())
                && Objects.equals(allowAssociationToShareableServiceNetwork(), other.allowAssociationToShareableServiceNetwork())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resourceConfigurationDefinition(), other.resourceConfigurationDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceConfigurationResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("ResourceGatewayId", resourceGatewayId())
                .add("ResourceConfigurationGroupId", resourceConfigurationGroupId()).add("Type", typeAsString())
                .add("PortRanges", hasPortRanges() ? portRanges() : null)
                .add("AllowAssociationToShareableServiceNetwork", allowAssociationToShareableServiceNetwork())
                .add("Protocol", protocolAsString()).add("Status", statusAsString())
                .add("ResourceConfigurationDefinition", resourceConfigurationDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "resourceGatewayId":
            return Optional.ofNullable(clazz.cast(resourceGatewayId()));
        case "resourceConfigurationGroupId":
            return Optional.ofNullable(clazz.cast(resourceConfigurationGroupId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "portRanges":
            return Optional.ofNullable(clazz.cast(portRanges()));
        case "allowAssociationToShareableServiceNetwork":
            return Optional.ofNullable(clazz.cast(allowAssociationToShareableServiceNetwork()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "resourceConfigurationDefinition":
            return Optional.ofNullable(clazz.cast(resourceConfigurationDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("resourceGatewayId", RESOURCE_GATEWAY_ID_FIELD);
        map.put("resourceConfigurationGroupId", RESOURCE_CONFIGURATION_GROUP_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("portRanges", PORT_RANGES_FIELD);
        map.put("allowAssociationToShareableServiceNetwork", ALLOW_ASSOCIATION_TO_SHAREABLE_SERVICE_NETWORK_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("resourceConfigurationDefinition", RESOURCE_CONFIGURATION_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateResourceConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateResourceConfigurationResponse> {
        /**
         * <p>
         * The ID of the resource configuration.
         * </p>
         * 
         * @param id
         *        The ID of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the resource configuration.
         * </p>
         * 
         * @param name
         *        The name of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource configuration.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the resource gateway associated with the resource configuration.
         * </p>
         * 
         * @param resourceGatewayId
         *        The ID of the resource gateway associated with the resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayId(String resourceGatewayId);

        /**
         * <p>
         * The ID of the group resource configuration.
         * </p>
         * 
         * @param resourceConfigurationGroupId
         *        The ID of the group resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationGroupId(String resourceConfigurationGroupId);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of resource configuration.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SINGLE</code> - A single resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GROUP</code> - A group of resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CHILD</code> - A single resource that is part of a group resource configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ARN</code> - An Amazon Web Services resource.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of resource configuration.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SINGLE</code> - A single resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GROUP</code> - A group of resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CHILD</code> - A single resource that is part of a group resource configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ARN</code> - An Amazon Web Services resource.
         *        </p>
         *        </li>
         * @see ResourceConfigurationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationType
         */
        Builder type(ResourceConfigurationType type);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(Collection<String> portRanges);

        /**
         * <p>
         * The TCP port ranges that a consumer can use to access a resource configuration. You can separate port ranges
         * with a comma. Example: 1-65535 or 1,2,22-30
         * </p>
         * 
         * @param portRanges
         *        The TCP port ranges that a consumer can use to access a resource configuration. You can separate port
         *        ranges with a comma. Example: 1-65535 or 1,2,22-30
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portRanges(String... portRanges);

        /**
         * <p>
         * Indicates whether to add the resource configuration to service networks that are shared with other accounts.
         * </p>
         * 
         * @param allowAssociationToShareableServiceNetwork
         *        Indicates whether to add the resource configuration to service networks that are shared with other
         *        accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork);

        /**
         * <p>
         * The TCP protocol accepted by the specified resource configuration.
         * </p>
         * 
         * @param protocol
         *        The TCP protocol accepted by the specified resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The TCP protocol accepted by the specified resource configuration.
         * </p>
         * 
         * @param protocol
         *        The TCP protocol accepted by the specified resource configuration.
         * @see ProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolType
         */
        Builder protocol(ProtocolType protocol);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the resource configuration.
         * </p>
         * 
         * @param status
         *        The status of the resource configuration.
         * @see ResourceConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceConfigurationStatus
         */
        Builder status(ResourceConfigurationStatus status);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * 
         * @param resourceConfigurationDefinition
         *        The resource configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition);

        /**
         * <p>
         * The resource configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceConfigurationDefinition.Builder}
         * avoiding the need to create one manually via {@link ResourceConfigurationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceConfigurationDefinition.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #resourceConfigurationDefinition(ResourceConfigurationDefinition)}.
         * 
         * @param resourceConfigurationDefinition
         *        a consumer that will call methods on {@link ResourceConfigurationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceConfigurationDefinition(ResourceConfigurationDefinition)
         */
        default Builder resourceConfigurationDefinition(
                Consumer<ResourceConfigurationDefinition.Builder> resourceConfigurationDefinition) {
            return resourceConfigurationDefinition(ResourceConfigurationDefinition.builder()
                    .applyMutation(resourceConfigurationDefinition).build());
        }
    }

    static final class BuilderImpl extends VpcLatticeResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String resourceGatewayId;

        private String resourceConfigurationGroupId;

        private String type;

        private List<String> portRanges = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowAssociationToShareableServiceNetwork;

        private String protocol;

        private String status;

        private ResourceConfigurationDefinition resourceConfigurationDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceConfigurationResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            resourceGatewayId(model.resourceGatewayId);
            resourceConfigurationGroupId(model.resourceConfigurationGroupId);
            type(model.type);
            portRanges(model.portRanges);
            allowAssociationToShareableServiceNetwork(model.allowAssociationToShareableServiceNetwork);
            protocol(model.protocol);
            status(model.status);
            resourceConfigurationDefinition(model.resourceConfigurationDefinition);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getResourceGatewayId() {
            return resourceGatewayId;
        }

        public final void setResourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
        }

        @Override
        public final Builder resourceGatewayId(String resourceGatewayId) {
            this.resourceGatewayId = resourceGatewayId;
            return this;
        }

        public final String getResourceConfigurationGroupId() {
            return resourceConfigurationGroupId;
        }

        public final void setResourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
        }

        @Override
        public final Builder resourceConfigurationGroupId(String resourceConfigurationGroupId) {
            this.resourceConfigurationGroupId = resourceConfigurationGroupId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceConfigurationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPortRanges() {
            if (portRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return portRanges;
        }

        public final void setPortRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
        }

        @Override
        public final Builder portRanges(Collection<String> portRanges) {
            this.portRanges = PortRangeListCopier.copy(portRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portRanges(String... portRanges) {
            portRanges(Arrays.asList(portRanges));
            return this;
        }

        public final Boolean getAllowAssociationToShareableServiceNetwork() {
            return allowAssociationToShareableServiceNetwork;
        }

        public final void setAllowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
        }

        @Override
        public final Builder allowAssociationToShareableServiceNetwork(Boolean allowAssociationToShareableServiceNetwork) {
            this.allowAssociationToShareableServiceNetwork = allowAssociationToShareableServiceNetwork;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ResourceConfigurationDefinition.Builder getResourceConfigurationDefinition() {
            return resourceConfigurationDefinition != null ? resourceConfigurationDefinition.toBuilder() : null;
        }

        public final void setResourceConfigurationDefinition(
                ResourceConfigurationDefinition.BuilderImpl resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition != null ? resourceConfigurationDefinition
                    .build() : null;
        }

        @Override
        public final Builder resourceConfigurationDefinition(ResourceConfigurationDefinition resourceConfigurationDefinition) {
            this.resourceConfigurationDefinition = resourceConfigurationDefinition;
            return this;
        }

        @Override
        public UpdateResourceConfigurationResponse build() {
            return new UpdateResourceConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
