/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceRequest extends VpcLatticeRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private static final SdkField<String> SERVICE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceIdentifier").getter(getter(UpdateServiceRequest::serviceIdentifier))
            .setter(setter(Builder::serviceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("serviceIdentifier").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(UpdateServiceRequest::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authType").getter(getter(UpdateServiceRequest::authTypeAsString)).setter(setter(Builder::authType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_IDENTIFIER_FIELD,
            CERTIFICATE_ARN_FIELD, AUTH_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String serviceIdentifier;

    private final String certificateArn;

    private final String authType;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.serviceIdentifier = builder.serviceIdentifier;
        this.certificateArn = builder.certificateArn;
        this.authType = builder.authType;
    }

    /**
     * <p>
     * The ID or ARN of the service.
     * </p>
     * 
     * @return The ID or ARN of the service.
     */
    public final String serviceIdentifier() {
        return serviceIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy
     * is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
     *         auth policy is required.
     *         </p>
     *         </li>
     * @see AuthType
     */
    public final AuthType authType() {
        return AuthType.fromValue(authType);
    }

    /**
     * <p>
     * The type of IAM policy.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy
     * is required.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authType} will
     * return {@link AuthType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authTypeAsString}.
     * </p>
     * 
     * @return The type of IAM policy.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: The resource does not use an IAM policy. This is the default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
     *         auth policy is required.
     *         </p>
     *         </li>
     * @see AuthType
     */
    public final String authTypeAsString() {
        return authType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(authTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(serviceIdentifier(), other.serviceIdentifier())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(authTypeAsString(), other.authTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateServiceRequest").add("ServiceIdentifier", serviceIdentifier())
                .add("CertificateArn", certificateArn()).add("AuthType", authTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceIdentifier":
            return Optional.ofNullable(clazz.cast(serviceIdentifier()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "authType":
            return Optional.ofNullable(clazz.cast(authTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceIdentifier", SERVICE_IDENTIFIER_FIELD);
        map.put("certificateArn", CERTIFICATE_ARN_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceRequest, T> g) {
        return obj -> g.apply((UpdateServiceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends VpcLatticeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The ID or ARN of the service.
         * </p>
         * 
         * @param serviceIdentifier
         *        The ID or ARN of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceIdentifier(String serviceIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth
         * policy is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authType
         *        The type of IAM policy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
         *        auth policy is required.
         *        </p>
         *        </li>
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(String authType);

        /**
         * <p>
         * The type of IAM policy.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an auth
         * policy is required.
         * </p>
         * </li>
         * </ul>
         * 
         * @param authType
         *        The type of IAM policy.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: The resource does not use an IAM policy. This is the default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS_IAM</code>: The resource uses an IAM policy. When this type is used, auth is enabled and an
         *        auth policy is required.
         *        </p>
         *        </li>
         * @see AuthType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthType
         */
        Builder authType(AuthType authType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VpcLatticeRequest.BuilderImpl implements Builder {
        private String serviceIdentifier;

        private String certificateArn;

        private String authType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            super(model);
            serviceIdentifier(model.serviceIdentifier);
            certificateArn(model.certificateArn);
            authType(model.authType);
        }

        public final String getServiceIdentifier() {
            return serviceIdentifier;
        }

        public final void setServiceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
        }

        @Override
        public final Builder serviceIdentifier(String serviceIdentifier) {
            this.serviceIdentifier = serviceIdentifier;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAuthType() {
            return authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
