/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.vpclattice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the weight of a target group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeightedTargetGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<WeightedTargetGroup.Builder, WeightedTargetGroup> {
    private static final SdkField<String> TARGET_GROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetGroupIdentifier").getter(getter(WeightedTargetGroup::targetGroupIdentifier))
            .setter(setter(Builder::targetGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupIdentifier").build())
            .build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("weight").getter(getter(WeightedTargetGroup::weight)).setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUP_IDENTIFIER_FIELD,
            WEIGHT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetGroupIdentifier;

    private final Integer weight;

    private WeightedTargetGroup(BuilderImpl builder) {
        this.targetGroupIdentifier = builder.targetGroupIdentifier;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The ID or ARN of the target group.
     * </p>
     * 
     * @return The ID or ARN of the target group.
     */
    public final String targetGroupIdentifier() {
        return targetGroupIdentifier;
    }

    /**
     * <p>
     * Only required if you specify multiple target groups for a forward action. The weight determines how requests are
     * distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each
     * target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other
     * with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target
     * group. If there's only one target group specified, then the default value is 100.
     * </p>
     * 
     * @return Only required if you specify multiple target groups for a forward action. The weight determines how
     *         requests are distributed to the target group. For example, if you specify two target groups, each with a
     *         weight of 10, each target group receives half the requests. If you specify two target groups, one with a
     *         weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as
     *         many requests as the other target group. If there's only one target group specified, then the default
     *         value is 100.
     */
    public final Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeightedTargetGroup)) {
            return false;
        }
        WeightedTargetGroup other = (WeightedTargetGroup) obj;
        return Objects.equals(targetGroupIdentifier(), other.targetGroupIdentifier()) && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeightedTargetGroup").add("TargetGroupIdentifier", targetGroupIdentifier())
                .add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetGroupIdentifier":
            return Optional.ofNullable(clazz.cast(targetGroupIdentifier()));
        case "weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetGroupIdentifier", TARGET_GROUP_IDENTIFIER_FIELD);
        map.put("weight", WEIGHT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WeightedTargetGroup, T> g) {
        return obj -> g.apply((WeightedTargetGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeightedTargetGroup> {
        /**
         * <p>
         * The ID or ARN of the target group.
         * </p>
         * 
         * @param targetGroupIdentifier
         *        The ID or ARN of the target group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupIdentifier(String targetGroupIdentifier);

        /**
         * <p>
         * Only required if you specify multiple target groups for a forward action. The weight determines how requests
         * are distributed to the target group. For example, if you specify two target groups, each with a weight of 10,
         * each target group receives half the requests. If you specify two target groups, one with a weight of 10 and
         * the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the
         * other target group. If there's only one target group specified, then the default value is 100.
         * </p>
         * 
         * @param weight
         *        Only required if you specify multiple target groups for a forward action. The weight determines how
         *        requests are distributed to the target group. For example, if you specify two target groups, each with
         *        a weight of 10, each target group receives half the requests. If you specify two target groups, one
         *        with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives
         *        twice as many requests as the other target group. If there's only one target group specified, then the
         *        default value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private String targetGroupIdentifier;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(WeightedTargetGroup model) {
            targetGroupIdentifier(model.targetGroupIdentifier);
            weight(model.weight);
        }

        public final String getTargetGroupIdentifier() {
            return targetGroupIdentifier;
        }

        public final void setTargetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
        }

        @Override
        public final Builder targetGroupIdentifier(String targetGroupIdentifier) {
            this.targetGroupIdentifier = targetGroupIdentifier;
            return this;
        }

        public final Integer getWeight() {
            return weight;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public WeightedTargetGroup build() {
            return new WeightedTargetGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
