/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.waf.model.SizeConstraint;
import software.amazon.awssdk.services.waf.model.SizeConstraintsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SizeConstraintSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SizeConstraintSet> {
    private static final SdkField<String> SIZE_CONSTRAINT_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizeConstraintSetId").getter(SizeConstraintSet.getter(SizeConstraintSet::sizeConstraintSetId)).setter(SizeConstraintSet.setter(Builder::sizeConstraintSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraintSetId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SizeConstraintSet.getter(SizeConstraintSet::name)).setter(SizeConstraintSet.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<SizeConstraint>> SIZE_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SizeConstraints").getter(SizeConstraintSet.getter(SizeConstraintSet::sizeConstraints)).setter(SizeConstraintSet.setter(Builder::sizeConstraints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeConstraints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SizeConstraint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIZE_CONSTRAINT_SET_ID_FIELD, NAME_FIELD, SIZE_CONSTRAINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sizeConstraintSetId;
    private final String name;
    private final List<SizeConstraint> sizeConstraints;

    private SizeConstraintSet(BuilderImpl builder) {
        this.sizeConstraintSetId = builder.sizeConstraintSetId;
        this.name = builder.name;
        this.sizeConstraints = builder.sizeConstraints;
    }

    public final String sizeConstraintSetId() {
        return this.sizeConstraintSetId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasSizeConstraints() {
        return this.sizeConstraints != null && !(this.sizeConstraints instanceof SdkAutoConstructList);
    }

    public final List<SizeConstraint> sizeConstraints() {
        return this.sizeConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeConstraintSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSizeConstraints() ? this.sizeConstraints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SizeConstraintSet)) {
            return false;
        }
        SizeConstraintSet other = (SizeConstraintSet)obj;
        return Objects.equals(this.sizeConstraintSetId(), other.sizeConstraintSetId()) && Objects.equals(this.name(), other.name()) && this.hasSizeConstraints() == other.hasSizeConstraints() && Objects.equals(this.sizeConstraints(), other.sizeConstraints());
    }

    public final String toString() {
        return ToString.builder((String)"SizeConstraintSet").add("SizeConstraintSetId", (Object)this.sizeConstraintSetId()).add("Name", (Object)this.name()).add("SizeConstraints", this.hasSizeConstraints() ? this.sizeConstraints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SizeConstraintSetId": {
                return Optional.ofNullable(clazz.cast(this.sizeConstraintSetId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SizeConstraints": {
                return Optional.ofNullable(clazz.cast(this.sizeConstraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SizeConstraintSet, T> g) {
        return obj -> g.apply((SizeConstraintSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sizeConstraintSetId;
        private String name;
        private List<SizeConstraint> sizeConstraints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SizeConstraintSet model) {
            this.sizeConstraintSetId(model.sizeConstraintSetId);
            this.name(model.name);
            this.sizeConstraints(model.sizeConstraints);
        }

        public final String getSizeConstraintSetId() {
            return this.sizeConstraintSetId;
        }

        @Override
        public final Builder sizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
            return this;
        }

        public final void setSizeConstraintSetId(String sizeConstraintSetId) {
            this.sizeConstraintSetId = sizeConstraintSetId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<SizeConstraint.Builder> getSizeConstraints() {
            if (this.sizeConstraints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sizeConstraints != null ? (Collection)this.sizeConstraints.stream().map(SizeConstraint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sizeConstraints(Collection<SizeConstraint> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copy(sizeConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(SizeConstraint ... sizeConstraints) {
            this.sizeConstraints(Arrays.asList(sizeConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeConstraints(Consumer<SizeConstraint.Builder> ... sizeConstraints) {
            this.sizeConstraints(Stream.of(sizeConstraints).map(c -> (SizeConstraint)((SizeConstraint.Builder)SizeConstraint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSizeConstraints(Collection<SizeConstraint.BuilderImpl> sizeConstraints) {
            this.sizeConstraints = SizeConstraintsCopier.copyFromBuilder(sizeConstraints);
        }

        public SizeConstraintSet build() {
            return new SizeConstraintSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SizeConstraintSet> {
        public Builder sizeConstraintSetId(String var1);

        public Builder name(String var1);

        public Builder sizeConstraints(Collection<SizeConstraint> var1);

        public Builder sizeConstraints(SizeConstraint ... var1);

        public Builder sizeConstraints(Consumer<SizeConstraint.Builder> ... var1);
    }
}

