/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This is <b>AWS WAF Classic</b> documentation. For more information, see <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the
 * developer guide.
 * </p>
 * <p>
 * <b>For the latest version of AWS WAF</b>, use the AWS WAFV2 API and see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a>. With the
 * latest version, AWS WAF has a single set of endpoints for regional and global use.
 * </p>
 * </note>
 * <p>
 * Specifies the part of a web request that you want to inspect for snippets of malicious SQL code and indicates whether
 * you want to add the specification to a <a>SqlInjectionMatchSet</a> or delete it from a
 * <code>SqlInjectionMatchSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SqlInjectionMatchSetUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<SqlInjectionMatchSetUpdate.Builder, SqlInjectionMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(SqlInjectionMatchSetUpdate::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<SqlInjectionMatchTuple> SQL_INJECTION_MATCH_TUPLE_FIELD = SdkField
            .<SqlInjectionMatchTuple> builder(MarshallingType.SDK_POJO).memberName("SqlInjectionMatchTuple")
            .getter(getter(SqlInjectionMatchSetUpdate::sqlInjectionMatchTuple)).setter(setter(Builder::sqlInjectionMatchTuple))
            .constructor(SqlInjectionMatchTuple::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqlInjectionMatchTuple").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            SQL_INJECTION_MATCH_TUPLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String action;

    private final SqlInjectionMatchTuple sqlInjectionMatchTuple;

    private SqlInjectionMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.sqlInjectionMatchTuple = builder.sqlInjectionMatchTuple;
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>. Use
     * <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>.
     *         Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a
     *         <code>SqlInjectionMatchSet</code>.
     * @see ChangeAction
     */
    public final ChangeAction action() {
        return ChangeAction.fromValue(action);
    }

    /**
     * <p>
     * Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>. Use
     * <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ChangeAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>.
     *         Use <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a
     *         <code>SqlInjectionMatchSet</code>.
     * @see ChangeAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and, if
     * you want AWS WAF to inspect a header, the name of the header.
     * </p>
     * 
     * @return Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code
     *         and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public final SqlInjectionMatchTuple sqlInjectionMatchTuple() {
        return sqlInjectionMatchTuple;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sqlInjectionMatchTuple());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SqlInjectionMatchSetUpdate)) {
            return false;
        }
        SqlInjectionMatchSetUpdate other = (SqlInjectionMatchSetUpdate) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(sqlInjectionMatchTuple(), other.sqlInjectionMatchTuple());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SqlInjectionMatchSetUpdate").add("Action", actionAsString())
                .add("SqlInjectionMatchTuple", sqlInjectionMatchTuple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "SqlInjectionMatchTuple":
            return Optional.ofNullable(clazz.cast(sqlInjectionMatchTuple()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SqlInjectionMatchSetUpdate, T> g) {
        return obj -> g.apply((SqlInjectionMatchSetUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SqlInjectionMatchSetUpdate> {
        /**
         * <p>
         * Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>. Use
         * <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a
         * <code>SqlInjectionMatchSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a
         *        <a>SqlInjectionMatchSet</a>. Use <code>DELETE</code> to remove a
         *        <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(String action);

        /**
         * <p>
         * Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a <a>SqlInjectionMatchSet</a>. Use
         * <code>DELETE</code> to remove a <code>SqlInjectionMatchSetUpdate</code> from a
         * <code>SqlInjectionMatchSet</code>.
         * </p>
         * 
         * @param action
         *        Specify <code>INSERT</code> to add a <a>SqlInjectionMatchSetUpdate</a> to a
         *        <a>SqlInjectionMatchSet</a>. Use <code>DELETE</code> to remove a
         *        <code>SqlInjectionMatchSetUpdate</code> from a <code>SqlInjectionMatchSet</code>.
         * @see ChangeAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeAction
         */
        Builder action(ChangeAction action);

        /**
         * <p>
         * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and,
         * if you want AWS WAF to inspect a header, the name of the header.
         * </p>
         * 
         * @param sqlInjectionMatchTuple
         *        Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL
         *        code and, if you want AWS WAF to inspect a header, the name of the header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple sqlInjectionMatchTuple);

        /**
         * <p>
         * Specifies the part of a web request that you want AWS WAF to inspect for snippets of malicious SQL code and,
         * if you want AWS WAF to inspect a header, the name of the header.
         * </p>
         * This is a convenience that creates an instance of the {@link SqlInjectionMatchTuple.Builder} avoiding the
         * need to create one manually via {@link SqlInjectionMatchTuple#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqlInjectionMatchTuple.Builder#build()} is called immediately and
         * its result is passed to {@link #sqlInjectionMatchTuple(SqlInjectionMatchTuple)}.
         * 
         * @param sqlInjectionMatchTuple
         *        a consumer that will call methods on {@link SqlInjectionMatchTuple.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlInjectionMatchTuple(SqlInjectionMatchTuple)
         */
        default Builder sqlInjectionMatchTuple(Consumer<SqlInjectionMatchTuple.Builder> sqlInjectionMatchTuple) {
            return sqlInjectionMatchTuple(SqlInjectionMatchTuple.builder().applyMutation(sqlInjectionMatchTuple).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private SqlInjectionMatchTuple sqlInjectionMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(SqlInjectionMatchSetUpdate model) {
            action(model.action);
            sqlInjectionMatchTuple(model.sqlInjectionMatchTuple);
        }

        public final String getAction() {
            return action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final SqlInjectionMatchTuple.Builder getSqlInjectionMatchTuple() {
            return sqlInjectionMatchTuple != null ? sqlInjectionMatchTuple.toBuilder() : null;
        }

        @Override
        public final Builder sqlInjectionMatchTuple(SqlInjectionMatchTuple sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple;
            return this;
        }

        public final void setSqlInjectionMatchTuple(SqlInjectionMatchTuple.BuilderImpl sqlInjectionMatchTuple) {
            this.sqlInjectionMatchTuple = sqlInjectionMatchTuple != null ? sqlInjectionMatchTuple.build() : null;
        }

        @Override
        public SqlInjectionMatchSetUpdate build() {
            return new SqlInjectionMatchSetUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
