/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.FieldToMatch;
import software.amazon.awssdk.services.waf.model.PositionalConstraint;
import software.amazon.awssdk.services.waf.model.TextTransformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteMatchTuple
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteMatchTuple> {
    private static final SdkField<FieldToMatch> FIELD_TO_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldToMatch").getter(ByteMatchTuple.getter(ByteMatchTuple::fieldToMatch)).setter(ByteMatchTuple.setter(Builder::fieldToMatch)).constructor(FieldToMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldToMatch").build()}).build();
    private static final SdkField<SdkBytes> TARGET_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("TargetString").getter(ByteMatchTuple.getter(ByteMatchTuple::targetString)).setter(ByteMatchTuple.setter(Builder::targetString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetString").build()}).build();
    private static final SdkField<String> TEXT_TRANSFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TextTransformation").getter(ByteMatchTuple.getter(ByteMatchTuple::textTransformationAsString)).setter(ByteMatchTuple.setter(Builder::textTransformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTransformation").build()}).build();
    private static final SdkField<String> POSITIONAL_CONSTRAINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PositionalConstraint").getter(ByteMatchTuple.getter(ByteMatchTuple::positionalConstraintAsString)).setter(ByteMatchTuple.setter(Builder::positionalConstraint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PositionalConstraint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_TO_MATCH_FIELD, TARGET_STRING_FIELD, TEXT_TRANSFORMATION_FIELD, POSITIONAL_CONSTRAINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final FieldToMatch fieldToMatch;
    private final SdkBytes targetString;
    private final String textTransformation;
    private final String positionalConstraint;

    private ByteMatchTuple(BuilderImpl builder) {
        this.fieldToMatch = builder.fieldToMatch;
        this.targetString = builder.targetString;
        this.textTransformation = builder.textTransformation;
        this.positionalConstraint = builder.positionalConstraint;
    }

    public final FieldToMatch fieldToMatch() {
        return this.fieldToMatch;
    }

    public final SdkBytes targetString() {
        return this.targetString;
    }

    public final TextTransformation textTransformation() {
        return TextTransformation.fromValue(this.textTransformation);
    }

    public final String textTransformationAsString() {
        return this.textTransformation;
    }

    public final PositionalConstraint positionalConstraint() {
        return PositionalConstraint.fromValue(this.positionalConstraint);
    }

    public final String positionalConstraintAsString() {
        return this.positionalConstraint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldToMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetString());
        hashCode = 31 * hashCode + Objects.hashCode(this.textTransformationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.positionalConstraintAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchTuple)) {
            return false;
        }
        ByteMatchTuple other = (ByteMatchTuple)obj;
        return Objects.equals(this.fieldToMatch(), other.fieldToMatch()) && Objects.equals(this.targetString(), other.targetString()) && Objects.equals(this.textTransformationAsString(), other.textTransformationAsString()) && Objects.equals(this.positionalConstraintAsString(), other.positionalConstraintAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ByteMatchTuple").add("FieldToMatch", (Object)this.fieldToMatch()).add("TargetString", (Object)this.targetString()).add("TextTransformation", (Object)this.textTransformationAsString()).add("PositionalConstraint", (Object)this.positionalConstraintAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldToMatch": {
                return Optional.ofNullable(clazz.cast(this.fieldToMatch()));
            }
            case "TargetString": {
                return Optional.ofNullable(clazz.cast(this.targetString()));
            }
            case "TextTransformation": {
                return Optional.ofNullable(clazz.cast(this.textTransformationAsString()));
            }
            case "PositionalConstraint": {
                return Optional.ofNullable(clazz.cast(this.positionalConstraintAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchTuple, T> g) {
        return obj -> g.apply((ByteMatchTuple)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FieldToMatch fieldToMatch;
        private SdkBytes targetString;
        private String textTransformation;
        private String positionalConstraint;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchTuple model) {
            this.fieldToMatch(model.fieldToMatch);
            this.targetString(model.targetString);
            this.textTransformation(model.textTransformation);
            this.positionalConstraint(model.positionalConstraint);
        }

        public final FieldToMatch.Builder getFieldToMatch() {
            return this.fieldToMatch != null ? this.fieldToMatch.toBuilder() : null;
        }

        @Override
        public final Builder fieldToMatch(FieldToMatch fieldToMatch) {
            this.fieldToMatch = fieldToMatch;
            return this;
        }

        public final void setFieldToMatch(FieldToMatch.BuilderImpl fieldToMatch) {
            this.fieldToMatch = fieldToMatch != null ? fieldToMatch.build() : null;
        }

        public final ByteBuffer getTargetString() {
            return this.targetString == null ? null : this.targetString.asByteBuffer();
        }

        @Override
        public final Builder targetString(SdkBytes targetString) {
            this.targetString = targetString;
            return this;
        }

        public final void setTargetString(ByteBuffer targetString) {
            this.targetString(targetString == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)targetString));
        }

        public final String getTextTransformation() {
            return this.textTransformation;
        }

        @Override
        public final Builder textTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
            return this;
        }

        @Override
        public final Builder textTransformation(TextTransformation textTransformation) {
            this.textTransformation(textTransformation == null ? null : textTransformation.toString());
            return this;
        }

        public final void setTextTransformation(String textTransformation) {
            this.textTransformation = textTransformation;
        }

        public final String getPositionalConstraint() {
            return this.positionalConstraint;
        }

        @Override
        public final Builder positionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
            return this;
        }

        @Override
        public final Builder positionalConstraint(PositionalConstraint positionalConstraint) {
            this.positionalConstraint(positionalConstraint == null ? null : positionalConstraint.toString());
            return this;
        }

        public final void setPositionalConstraint(String positionalConstraint) {
            this.positionalConstraint = positionalConstraint;
        }

        public ByteMatchTuple build() {
            return new ByteMatchTuple(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteMatchTuple> {
        public Builder fieldToMatch(FieldToMatch var1);

        default public Builder fieldToMatch(Consumer<FieldToMatch.Builder> fieldToMatch) {
            return this.fieldToMatch((FieldToMatch)((FieldToMatch.Builder)FieldToMatch.builder().applyMutation(fieldToMatch)).build());
        }

        public Builder targetString(SdkBytes var1);

        public Builder textTransformation(String var1);

        public Builder textTransformation(TextTransformation var1);

        public Builder positionalConstraint(String var1);

        public Builder positionalConstraint(PositionalConstraint var1);
    }
}

