/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetByteMatchSetResponse extends WafResponse implements
        ToCopyableBuilder<GetByteMatchSetResponse.Builder, GetByteMatchSetResponse> {
    private static final SdkField<ByteMatchSet> BYTE_MATCH_SET_FIELD = SdkField.<ByteMatchSet> builder(MarshallingType.SDK_POJO)
            .memberName("ByteMatchSet").getter(getter(GetByteMatchSetResponse::byteMatchSet))
            .setter(setter(Builder::byteMatchSet)).constructor(ByteMatchSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_MATCH_SET_FIELD));

    private final ByteMatchSet byteMatchSet;

    private GetByteMatchSetResponse(BuilderImpl builder) {
        super(builder);
        this.byteMatchSet = builder.byteMatchSet;
    }

    /**
     * <p>
     * Information about the <a>ByteMatchSet</a> that you specified in the <code>GetByteMatchSet</code> request. For
     * more information, see the following topics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>ByteMatchSet</a>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ByteMatchTuples</code>: Contains an array of <a>ByteMatchTuple</a> objects. Each
     * <code>ByteMatchTuple</code> object contains <a>FieldToMatch</a>, <code>PositionalConstraint</code>,
     * <code>TargetString</code>, and <code>TextTransformation</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the <a>ByteMatchSet</a> that you specified in the <code>GetByteMatchSet</code> request.
     *         For more information, see the following topics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a>ByteMatchSet</a>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and
     *         <code>Name</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ByteMatchTuples</code>: Contains an array of <a>ByteMatchTuple</a> objects. Each
     *         <code>ByteMatchTuple</code> object contains <a>FieldToMatch</a>, <code>PositionalConstraint</code>,
     *         <code>TargetString</code>, and <code>TextTransformation</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
     *         </p>
     *         </li>
     */
    public final ByteMatchSet byteMatchSet() {
        return byteMatchSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byteMatchSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetByteMatchSetResponse)) {
            return false;
        }
        GetByteMatchSetResponse other = (GetByteMatchSetResponse) obj;
        return Objects.equals(byteMatchSet(), other.byteMatchSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetByteMatchSetResponse").add("ByteMatchSet", byteMatchSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByteMatchSet":
            return Optional.ofNullable(clazz.cast(byteMatchSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetByteMatchSetResponse, T> g) {
        return obj -> g.apply((GetByteMatchSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetByteMatchSetResponse> {
        /**
         * <p>
         * Information about the <a>ByteMatchSet</a> that you specified in the <code>GetByteMatchSet</code> request. For
         * more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ByteMatchSet</a>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ByteMatchTuples</code>: Contains an array of <a>ByteMatchTuple</a> objects. Each
         * <code>ByteMatchTuple</code> object contains <a>FieldToMatch</a>, <code>PositionalConstraint</code>,
         * <code>TargetString</code>, and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param byteMatchSet
         *        Information about the <a>ByteMatchSet</a> that you specified in the <code>GetByteMatchSet</code>
         *        request. For more information, see the following topics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a>ByteMatchSet</a>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and
         *        <code>Name</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ByteMatchTuples</code>: Contains an array of <a>ByteMatchTuple</a> objects. Each
         *        <code>ByteMatchTuple</code> object contains <a>FieldToMatch</a>, <code>PositionalConstraint</code>,
         *        <code>TargetString</code>, and <code>TextTransformation</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byteMatchSet(ByteMatchSet byteMatchSet);

        /**
         * <p>
         * Information about the <a>ByteMatchSet</a> that you specified in the <code>GetByteMatchSet</code> request. For
         * more information, see the following topics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a>ByteMatchSet</a>: Contains <code>ByteMatchSetId</code>, <code>ByteMatchTuples</code>, and
         * <code>Name</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ByteMatchTuples</code>: Contains an array of <a>ByteMatchTuple</a> objects. Each
         * <code>ByteMatchTuple</code> object contains <a>FieldToMatch</a>, <code>PositionalConstraint</code>,
         * <code>TargetString</code>, and <code>TextTransformation</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a>FieldToMatch</a>: Contains <code>Data</code> and <code>Type</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link ByteMatchSet.Builder} avoiding the need to
         * create one manually via {@link ByteMatchSet#builder()}.
         *
         * When the {@link Consumer} completes, {@link ByteMatchSet.Builder#build()} is called immediately and its
         * result is passed to {@link #byteMatchSet(ByteMatchSet)}.
         * 
         * @param byteMatchSet
         *        a consumer that will call methods on {@link ByteMatchSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #byteMatchSet(ByteMatchSet)
         */
        default Builder byteMatchSet(Consumer<ByteMatchSet.Builder> byteMatchSet) {
            return byteMatchSet(ByteMatchSet.builder().applyMutation(byteMatchSet).build());
        }
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private ByteMatchSet byteMatchSet;

        private BuilderImpl() {
        }

        private BuilderImpl(GetByteMatchSetResponse model) {
            super(model);
            byteMatchSet(model.byteMatchSet);
        }

        public final ByteMatchSet.Builder getByteMatchSet() {
            return byteMatchSet != null ? byteMatchSet.toBuilder() : null;
        }

        @Override
        public final Builder byteMatchSet(ByteMatchSet byteMatchSet) {
            this.byteMatchSet = byteMatchSet;
            return this;
        }

        public final void setByteMatchSet(ByteMatchSet.BuilderImpl byteMatchSet) {
            this.byteMatchSet = byteMatchSet != null ? byteMatchSet.build() : null;
        }

        @Override
        public GetByteMatchSetResponse build() {
            return new GetByteMatchSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
