/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.waf.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRateBasedRuleManagedKeysResponse extends WafResponse implements
        ToCopyableBuilder<GetRateBasedRuleManagedKeysResponse.Builder, GetRateBasedRuleManagedKeysResponse> {
    private static final SdkField<List<String>> MANAGED_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ManagedKeys")
            .getter(getter(GetRateBasedRuleManagedKeysResponse::managedKeys))
            .setter(setter(Builder::managedKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(GetRateBasedRuleManagedKeysResponse::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_KEYS_FIELD,
            NEXT_MARKER_FIELD));

    private final List<String> managedKeys;

    private final String nextMarker;

    private GetRateBasedRuleManagedKeysResponse(BuilderImpl builder) {
        super(builder);
        this.managedKeys = builder.managedKeys;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedKeys() {
        return managedKeys != null && !(managedKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedKeys} method.
     * </p>
     * 
     * @return An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
     */
    public final List<String> managedKeys() {
        return managedKeys;
    }

    /**
     * <p>
     * A null value and not currently used.
     * </p>
     * 
     * @return A null value and not currently used.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedKeys() ? managedKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRateBasedRuleManagedKeysResponse)) {
            return false;
        }
        GetRateBasedRuleManagedKeysResponse other = (GetRateBasedRuleManagedKeysResponse) obj;
        return hasManagedKeys() == other.hasManagedKeys() && Objects.equals(managedKeys(), other.managedKeys())
                && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRateBasedRuleManagedKeysResponse")
                .add("ManagedKeys", hasManagedKeys() ? managedKeys() : null).add("NextMarker", nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManagedKeys":
            return Optional.ofNullable(clazz.cast(managedKeys()));
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRateBasedRuleManagedKeysResponse, T> g) {
        return obj -> g.apply((GetRateBasedRuleManagedKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WafResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetRateBasedRuleManagedKeysResponse> {
        /**
         * <p>
         * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * </p>
         * 
         * @param managedKeys
         *        An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeys(Collection<String> managedKeys);

        /**
         * <p>
         * An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * </p>
         * 
         * @param managedKeys
         *        An array of IP addresses that currently are blocked by the specified <a>RateBasedRule</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedKeys(String... managedKeys);

        /**
         * <p>
         * A null value and not currently used.
         * </p>
         * 
         * @param nextMarker
         *        A null value and not currently used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends WafResponse.BuilderImpl implements Builder {
        private List<String> managedKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRateBasedRuleManagedKeysResponse model) {
            super(model);
            managedKeys(model.managedKeys);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getManagedKeys() {
            if (managedKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return managedKeys;
        }

        public final void setManagedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
        }

        @Override
        @Transient
        public final Builder managedKeys(Collection<String> managedKeys) {
            this.managedKeys = ManagedKeysCopier.copy(managedKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder managedKeys(String... managedKeys) {
            managedKeys(Arrays.asList(managedKeys));
            return this;
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        @Transient
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public GetRateBasedRuleManagedKeysResponse build() {
            return new GetRateBasedRuleManagedKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
